/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.IndexPropertyDialogOraclev9i;

public class IndexProxyOraclev9i
extends IndexProxyOracle {
    private String nonLeaf = "NO";
    private int batchSize = 1000;
    TableSpaceOracle workTablespace = null;

    public IndexProxyOraclev9i(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyOraclev9i(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogOraclev9i dialog = new IndexPropertyDialogOraclev9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getLayerType() {
        return this.getIndex().getLayerType();
    }

    public String etGeodetic() {
        return this.getIndex().getGeodetic();
    }

    public String getDimensionsNumber() {
        return String.valueOf(this.getIndex().getDimensionsNumber());
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public TableSpaceOracle getWorkTablespace() {
        return this.workTablespace;
    }

    public void setWorkTablespace(TableSpaceOracle workTablespace) {
        this.workTablespace = workTablespace;
    }

    public String getNonLeaf() {
        return this.nonLeaf;
    }

    public void setNonLeaf(String nonLeaf) {
        if (ConstantsOracle.checkYesNo(nonLeaf)) {
            this.nonLeaf = nonLeaf;
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)((StorageDesignOraclev9i)targetDesign).getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getObject().getName());
        IndexProxyOraclev9i indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev9i)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyOraclev9i)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            if (this.getIndexGlobalPartitionsList() != null) {
                IndexGlobalPartitionsListOraclev9i indexList = (IndexGlobalPartitionsListOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionsListSet().getByName(this.getIndexGlobalPartitionsList().getName());
                if (indexList == null) {
                    IndexGlobalPartitionsListOraclev9i newIndexList = (IndexGlobalPartitionsListOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    newIndexList.setName(this.getIndexGlobalPartitionsList().getName());
                    newIndexList.setRawObject(true);
                    newIndexList.setIndex(indexProxy);
                    indexProxy.setIndexGlobalPartitionsList(newIndexList);
                } else {
                    indexList.setIndex(indexProxy);
                    indexProxy.setIndexGlobalPartitionsList(indexList);
                }
            }
            for (IndexGlobalPartitionOraclev9i indexPart : this.partitions) {
                IndexGlobalPartitionOraclev9i targetIndexPart = (IndexGlobalPartitionOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionSet().getByName(indexPart.getName());
                if (targetIndexPart == null) {
                    IndexGlobalPartitionOraclev9i newIndexPart = (IndexGlobalPartitionOraclev9i)((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionSet().createIndexGlobalPartition();
                    newIndexPart.setName(indexPart.getName());
                    newIndexPart.setRawObject(true);
                    newIndexPart.setIndexGlobalPartList(indexProxy.getIndexGlobalPartitionsList());
                    indexProxy.addIGPFromDesign(((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionSet());
                    continue;
                }
                indexPart.setIndexGlobalPartList(indexProxy.getIndexGlobalPartitionsList());
                indexProxy.addIGPFromDesign(((StorageDesignOraclev9i)targetDesign).getIndexGlobalPartitionSet());
            }
            if (this.getUser() != null) {
                UserOraclev9i idxUser = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (idxUser == null) {
                    UserOraclev9i newIdxUser = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().createUser();
                    newIdxUser.setName(this.getUser().getName());
                    newIdxUser.setRawObject(true);
                    indexProxy.setUser(newIdxUser);
                } else {
                    indexProxy.setUser(idxUser);
                }
            }
            indexProxy.setBitmapIndex(this.getBitmapIndex());
            indexProxy.setIndexPartitioned(this.getIndexPartitioned());
            if (this.getTableSpace() != null) {
                TableSpaceOraclev9i idxTblSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().getByName(this.getTableSpace().getName());
                if (idxTblSpace == null) {
                    TableSpaceOraclev9i newTableSpace = (TableSpaceOraclev9i)((StorageDesignOraclev9i)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    indexProxy.setTableSpace(newTableSpace);
                } else {
                    indexProxy.setTableSpace(idxTblSpace);
                }
            }
            indexProxy.setLogging(this.getLogging());
            if (this.getSegment() != null) {
                SegmentOraclev9i idxSegment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().getByName(this.getSegment().getName());
                if (idxSegment == null) {
                    SegmentOraclev9i newSegment = (SegmentOraclev9i)((StorageDesignOraclev9i)targetDesign).getSegmentSet().createSegment();
                    newSegment.setName(this.getSegment().getName());
                    newSegment.setRawObject(true);
                    indexProxy.setSegment(newSegment);
                } else {
                    indexProxy.setSegment(idxSegment);
                }
            }
            indexProxy.setCompress(this.getCompress());
            indexProxy.setParallel(this.getParallel());
            indexProxy.setDegree(this.getDegree());
            indexProxy.setSortedRows(this.getSortedRows());
            indexProxy.setComputeStatistics(this.getComputeStatistics());
            indexProxy.setOnline(this.getOnline());
            indexProxy.setRawObject(false);
        }
    }
}

