/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.RulePropertyDialogSqlServer;

public class RuleSqlServer
extends AbstractStorageObjectSqlServer {
    private DataBaseSqlServer database;
    private UserSqlServer owner;
    private String expression = "";
    private String columns = "";
    private ColumnSet columnSet = null;
    protected SchemaSqlServer schema;
    public static final String TYPE_NAME = "Rule";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            RulePropertyDialogSqlServer dialog = new RulePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.fireDataFieldChange();
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.fireDataFieldChange();
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    private void addColumn(String column) {
        if (!this.getColumnSet().contains(column)) {
            this.getColumnSet().add(column);
        }
    }

    public void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.columns = "";
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schema) {
        this.schema = schema;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName() + "." + this.getName();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getSchema() != null) {
            name = this.getSchema().getName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("RULE_ICON", 16);
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

