/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.TablePropertyDialogSqlServer;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class TableProxySqlServer
extends TableProxy
implements ModelObjectSetListener,
StorageObjectListener,
PropertiesPropagator {
    private DataBaseSqlServer database;
    private UserSqlServer owner;
    private FileGroupSqlServer filegroup;
    private FileGroupSqlServer textImageFG;
    private StorageObjectCollection fkeys;
    private StorageObjectCollection pkeys;
    private StorageObjectCollection ukeys;
    private StorageObjectCollection triggers;
    private StorageObjectCollection instDescriptorCols;
    private SchemaSqlServer schema;
    private String props = "";
    private InlineList extPropsSet = null;
    private List propertyWrapperList = null;
    protected StorageObjectCollection synonyms;

    public TableProxySqlServer(Table table, StorageDesign storageDesign) {
        super(table, storageDesign);
        if (table.getTypeSubstitution() == null) {
            this.columns.removeAll();
            this.addColumnsFromSuccessor(table);
        }
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.pkeys = new StorageObjectCollection();
        this.pkeys.setParent(this);
        this.pkeys.setName(Messages.getString("TableProxyOracle.PrimaryKeys"));
        this.pkeys.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON", 16));
        this.ukeys = new StorageObjectCollection();
        this.ukeys.setParent(this);
        this.ukeys.setName(Messages.getString("TableProxyOracle.UniqueKeys"));
        this.ukeys.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getFKProxySet());
        ((StorageDesignSqlServer)storageDesign).getFKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getPKProxySet());
        ((StorageDesignSqlServer)storageDesign).getPKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getUniqueProxySet());
        ((StorageDesignSqlServer)storageDesign).getUniqueProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxySqlServer.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.instDescriptorCols = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet());
        ((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
        this.setDatabase(null);
    }

    public TableProxySqlServer(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        Table table = (Table)this.getObject();
        if (table.getTypeSubstitution() == null) {
            this.columns.removeAll();
            this.addColumnsFromSuccessor(table);
        }
        this.fkeys = new StorageObjectCollection();
        this.fkeys.setParent(this);
        this.fkeys.setName(Messages.getString("TableProxyOracle.ForeignKeys"));
        this.fkeys.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON", 16));
        this.pkeys = new StorageObjectCollection();
        this.pkeys.setParent(this);
        this.pkeys.setName(Messages.getString("TableProxyOracle.PrimaryKeys"));
        this.pkeys.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON", 16));
        this.ukeys = new StorageObjectCollection();
        this.ukeys.setParent(this);
        this.ukeys.setName(Messages.getString("TableProxyOracle.UniqueKeys"));
        this.ukeys.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getFKProxySet());
        ((StorageDesignSqlServer)storageDesign).getFKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getPKProxySet());
        ((StorageDesignSqlServer)storageDesign).getPKProxySet().addSetListener(this);
        this.addIndProxiesFromDesign(((StorageDesignSqlServer)storageDesign).getUniqueProxySet());
        ((StorageDesignSqlServer)storageDesign).getUniqueProxySet().addSetListener(this);
        this.triggers = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.triggers.setParent(this);
        this.triggers.setName(Messages.getString("TableProxyOracle.Triggers"));
        this.triggers.setClassForParent(TableProxySqlServer.class);
        this.triggers.setSetMethod("setTable");
        this.triggers.setIcon(GUIConfiguration.getInstance().getIcon("TRIGGER_FOLDER_ICON", 16));
        ((StorageDesignSqlServer)storageDesign).getTriggerSet().addSetListener(this);
        this.addTriggersFromDesign(((StorageDesignSqlServer)storageDesign).getTriggerSet());
        this.instDescriptorCols = new StorageObjectCollection(((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet());
        ((StorageDesignSqlServer)storageDesign).getInstanceDescriptorColumnSet().addSetListener(this);
        this.setDatabase(null);
    }

    private void addColumnsFromSuccessor(Table table) {
        for (Column col : table.getAllNestedElements()) {
            ColumnProxy colProxy;
            if (!col.isAtomic() && (col.getStructuredType() == null || col.getStructuredType().getAttributesCount() != 0) || (colProxy = (ColumnProxy)this.getStorageDesign().getProxy(col)) == null) continue;
            colProxy.setParent(this.columns);
            this.columns.add(colProxy);
            colProxy.setName(col.getName());
        }
    }

    public boolean existClusteredIndex(IndexProxy index) {
        IndexProxy[] indexes = this.getIndexProxies();
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == null || indexes[i] == index || !indexes[i].isClustered()) continue;
            return true;
        }
        for (PKProxySqlServer pkey : this.pkeys) {
            if (pkey == index || !pkey.isClustered()) continue;
            return true;
        }
        for (UniqueProxySqlServer ukey : this.ukeys) {
            if (ukey == index || !ukey.isClustered()) continue;
            return true;
        }
        return false;
    }

    public int getClusteredIndexCount() {
        int count = 0;
        IndexProxy[] indexes = this.getIndexProxies();
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == null || !indexes[i].isClustered()) continue;
            ++count;
        }
        for (PKProxySqlServer pkey : this.pkeys) {
            if (!pkey.isClustered()) continue;
            ++count;
        }
        for (UniqueProxySqlServer ukey : this.ukeys) {
            if (!ukey.isClustered()) continue;
            ++count;
        }
        return count;
    }

    public boolean existRowGuidColUniqueID(ColumnProxySqlServer column) {
        ColumnProxy[] columns = this.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null || columns[i] == column || !((ColumnProxySqlServer)columns[i]).getDataTypeName().equalsIgnoreCase("uniqueidentifier") || !((ColumnProxySqlServer)columns[i]).getRowGuidCol().equalsIgnoreCase("YES")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 4;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index == this.getNumberOfChildren() - 1) {
            return this.pkeys;
        }
        if (index == this.getNumberOfChildren() - 2) {
            return this.fkeys;
        }
        if (index == this.getNumberOfChildren() - 3) {
            return this.ukeys;
        }
        if (index == this.getNumberOfChildren() - 4) {
            return this.triggers;
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.pkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.fkeys) {
            return this.getNumberOfChildren() - 2;
        }
        if (child == this.ukeys) {
            return this.getNumberOfChildren() - 3;
        }
        if (child == this.triggers) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.pkeys) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.fkeys) {
            return this.getNumberOfChildren() - 2;
        }
        if (child == this.ukeys) {
            return this.getNumberOfChildren() - 3;
        }
        if (child == this.triggers) {
            return this.getNumberOfChildren() - 4;
        }
        return super.getIndexForChild(child);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TablePropertyDialogSqlServer dialog = new TablePropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void changed(RelationalObjectProxySet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ColumnProxy) {
                ColumnProxy cp = (ColumnProxy)event.getAffected();
                if (this.getObject() == ((Column)cp.getObject()).getContainerWithKeyObject()) {
                    this.columns.add(event.getAffected());
                }
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                Index ind = (Index)ip.getObject();
                if (this.getObject() == ind.getContainerWithKeyObject()) {
                    if (ind.isFK() && !this.fkeys.contains(ip)) {
                        ip.setParent(this.fkeys);
                        this.fkeys.add(ip);
                    } else if (ind.isPK() && !this.pkeys.contains(ip)) {
                        ip.setParent(this.pkeys);
                        this.pkeys.add(ip);
                    } else if (ind.isUnique() && !this.ukeys.contains(ip)) {
                        ip.setParent(this.ukeys);
                        this.ukeys.add(ip);
                    } else if (!this.indexes.contains(ip)) {
                        ip.setParent(this.indexes);
                        this.indexes.add(event.getAffected());
                    }
                } else if (event.getAffected() instanceof TriggerSqlServer) {
                    TriggerSqlServer triggerSqlServer = (TriggerSqlServer)event.getAffected();
                    triggerSqlServer.addObjectListener(this);
                    if (triggerSqlServer.getTable() == this) {
                        triggerSqlServer.setParent(this.triggers);
                        this.triggers.add(triggerSqlServer);
                    } else {
                        this.triggers.remove(triggerSqlServer);
                    }
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof ColumnProxy) {
                this.columns.remove(((ColumnProxy)event.getAffected()).getObject().getObjectID());
            } else if (event.getAffected() instanceof IndexProxy) {
                IndexProxy ip = (IndexProxy)event.getAffected();
                if (this.indexes.contains(ip)) {
                    this.indexes.remove(event.getAffected());
                }
                if (this.pkeys.contains(ip)) {
                    this.pkeys.remove(event.getAffected());
                }
                if (this.ukeys.contains(ip)) {
                    this.ukeys.remove(event.getAffected());
                }
                if (this.fkeys.contains(ip)) {
                    this.fkeys.remove(event.getAffected());
                }
            } else if (event.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer triggersSqlServer = (TriggerSqlServer)event.getAffected();
                this.triggers.remove(triggersSqlServer);
                triggersSqlServer.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof TriggerSqlServer) {
            TriggerSqlServer tr = (TriggerSqlServer)event.getAffected();
            if (tr.getTable() == this) {
                tr.setParent(this.triggers);
                this.triggers.add(tr);
            } else {
                this.triggers.remove(tr);
            }
        } else if (event.getAffected() instanceof InstanceDescriptorColumnSqlServer) {
            InstanceDescriptorColumnSqlServer instCol = (InstanceDescriptorColumnSqlServer)event.getAffected();
            if (instCol.getTable() == this) {
                instCol.setParent(this.instDescriptorCols);
                this.instDescriptorCols.add(instCol);
            } else {
                this.instDescriptorCols.remove(instCol);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer tr = (TriggerSqlServer)event.getAffected();
                tr.addObjectListener(this);
                if (tr.getTable() == this) {
                    tr.setParent(this.triggers);
                    this.triggers.add(tr);
                } else {
                    this.triggers.remove(tr);
                }
            } else if (event.getAffected() instanceof InstanceDescriptorColumnSqlServer) {
                InstanceDescriptorColumnSqlServer instCol = (InstanceDescriptorColumnSqlServer)event.getAffected();
                instCol.addObjectListener(this);
                if (instCol.getTable() == this) {
                    instCol.setParent(this.instDescriptorCols);
                    this.instDescriptorCols.add(instCol);
                } else {
                    this.instDescriptorCols.remove(instCol);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof TriggerSqlServer) {
                TriggerSqlServer tr = (TriggerSqlServer)event.getAffected();
                this.triggers.remove(tr);
                tr.removeObjectListener(this);
            } else if (event.getAffected() instanceof InstanceDescriptorColumnSqlServer) {
                InstanceDescriptorColumnSqlServer instCol = (InstanceDescriptorColumnSqlServer)event.getAffected();
                this.instDescriptorCols.remove(instCol);
                instCol.removeObjectListener(this);
            }
        }
    }

    private void addIndProxiesFromDesign(RelationalObjectProxySet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            IndexProxy ip = (IndexProxy)it.next();
            Index ind = (Index)ip.getObject();
            if (this.getObject() != ind.getContainerWithKeyObject()) continue;
            if (ind.isFK()) {
                ip.setParent(this.fkeys);
                this.fkeys.add(ip);
                continue;
            }
            if (ind.isPK()) {
                ip.setParent(this.pkeys);
                this.pkeys.add(ip);
                continue;
            }
            if (!ind.isUnique()) continue;
            ip.setParent(this.ukeys);
            this.ukeys.add(ip);
        }
    }

    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database == null && ((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().hasNullInstance() ? (DataBaseSqlServer)((StorageDesignSqlServer)this.getStorageDesign()).getDataBaseSet().getNullInstance() : database;
        this.fireDataFieldChange();
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer filegroup) {
        this.filegroup = filegroup;
        this.fireDataFieldChange();
    }

    public UserSqlServer getUser() {
        return this.owner;
    }

    public void setUser(UserSqlServer owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public FileGroupSqlServer getTextImageFG() {
        return this.textImageFG;
    }

    public void setTextImageFG(FileGroupSqlServer textImageFG) {
        this.textImageFG = textImageFG;
        this.fireDataFieldChange();
    }

    protected void addTriggersFromDesign(StorageObjectSet set) {
        for (TriggerSqlServer trigger : set) {
            trigger.addObjectListener(this);
            if (trigger.getTable() == this) {
                trigger.setParent(this.triggers);
                this.triggers.add(trigger);
                continue;
            }
            this.triggers.remove(trigger);
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String prop) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(prop);
        } else {
            this.addExtProperty(prop);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String props2) {
        this.getExtPropsSet().add(props2);
    }

    protected void recreateExtPropertiesSet(String props1) {
        this.getExtPropsSet().clear();
        StringTokenizer st = new StringTokenizer(props1, ",");
        this.extPropsSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getExtPropsSet().add(st.nextToken().trim());
        }
    }

    public StorageObjectCollection getFkeys() {
        return this.fkeys;
    }

    public void setFkeys(StorageObjectCollection fkeys) {
        this.fkeys = fkeys;
    }

    public StorageObjectCollection getPkeys() {
        return this.pkeys;
    }

    public void setPkeys(StorageObjectCollection pkeys) {
        this.pkeys = pkeys;
    }

    @Override
    public StorageObjectCollection getTriggers() {
        return this.triggers;
    }

    public void setTriggers(StorageObjectCollection triggers) {
        this.triggers = triggers;
    }

    public StorageObjectCollection getUkeys() {
        return this.ukeys;
    }

    public void setUkeys(StorageObjectCollection ukeys) {
        this.ukeys = ukeys;
    }

    @Override
    public IndexProxy[] getIndexProxies() {
        KeyObject[] keys = ((Table)this.getObject()).getKeys();
        ArrayList<IndexProxy> col = new ArrayList<IndexProxy>();
        for (int i = 0; i < keys.length; ++i) {
            IndexProxy ip = null;
            if (!(keys[i].isPK() || keys[i].isUnique() || keys[i].isFK())) {
                ip = (IndexProxy)this.getStorageDesign().getIndexProxySet().getProxy(keys[i].getObjectID());
            }
            if (ip == null) continue;
            col.add(ip);
        }
        return col.toArray(new IndexProxy[0]);
    }

    @Override
    public StorageObject getUserSchema() {
        return this.getUser();
    }

    public StorageObjectCollection getInstanceDescriptorCols() {
        return this.instDescriptorCols;
    }

    public InstanceDescriptorColumnSqlServer createInstanceDescriptorCol() {
        if (this.instDescriptorCols.getStorageObjectSet() != null) {
            return (InstanceDescriptorColumnSqlServer)this.instDescriptorCols.createElement(null);
        }
        return null;
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schema) {
        this.schema = schema;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
    }

    @Override
    public void remove() {
        Object[] trigs = this.triggers.toArray();
        for (int i = 0; i < trigs.length; ++i) {
            TriggerSqlServer trig = (TriggerSqlServer)trigs[i];
            trig.remove();
            trig.setTable(null);
            this.triggers.remove(trig);
        }
        super.remove();
    }

    @Override
    public int getMaxNameLength() {
        return 128;
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Database", this, "getDatabase", "setDatabase", DataBaseSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Owner", this, "getUser", "setUser", UserSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("Filegroup", this, "getFilegroup", "setFilegroup", FileGroupSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper("TEXTIMAGE group", this, "getTextImageFG", "setTextImageFG", FileGroupSqlServer.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public boolean shouldBeDroppedIndirectly() {
        if (Design.USE_DROP_DEPENDENCY) {
            return this.getDatabase().isDropEnabled() || this.getDatabase().shouldBeDroppedIndirectly();
        }
        return false;
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            ArrayList list = new ArrayList();
            if (this.synonyms != null) {
                this.synonyms.addAllElementsTo(list);
            }
            for (StorageObject st : list) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        ContainerObject co = (ContainerObject)this.getObject();
        SchemaObject so = co.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignSqlServer)this.getStorageDesign()).getUserSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    @Override
    public String getLongNameDDL() {
        if (this.getStorageDesign().isOpen() && this.getStorageDesign().getAppView().getSettings().isIncludeSchemaInDDL()) {
            String lname = this.getLongName();
            if (lname.startsWith("\"\".") || lname.startsWith(".")) {
                return this.getName();
            }
            return lname;
        }
        return this.getName();
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

