/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.logical.DREntity;

public class DREntityNoKey
extends DREntity {
    private final String RULE_ID = "B13D2D93-7513-27D9-42F5-1D3B347463C1";

    public DREntityNoKey() {
        this.setName(Messages.getString("DREntityNoKey.IdentifyEntitiesWithoutKeys"));
        this.setDescription(Messages.getString("DREntityNoKey.EntitiesWithoutKeysNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Entity entity = (Entity)object;
        this.setEntityToCheck(entity);
        Entity entityToCheck = this.getEntityToCheck();
        if (entity.getKeySet().size() > 0) {
            this.clearEntityToCheck();
            return CheckResult.createOk(entityToCheck, this, Messages.getString("DREntityNoKey.EntityHasAtLeastOneKey"));
        }
        Entity superEntity = entity.getHierarchicalParent();
        if (superEntity != null) {
            return this.doCheck(superEntity);
        }
        this.clearEntityToCheck();
        return CheckResult.createWarning(entityToCheck, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B13D2D93-7513-27D9-42F5-1D3B347463C1";
    }
}

