/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRColumnNamingStandard
extends DesignRule {
    private final String RULE_ID = "F65408E2-1E0A-088D-97FC-CC1840290370";
    private NamingStandardRule namingRule;

    public DRColumnNamingStandard() {
        this.setName(Messages.getString("DRColumnNamingStandard.IdentifyColumnsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRColumnNamingStandard.ColumnsWithWrongNamingStandardsAreNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        int ctype;
        Column column = (Column)object;
        this.namingRule = column.getDesign().getDesignLevelSettings().getNamingStandardRule();
        Iterator it = this.namingRule.getGlossaries().iterator();
        Object errors = "";
        NamingOptionsHolder oph = column.getDesignPart().getNamingOptionsHolderFor(Column.class);
        if (oph == null) {
            oph = column.getDesignPart().getNamingOptionsHolderFor(Column.class);
        }
        boolean upperCaseOnly = false;
        if (oph != null && (ctype = oph.getCaseType()) == 0) {
            upperCaseOnly = true;
        }
        char relSep = this.namingRule.getRelationalSeparatorChar();
        boolean abbreviatedOnly = this.namingRule.isAbbreviatedOnly();
        while (it.hasNext()) {
            Glossary glossary = (Glossary)it.next();
            String error = glossary.checkValidName(column.getName(), this.namingRule.getColumnsList(), relSep, false, upperCaseOnly, true, abbreviatedOnly);
            if (error == null) {
                return CheckResult.createOk(column, this, Messages.getString("DRColumnNamingStandard.ColumnNmeIsInValidFormat"));
            }
            if (((String)errors).length() == 0) {
                errors = error;
                continue;
            }
            errors = (String)errors + ". " + error;
        }
        if ("".equals(errors)) {
            return CheckResult.createOk(column, this, Messages.getString("DRColumnNamingStandard.ColumnNameIsInValidFormat"));
        }
        return CheckResult.createWarning(column, this, (String)errors);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "F65408E2-1E0A-088D-97FC-CC1840290370";
    }
}

