/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDefaultEmptyConstant
extends AbstractDRStorageDesign {
    private final String RULE_ID = "9C2A5A3C-9489-F4F6-4002-E94B7CF02166";

    public DRDefaultEmptyConstant(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDefaultEmptyConstant.CheckForEmptyConstant"));
        this.setDescription(Messages.getString("DRDefaultEmptyConstant.TheConstantShouldNotBeEmpty"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DefaultSqlServer def = (DefaultSqlServer)object;
        if ("".equalsIgnoreCase(def.getConstant())) {
            return CheckResult.createFailed(object, this, Messages.getString("DRDefaultEmptyConstant.TheConstantOfDefaultObjectIsEmpty"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRDefaultEmptyConstant.TheConstantOfDefaultObjectIsNotEmpty"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "9C2A5A3C-9489-F4F6-4002-E94B7CF02166";
    }
}

