/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.ReservedWordsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRReservedWordNameUDB
extends AbstractDRStorageDesign {
    private final String RULE_ID = "E4A95109-6DCA-C36A-00A6-64EBD8829104";
    private ReservedWordsUDB reserved = new ReservedWordsUDB();
    private StorageDesignUDB stoDesign = null;

    public DRReservedWordNameUDB(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRReservedWordNameUDB.IdentifyObjectsUsingReservedWords"));
        this.setDescription(Messages.getString("DRReservedWordNameUDB.ObjectIdentifierShouldNotBeReservedWord"));
        this.stoDesign = (StorageDesignUDB)storageDesign;
    }

    @Override
    public CheckResult doCheck(Object object) {
        this.stoDesign.updateGeneralRule();
        ModelIDObject modelIDObject = (ModelIDObject)object;
        String name = modelIDObject.getName();
        if (this.reserved.isReservedWord(name)) {
            return CheckResult.createWarning(modelIDObject, this, MessageFormat.format(Messages.getString("DRReservedWordNameUDB.NameIsReservedWord"), name));
        }
        Iterator it = this.stoDesign.getStructuredTypeProxySet().iterator();
        while (it.hasNext()) {
            StructuredTypeProxyUDB struType = (StructuredTypeProxyUDB)it.next();
            if (!struType.getName().equalsIgnoreCase(name)) continue;
            return CheckResult.createWarning(modelIDObject, this, Messages.getString("DRReservedWordNameUDB.ThereIsStructuredTypeWithSameName"));
        }
        return CheckResult.createOk(modelIDObject, this, Messages.getString("DRReservedWordNameUDB.TheNameIsNotReservedWord"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "E4A95109-6DCA-C36A-00A6-64EBD8829104";
    }
}

