/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.reference.CompositeReference;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.Reference;
import oracle.dbtools.crest.model.reference.ReferenceSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLLogicalDesign
extends AbstractXMLReader {
    private boolean xmlFromDB = false;
    private static Logger LOGGER;
    private static float NFS;
    private float loadedVersion = NFS;

    public RXMLLogicalDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        String aID;
        int i;
        this.loadedVersion = design.getDesign().getLoadedVersion();
        this.xmlFromDB = this.getPersistenceManager().isXML_FromDataBase();
        Element root = doc.getDocumentElement();
        String id = root.getAttribute("id");
        if (!"".equalsIgnoreCase(id)) {
            design.setObjectID(StringUtilities.decodeAttributeValue(id));
        }
        DesignPartView dpv = null;
        if (this.loadedVersion < NFS) {
            dpv = design.getMainView();
            int ind = dpv.getTabbedPane().indexOfComponent(dpv.getMainPanel());
            if (ind < 0) {
                dpv.getTabbedPane().setName(dpv.getName());
                dpv.getTabbedPane().add(dpv.getMainPanel());
            }
            this.readDisplayProperties(root, dpv);
            dpv.getWorkSpace().updateSettings();
        }
        NodeList objectElements = RXMLLogicalDesign.getFirstChildByTagName(root, "ref").getElementsByTagName("objectid");
        int length = objectElements.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Element elm = (Element)objectElements.item(i2);
            String role = elm.getAttribute("role");
            String oid = elm.getAttribute("oid");
            boolean getlock = "contains".equalsIgnoreCase(role) && tryReadWriteLocking;
            DesignObject object = null;
            object = !this.xmlFromDB ? (DesignObject)this.getPersistenceManager().read((Object)oid, design.getDesign(), getlock) : design.getDesign().getDesignObject(oid);
            if (object != null) {
                object.setTemporaryWriteable(true);
                if (!object.belongsToDesign(design.getDesign())) {
                    object.setReadOnly(true);
                }
                if (this.loadedVersion < NFS) {
                    this.readGraphicalInfo(elm, object);
                }
                object.setTemporaryWriteable(false);
                continue;
            }
            LOGGER.error("Read object returns null");
        }
        Map objMap = this.getProperties(root, "documents");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addDocument((BIDocument)object);
        }
        objMap = this.getProperties(root, "parties");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            aID = (String)objMap.get(objects[i]);
            DesignObject object = design.getDesign().getDesignObject(aID);
            if (object == null) continue;
            design.addResponsibleParty((BIResponsibleParty)object);
        }
        this.getPersistenceManager().runTasks();
        if (this.loadedVersion < NFS) {
            this.readViewSynonyms(root, (LogicalDesign)design);
            this.readRelationToSynonyms(root, (LogicalDesign)design);
        }
        this.readTypeSubstitutions(root, (LogicalDesign)design);
        if (this.loadedVersion < NFS) {
            this.readSubordinateDisplays(root, dpv);
            dpv.getTabbedPane().setSelectedComponent(dpv.getMainPanel());
            this.readLogicalSubViews(root, (LogicalDesign)design);
            this.readDiagramViews(root, design);
        } else if (!this.xmlFromDB) {
            RXMLSubview rsv = this.getPersistenceManager().getDesignPartViewReader();
            rsv.readExtSubViews(root, design);
        }
        this.resetRelations((LogicalDesign)design);
        this.readNamingOptions(root, design);
        this.updateKeysElements((LogicalDesign)design);
        design.setLoaded(true);
        return design;
    }

    private void resetRelations(LogicalDesign design) {
        Iterator it = design.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            rel.setCardinality(0, rel.getCardinality(0));
        }
    }

    @Override
    protected Map getProperties(Element objInfo, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Element propertiesElm = RXMLLogicalDesign.getFirstChildByTagName(objInfo, id);
        if (propertiesElm != null) {
            NodeList propList = propertiesElm.getElementsByTagName("parameter");
            int length = propList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)propList.item(j);
                map.put(param.getAttribute("name"), param.getAttribute("value"));
            }
        }
        return map;
    }

    protected DesignObject instantiateDesignObject(String objectID, Design design) {
        return design.getBusinessInfoDesign().getDocumentSet().createDocument(StringUtilities.decodeAttributeValue(objectID));
    }

    private void readLogicalSubViews(Element root, LogicalDesign design) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadLogicalSubViews"));
        if (design.getAppView() != null) {
            EntitySet ents = design.getEntitySet();
            Element dpvlist = RXMLLogicalDesign.getFirstChildByTagName(root, "logical_sub_views_collection");
            if (dpvlist != null) {
                NodeList objectElements = dpvlist.getElementsByTagName("logical_sub_view");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    Element elm = (Element)objectElements.item(i);
                    String dpvName = elm.getAttribute("subview_name");
                    String dpvId = elm.getAttribute("id");
                    String generatorId = elm.getAttribute("generator");
                    DesignPartView dpv = design.createDesignPartSubView();
                    this.readDisplayProperties(elm, dpv);
                    dpv.setName(StringUtilities.decodeAttributeValue(dpvName));
                    dpv.setVisible(false);
                    if (dpvId != null && !"".equalsIgnoreCase(dpvId) && !"null".equalsIgnoreCase(dpvId)) {
                        dpv.setDPVId(dpvId);
                    }
                    if (generatorId != null && !"".equalsIgnoreCase(generatorId) && !"null".equalsIgnoreCase(generatorId)) {
                        dpv.setGeneratorId(generatorId);
                    }
                    String visible = elm.getAttribute("visible");
                    NodeList elements = elm.getElementsByTagName("objectid");
                    int ln = elements.getLength();
                    for (int k = 0; k < ln; ++k) {
                        String y;
                        String x;
                        Element point;
                        int kk;
                        TVConnector tvfk;
                        int plLength;
                        NodeList plist;
                        Element points;
                        Arc arc;
                        String tvgenId;
                        String vid;
                        TopView tvt;
                        ContainerWithKeyObject tab;
                        Element tv = (Element)elements.item(k);
                        if (tv.getParentNode() != elm) continue;
                        String type = tv.getAttribute("type");
                        String oid = tv.getAttribute("oid");
                        if (type.equalsIgnoreCase("Entity")) {
                            tab = (Entity)ents.getObjectByID(oid);
                            tvt = (TVEntity)dpv.createTopViewFor(tab);
                            vid = tv.getAttribute("viewid");
                            tvgenId = tv.getAttribute("tv_generator_id");
                            tvt.setViewID(vid);
                            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                                tvt.setGeneratorID(tvgenId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("VIEW") && (tab = (EntityView)design.getDesign().getDesignObject(oid)) != null) {
                            tvt = dpv.createTopViewFor(tab);
                            vid = tv.getAttribute("viewid");
                            tvgenId = tv.getAttribute("tv_generator_id");
                            tvt.setViewID(vid);
                            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                                tvt.setGeneratorID(tvgenId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("Arc") && (arc = (Arc)design.getDesign().getDesignObject(oid)) != null) {
                            tvt = dpv.createTopViewFor(arc);
                            vid = tv.getAttribute("viewid");
                            tvgenId = tv.getAttribute("tv_generator_id");
                            tvt.setViewID(vid);
                            if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                                tvt.setGeneratorID(tvgenId);
                            }
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("Note")) {
                            Note note = (Note)this.getPersistenceManager().read((Object)oid, design.getDesign(), true);
                            tvt = (TVNote)dpv.createTopViewFor(note);
                            TVNote mainTV = (TVNote)note.getFirstViewForDPV(dpv.getDesignPart().getMainView());
                            if (mainTV != null) {
                                mainTV.remove(false);
                            }
                            String vid2 = tv.getAttribute("viewid");
                            ((TVNote)tvt).setViewID(vid2);
                            this.readGraphicalInfo(tv, tvt);
                        }
                        if (type.equalsIgnoreCase("Relation") || type.equalsIgnoreCase("Hierarchy relation")) {
                            Relation rel;
                            if (type.equalsIgnoreCase("Relation")) {
                                rel = (Relation)design.getRelationSet().getObjectByID(oid);
                            } else {
                                rel = (Relation)design.getInheritanceRelationSet().getObjectByID(oid);
                                if (rel != null) {
                                    // empty if block
                                }
                            }
                            if (rel != null) {
                                Element labels;
                                String svid = tv.getAttribute("viewid_source");
                                String tvid = tv.getAttribute("viewid_target");
                                if (!svid.equals("null")) {
                                    rel.setSourceTV((TVEntity)rel.getSourceEntity().getTopViewByID(dpv, svid));
                                }
                                if (!tvid.equals("null") && rel.getTargetEntity() != null) {
                                    rel.setTargetTV((TVEntity)rel.getTargetEntity().getTopViewByID(dpv, tvid));
                                }
                                if ((points = RXMLLogicalDesign.getFirstChildByTagName(tv, "points")) != null) {
                                    plist = points.getElementsByTagName("point");
                                    plLength = plist.getLength();
                                    tvfk = (TVRelation)rel.getViewFor(dpv);
                                    if (tvfk != null) {
                                        for (kk = 0; kk < plLength; ++kk) {
                                            point = (Element)plist.item(kk);
                                            x = point.getAttribute("x_coordinate");
                                            y = point.getAttribute("y_coordinate");
                                            tvfk.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                                        }
                                    }
                                }
                                if ((labels = RXMLLogicalDesign.getFirstChildByTagName(tv, "labels")) != null) {
                                    Label label;
                                    String h;
                                    String w;
                                    String y2;
                                    TVRelation tvfk2 = (TVRelation)rel.getViewFor(dpv);
                                    Element lbl = RXMLLogicalDesign.getFirstChildByTagName(labels, "source");
                                    if (lbl != null) {
                                        String x2 = lbl.getAttribute("x_coordinate");
                                        y2 = lbl.getAttribute("y_coordinate");
                                        w = lbl.getAttribute("width");
                                        h = lbl.getAttribute("height");
                                        if (w == null || "".equalsIgnoreCase(w)) {
                                            w = "-1";
                                        }
                                        if (h == null || "".equalsIgnoreCase(h)) {
                                            h = "-1";
                                        }
                                        if (x2 != null && y2 != null) {
                                            tvfk2.setSourceLabelBounds(new Rectangle((int)Double.parseDouble(x2), (int)Double.parseDouble(y2), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                                        }
                                        if ((label = tvfk2.getTempSourceLabel()) != null) {
                                            this.readColorInfo(lbl, label);
                                            this.readFontsInfo(lbl, label);
                                        }
                                    }
                                    if ((lbl = RXMLLogicalDesign.getFirstChildByTagName(labels, "target")) != null) {
                                        String x3 = lbl.getAttribute("x_coordinate");
                                        y2 = lbl.getAttribute("y_coordinate");
                                        w = lbl.getAttribute("width");
                                        h = lbl.getAttribute("height");
                                        if (w == null || "".equalsIgnoreCase(w)) {
                                            w = "-1";
                                        }
                                        if (h == null || "".equalsIgnoreCase(h)) {
                                            h = "-1";
                                        }
                                        if (x3 != null && y2 != null) {
                                            tvfk2.setTargetLabelBounds(new Rectangle((int)Double.parseDouble(x3), (int)Double.parseDouble(y2), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                                        }
                                        if ((label = tvfk2.getTempTargetLabel()) != null) {
                                            this.readColorInfo(lbl, label);
                                            this.readFontsInfo(lbl, label);
                                        }
                                    }
                                }
                            }
                        }
                        if (!type.equalsIgnoreCase("TypeSubstitution")) continue;
                        TypeSubstitution tsub = (TypeSubstitution)design.getTypeSubstitutionSet().getObjectByID(oid);
                        String chid = tv.getAttribute("view_id_child");
                        String parid = tv.getAttribute("view_id_parent");
                        if (!chid.equals("null")) {
                            tsub.setChildCV((ContainerView)tsub.getChildContainerObject().getTopViewByID(dpv, chid));
                        }
                        if (!parid.equals("null")) {
                            tsub.setParentCV((ContainerView)tsub.getParentContainerObject().getTopViewByID(dpv, parid));
                        }
                        if ((points = RXMLLogicalDesign.getFirstChildByTagName(tv, "points")) == null) continue;
                        plist = points.getElementsByTagName("point");
                        plLength = plist.getLength();
                        tvfk = (TVTypeSubstitution)tsub.getViewFor(dpv);
                        for (kk = 0; kk < plLength; ++kk) {
                            point = (Element)plist.item(kk);
                            x = point.getAttribute("x_coordinate");
                            y = point.getAttribute("y_coordinate");
                            tvfk.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                        }
                    }
                    NodeList diagramViews = elm.getElementsByTagName("diagram_view");
                    int l = diagramViews.getLength();
                    for (int m = 0; m < l; ++m) {
                        Element dvElm = (Element)diagramViews.item(m);
                        String dvID = dvElm.getAttribute("objectid");
                        String dpvID = dvElm.getAttribute("dpv_id");
                        String name = dvElm.getAttribute("dpv_name");
                        String composite = dvElm.getAttribute("composite");
                        DiagramView dv = design.recreateDiagramView(dvID);
                        dv.setDpvID(dpvID);
                        dv.setDpvName(name);
                        dv.setCompositeView(Boolean.valueOf(composite));
                        design.getDesign().addDiagramView(dv);
                        TVDiagramView tvt = (TVDiagramView)dpv.createTopViewFor(dv);
                        design.getMainView().removeViewFor(dv);
                        TopView fv = dv.getFirstViewForDPV(design.getMainView());
                        if (fv != null) {
                            dv.removeTopView(fv, true);
                        }
                        this.readGraphicalInfo(dvElm, tvt);
                    }
                    dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
                    String comment = elm.getAttribute("comment");
                    ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(comment));
                    String notes = elm.getAttribute("notes");
                    ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue(notes));
                    dpv.getTabbedPane().setName(dpv.getName());
                    dpv.getWorkSpace().updateSettings();
                    this.readSubordinateDisplays(elm, dpv);
                    dpv.getTabbedPane().setSelectedComponent(dpv.getMainPanel());
                }
            }
        }
    }

    private void readViewSynonyms(Element root, LogicalDesign design) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadViewsSynonyms"));
        if (design.getAppView() != null) {
            DesignPartView dpvl = design.getMainView();
            Element vlist = RXMLLogicalDesign.getFirstChildByTagName(root, "view_synonyms");
            if (vlist != null) {
                NodeList objectElements = vlist.getElementsByTagName("objectid");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    Element elm = (Element)objectElements.item(i);
                    String oid = elm.getAttribute("oid");
                    String vid = elm.getAttribute("viewid");
                    String tvgenId = elm.getAttribute("tv_generator_id");
                    String type = elm.getAttribute("type");
                    if (!type.equalsIgnoreCase("Entity")) continue;
                    DesignObject object = design.getEntitySet().getObjectByID(oid);
                    TVEntity tvt = (TVEntity)object.getTopView().createViewSynonim(dpvl);
                    tvt.setViewID(vid);
                    if (tvgenId != null && !"".equalsIgnoreCase(tvgenId) && !"null".equalsIgnoreCase(tvgenId)) {
                        tvt.setGeneratorID(tvgenId);
                    }
                    this.readGraphicalInfo(elm, tvt);
                }
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject object = tv.getModel();
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(tv, map);
            }
        }
    }

    private void readRelationToSynonyms(Element root, LogicalDesign design) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadRelationsToSynonyms"));
        DesignPartView dpv = design.getMainView();
        Element fklist = RXMLLogicalDesign.getFirstChildByTagName(root, "view_relations");
        if (fklist != null) {
            NodeList objectElements = fklist.getElementsByTagName("objectid");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                String width;
                Element graphical;
                String y;
                String x;
                Element elm = (Element)objectElements.item(i);
                String oid = elm.getAttribute("oid");
                String type = elm.getAttribute("type");
                Relation rel = type.equalsIgnoreCase("Relation") ? (Relation)design.getRelationSet().getObjectByID(oid) : (Relation)design.getInheritanceRelationSet().getObjectByID(oid);
                if (rel == null || rel.getTargetEntity() == null) continue;
                String svid = elm.getAttribute("viewid_source");
                String tvid = elm.getAttribute("viewid_target");
                if (!svid.equals("null")) {
                    rel.setSourceTV((TVEntity)rel.getSourceEntity().getTopViewByID(dpv, svid));
                }
                if (!tvid.equals("null")) {
                    rel.setTargetTV((TVEntity)rel.getTargetEntity().getTopViewByID(dpv, tvid));
                }
                Element points = RXMLLogicalDesign.getFirstChildByTagName(elm, "points");
                NodeList plist = points.getElementsByTagName("point");
                int plLength = plist.getLength();
                TVRelation tv = (TVRelation)rel.getTopView();
                for (int kk = 0; kk < plLength; ++kk) {
                    Element point = (Element)plist.item(kk);
                    x = point.getAttribute("x_coordinate");
                    y = point.getAttribute("y_coordinate");
                    tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                }
                Element labels = RXMLLogicalDesign.getFirstChildByTagName(elm, "labels");
                if (labels != null) {
                    Label label;
                    String h;
                    String w;
                    Element lbl = RXMLLogicalDesign.getFirstChildByTagName(labels, "source");
                    if (lbl != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        w = lbl.getAttribute("width");
                        h = lbl.getAttribute("height");
                        if (w == null || "".equalsIgnoreCase(w)) {
                            w = "-1";
                        }
                        if (h == null || "".equalsIgnoreCase(h)) {
                            h = "-1";
                        }
                        if (x != null && y != null) {
                            tv.setSourceLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                        }
                        if ((label = tv.getTempSourceLabel()) != null) {
                            this.readColorInfo(lbl, label);
                            this.readFontsInfo(lbl, label);
                        }
                    }
                    if ((lbl = RXMLLogicalDesign.getFirstChildByTagName(labels, "target")) != null) {
                        x = lbl.getAttribute("x_coordinate");
                        y = lbl.getAttribute("y_coordinate");
                        w = lbl.getAttribute("width");
                        h = lbl.getAttribute("height");
                        if (w == null || "".equalsIgnoreCase(w)) {
                            w = "-1";
                        }
                        if (h == null || "".equalsIgnoreCase(h)) {
                            h = "-1";
                        }
                        if (x != null && y != null) {
                            tv.setTargetLabelBounds(new Rectangle((int)Double.parseDouble(x), (int)Double.parseDouble(y), (int)Double.parseDouble(w), (int)Double.parseDouble(h)));
                        }
                        if ((label = tv.getTempTargetLabel()) != null) {
                            this.readColorInfo(lbl, label);
                            this.readFontsInfo(lbl, label);
                        }
                    }
                }
                if ((graphical = RXMLLogicalDesign.getFirstChildByTagName(elm, "graphical")) == null) continue;
                NodeList paramList = graphical.getElementsByTagName("parameter");
                HashMap<String, String> map = new HashMap<String, String>();
                int plength = paramList.getLength();
                for (int l = 0; l < plength; ++l) {
                    Element param = (Element)paramList.item(l);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                String useDefault = (String)map.get("use_default_color");
                boolean useDef = true;
                if (useDefault != null) {
                    useDef = Boolean.valueOf(useDefault);
                }
                tv.setUseDefaultColor(useDef);
                if (useDef) continue;
                String color = (String)map.get("color");
                if (color != null && !"null".equalsIgnoreCase(color)) {
                    Color backgroundColor = new Color(Integer.parseInt(color));
                    tv.setBackgroundColor(backgroundColor);
                }
                if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                int lineWidth = Integer.parseInt(width);
                tv.setLineWidth(lineWidth);
            }
        }
    }

    public void readGraphicalInfo(Element objInfo, DesignObject object) {
        if (object == null || object.getDesign() == null) {
            LOGGER.error("readGraphicalInfo: DesignObject = null or design = null");
            return;
        }
        ApplicationView view = object.getDesign().getAppView();
        if (view != null) {
            NodeList list = objInfo.getElementsByTagName("graphical");
            HashMap<String, String> map = null;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element elm = (Element)list.item(i);
                map = new HashMap<String, String>();
                NodeList paramList = elm.getElementsByTagName("parameter");
                int plength = paramList.getLength();
                for (int j = 0; j < plength; ++j) {
                    Element param = (Element)paramList.item(j);
                    map.put(param.getAttribute("name"), param.getAttribute("value"));
                }
                view.setGraphicalPropsFor(object, map);
            }
        }
    }

    protected void readAtomicReference(Element referenceElm, ModelIDObjectReference reference, Map refIdRemap) {
        if (VALUE_TRUE.equals(referenceElm.getAttribute("disabled"))) {
            reference.setNullified(true);
        } else {
            String referedId = referenceElm.getAttribute("references");
            reference.setObjectId(StringUtilities.decodeAttributeValue(referedId));
        }
    }

    protected void readCompositeReference(Element referenceElm, CompositeReference reference, ReferenceSet referenceSet, Map refIdRemap) {
        NodeList childList = referenceElm.getElementsByTagName("ref");
        int length = childList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childElm = (Element)childList.item(i);
            String oldId = childElm.getAttribute("oid");
            Reference child = referenceSet.getReferenceByIdString(oldId);
            if (child == null) continue;
            reference.add(child);
            String isMain = childElm.getAttribute("main");
            if (!VALUE_TRUE.equals(isMain)) continue;
            reference.setMainReference(child);
        }
    }

    @Override
    public String getRelativePath() {
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(designName).append('/').append("logical");
            return buffer.toString();
        }
        return "logical";
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    private void readTypeSubstitutions(Element root, LogicalDesign design) {
        ApplicationView.log(Messages.getString("RXMLLogicalDesign.ReadTypeSubstitutions"));
        if (design.getAppView() != null) {
            DesignPartView dpv = design.getMainView();
            Element fklist = RXMLLogicalDesign.getFirstChildByTagName(root, "type_substitutions");
            if (fklist != null) {
                NodeList objectElements = fklist.getElementsByTagName("objectid");
                int length = objectElements.getLength();
                for (int i = 0; i < length; ++i) {
                    String width;
                    Element elm = (Element)objectElements.item(i);
                    String oid = elm.getAttribute("oid");
                    String childOid = elm.getAttribute("child_id");
                    ContainerObject parent = null;
                    ContainerObject child = null;
                    if (childOid == null) {
                        childOid = "null";
                    } else {
                        child = (ContainerObject)design.getDesign().getDesignObject(childOid);
                    }
                    String parentOid = elm.getAttribute("parent_id");
                    if (parentOid == null) {
                        parentOid = "null";
                    } else {
                        parent = (ContainerObject)design.getDesign().getDesignObject(parentOid);
                    }
                    if (parent == null || child == null) continue;
                    TypeSubstitution ts = (TypeSubstitution)design.getDesign().getDesignObject(oid);
                    if (ts == null) {
                        ts = design.createTypeSubstitution(oid);
                    }
                    String chid = elm.getAttribute("view_id_child");
                    String parid = elm.getAttribute("view_id_parent");
                    if (!chid.equals("null")) {
                        ts.setChildCV((ContainerView)child.getTopViewByID(dpv, chid));
                    }
                    if (!parid.equals("null")) {
                        ts.setParentCV((ContainerView)parent.getTopViewByID(dpv, chid));
                    }
                    Element points = RXMLLogicalDesign.getFirstChildByTagName(elm, "points");
                    NodeList plist = points.getElementsByTagName("point");
                    int plLength = plist.getLength();
                    TVTypeSubstitution tv = (TVTypeSubstitution)ts.getTopView();
                    for (int kk = 0; kk < plLength; ++kk) {
                        Element point = (Element)plist.item(kk);
                        String x = point.getAttribute("x_coordinate");
                        String y = point.getAttribute("y_coordinate");
                        tv.getEdgePoints().add(DiagramConstants.createPoint(Double.parseDouble(x), Double.parseDouble(y)));
                    }
                    Element graphical = RXMLLogicalDesign.getFirstChildByTagName(elm, "graphical");
                    if (graphical == null) continue;
                    NodeList paramList = graphical.getElementsByTagName("parameter");
                    HashMap<String, String> map = new HashMap<String, String>();
                    int plength = paramList.getLength();
                    for (int l = 0; l < plength; ++l) {
                        Element param = (Element)paramList.item(l);
                        map.put(param.getAttribute("name"), param.getAttribute("value"));
                    }
                    String useDefault = (String)map.get("use_default_color");
                    boolean useDef = true;
                    if (useDefault != null) {
                        useDef = Boolean.valueOf(useDefault);
                    }
                    tv.setUseDefaultColor(useDef);
                    if (useDef) continue;
                    String color = (String)map.get("color");
                    if (color != null && !"null".equalsIgnoreCase(color)) {
                        Color backgroundColor = new Color(Integer.parseInt(color));
                        tv.setBackgroundColor(backgroundColor);
                    }
                    if ((width = (String)map.get("width")) == null || "null".equalsIgnoreCase(width)) continue;
                    int lineWidth = Integer.parseInt(width);
                    tv.setLineWidth(lineWidth);
                }
            }
        }
    }

    private void updateKeysElements(LogicalDesign logicalDesign) {
        for (CandidateKey key : logicalDesign.getGlobalCandidateKeySet()) {
            key.updateContainedObjects();
        }
    }

    static {
        NFS = 2.4f;
        LOGGER = new Logger(RXMLLogicalDesign.class);
    }
}

