/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.TransformationFlow;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLTransformationFlow
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLTransformationFlow(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getTransformationPackage().getLastTaskAdded().createFlow(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Event event;
        Flow flow = (Flow)super.recreateObject(objInfo, design, tryReadWriteLocking);
        NodeList connections = objInfo.getElementsByTagName("connection");
        int length = connections.getLength();
        for (int i = 0; i < length; ++i) {
            Element endP = (Element)connections.item(i);
            String entId = endP.getAttribute("dfobject");
            AbstractProcessObject obj = (AbstractProcessObject)design.getDesignObject(entId);
            if (obj == null) {
                TransformationTask task = design.getProcessModel().getTransformationTask();
                if (task != null) {
                    obj = task.getInOutParamsObjectById(entId);
                }
                if ("source".equals(endP.getAttribute("endpoint"))) {
                    if (obj == null) {
                        obj = task.getInputParamsObject();
                    }
                } else if ("target".equals(endP.getAttribute("endpoint")) && obj == null) {
                    obj = task.getOutputParamsObject();
                }
            }
            if ("source".equals(endP.getAttribute("endpoint"))) {
                flow.setSourceProcessObject(obj);
                continue;
            }
            if (!"target".equals(endP.getAttribute("endpoint"))) continue;
            flow.setTargetProcessObject(obj);
        }
        Map map = this.getProperties(objInfo, "attributes");
        String eventID = (String)map.get("event");
        if (!"null".equalsIgnoreCase(eventID) && (event = (Event)flow.getDesign().getProcessModel().getEventSet().getObjectByID(eventID)) != null) {
            flow.setEvent(event);
        }
        flow.setLogging(Boolean.valueOf((String)map.get("loggingflow")));
        flow.setSystemObjective((String)map.get("systemobjective"));
        flow.setOpCreate(Boolean.valueOf((String)map.get("opCreate")));
        flow.setOpRead(Boolean.valueOf((String)map.get("opRead")));
        flow.setOpUpdate(Boolean.valueOf((String)map.get("opUpdate")));
        flow.setOpDelete(Boolean.valueOf((String)map.get("opDelete")));
        Element propertiesElm = RXMLTransformationFlow.getFirstChildByTagName(objInfo, "infostructures");
        if (propertiesElm != null) {
            Map objMap = this.getProperties(objInfo, "infostructures");
            Object[] objects = objMap.keySet().toArray();
            for (int i = 0; i < objects.length; ++i) {
                String aID = (String)objMap.get(objects[i]);
                InfoStructure structure = (InfoStructure)flow.getDesign().getProcessModel().getInfoStructureSet().getObjectByID(aID);
                if (structure == null) continue;
                flow.addInfoStructure(structure);
            }
        } else {
            String infostr = (String)map.get("infostructures");
            if (infostr != null) {
                String[] str = infostr.split(",");
                for (int i = 0; i < str.length; ++i) {
                    String aID = str[i];
                    InfoStructure structure = (InfoStructure)flow.getDesign().getProcessModel().getInfoStructureSet().getObjectByID(aID);
                    if (structure == null) continue;
                    flow.addInfoStructure(structure);
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(flow.getObjectID())).append(".dmd");
        flow.setFilePath(buffer.toString());
        return flow;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage() != null) {
                TransformationPackage pack = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getTransformationPackage();
                String packID = pack.getObjectID();
                Object taskID = pack.getLastTaskAdded() != null ? pack.getLastTaskAdded().getObjectID() + "/" : "";
                buffer.append(designName).append('/');
                if (this.isOldDesign()) {
                    buffer.append("processmodel/tansformationpackages");
                } else {
                    buffer.append(TRPACKAGE_PATH);
                    if (pack.getLastTaskAdded() != null) {
                        taskID = pack.getLastTaskAdded().getPathIDString() + "/";
                    }
                }
                buffer.append('/').append(StringUtilities.decodeAttributeValue(packID)).append('/').append(StringUtilities.decodeAttributeValue((String)taskID));
            }
        }
        buffer.append(this.getConfiguration().get("flowPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == TransformationFlow.class;
    }
}

