/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class MappingCollector {
    private String objectID;
    private List map = new ArrayList();
    private Design design;

    public MappingCollector(Design design, String objectID) {
        this.objectID = objectID;
        this.design = design;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public List getMappingsForDesignPart(String designPartID) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : this.map) {
            String oid = mapping.getOwnerDesignPartID();
            String tid = mapping.getTargetDesignPartID();
            if ((oid == null || !oid.equalsIgnoreCase(designPartID)) && (tid == null || !tid.equalsIgnoreCase(designPartID)) || mapping.isDeleted()) continue;
            list.add(mapping);
        }
        return list;
    }

    public List getDeletedMappingsForDesignPart(String designPartID) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : this.map) {
            String oid = mapping.getOwnerDesignPartID();
            String tid = mapping.getTargetDesignPartID();
            if ((oid == null || !oid.equalsIgnoreCase(designPartID)) && (tid == null || !tid.equalsIgnoreCase(designPartID)) || !mapping.isDeleted()) continue;
            list.add(mapping);
        }
        return list;
    }

    public List getAllDeletedMappings() {
        ArrayList<XtdMapping> list = null;
        for (XtdMapping mapping : this.map) {
            if (!mapping.isDeleted()) continue;
            if (list == null) {
                list = new ArrayList<XtdMapping>();
            }
            list.add(mapping);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public void addMapping(XtdMapping mapping) {
        if (!this.map.contains(mapping)) {
            this.map.add(mapping);
        }
    }

    public void removeMapping(XtdMapping mapping) {
        this.map.remove(mapping);
    }

    public void removeMappingFor(String objectID) {
        for (int i = this.map.size() - 1; i >= 0; --i) {
            XtdMapping mapping = (XtdMapping)this.map.get(i);
            if (!mapping.getOwnerID().equalsIgnoreCase(objectID) && !mapping.getTargetID().equalsIgnoreCase(objectID)) continue;
            this.map.remove(i);
        }
    }

    public void setMappingToDeleted(String deletedID) {
        for (int i = this.map.size() - 1; i >= 0; --i) {
            XtdMapping mapping = (XtdMapping)this.map.get(i);
            if (!mapping.getOwnerID().equalsIgnoreCase(deletedID) && !mapping.getTargetID().equalsIgnoreCase(deletedID)) continue;
            mapping.setDeletedID(deletedID);
        }
    }

    public Design getDesign() {
        return this.design;
    }

    public List getAllMappings() {
        return this.map;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    void clearAllMappings() {
        this.map.clear();
    }

    void nullifyObjects() {
        for (XtdMapping mapping : this.map) {
            mapping.nulifyObjects();
        }
    }
}

