/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.Component;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class ColumnGroupsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6357265181047614176L;
    protected static final String[] COLUMN_NAMES = new String[]{" ", Messages.getString("ColumnGroupsTable.Name")};
    protected List<Table.ColumnGroup> columnGroupList;
    protected Component parent;

    public ColumnGroupsTableModel(List<Table.ColumnGroup> columnGroupList, Component parent) {
        this.columnGroupList = columnGroupList;
        this.parent = parent;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.columnGroupList.size();
    }

    public String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumnNames()[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Table.ColumnGroup columnGroup = this.columnGroupList.get(row);
        if (col == 0) {
            return new Integer(row + 1);
        }
        if (col == 1) {
            return columnGroup.getName();
        }
        return new Integer(row + 1);
    }

    @Override
    public void setValueAt(Object obj, int rowIndex, int columnIndex) {
        Table.ColumnGroup columnGroup = this.columnGroupList.get(rowIndex);
        if (columnIndex == 1) {
            columnGroup.setName(obj.toString());
        }
    }

    public void clearList() {
        this.columnGroupList.clear();
    }

    public List<Table.ColumnGroup> getColumnGroupList() {
        return this.columnGroupList;
    }

    public void setColumnGroupList(List<Table.ColumnGroup> columnGroupList) {
        this.columnGroupList = columnGroupList;
    }
}

