/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.DefaultMaxNameLength;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.NamingOptionsHolderPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;

public class RelationalModelDialogEx
extends ModelPropertiesDialogEx
implements DefaultMaxNameLength {
    private JPanel pnTable;
    private JPanel pnColumn;
    private JPanel pnView;
    private JPanel pnIndex;
    private JPanel pnConstraint;
    private JPanel pnGeneral;
    private JPanel pnGeneralGrid;
    private JPanel pane;
    private JComboBox cbRDBMSType;
    private JComboBox cbRDBMSSite;
    private NamingOptionsHolderPanel tblOptionsPanel;
    private NamingOptionsHolderPanel clmOptionsPanel;
    private NamingOptionsHolderPanel viewOptionsPanel;
    private NamingOptionsHolderPanel indexOptionsPanel;
    private NamingOptionsHolderPanel constraintOptionsPanel;

    public RelationalModelDialogEx(ApplicationView view, ModelIDObject object) {
        super(view, object);
    }

    @Override
    protected String getHelpIndex() {
        return "RELATIONAL_MODEL_PROPERTIES_DIALOG";
    }

    @Override
    protected int getMinimumWidth() {
        return 960;
    }

    @Override
    public void initProperties(ModelIDObject object) {
        this.model = object;
        this.tfName.setText(this.model.getName());
        this.taComments.setText(this.model.getComment());
        this.taNotes.setText(this.model.getNotes());
        this.tfObjectID.setText(this.model.getObjectID());
        this.tfCreationTime.setText(this.model.getCreationTime());
        this.tfCreator.setText(this.model.getCreator().getName());
        this.tfLastChangedBy.setText(this.model.getChanger().getName());
        this.tfLastChangedTime.setText(this.model.getChangeTime());
        this.cbRDBMSType.removeAllItems();
        Iterator it = Design.getDefaultRDBMSTypeSet().iterator();
        while (it.hasNext()) {
            RDBMSType rdbmsType = (RDBMSType)it.next();
            this.cbRDBMSType.addItem(rdbmsType);
        }
        this.cbRDBMSType.setSelectedItem(this.model.getSelectedRDBMSType());
        this.cbRDBMSSite.setSelectedItem(((RelationalDesign)this.model).getSelectedRDBMSSite());
        this.tblOptionsPanel.init();
        this.clmOptionsPanel.init();
        this.viewOptionsPanel.init();
        this.indexOptionsPanel.init();
        this.constraintOptionsPanel.init();
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
            this.initResponsibleParties();
            this.initDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            this.chbVisible.setSelected(((DesignPartViewPlaceHolder)this.model).getVisible());
        } else {
            this.chbVisible.setEnabled(false);
        }
        this.initSummaryExtras();
    }

    protected void initSummaryExtras() {
        if (this.model instanceof RelationalDesign) {
            RelationalDesign relMod = (RelationalDesign)this.model;
            for (int i = this.pnSummaryGrid.getComponentCount(); i > this.summaryCount; --i) {
                this.pnSummaryGrid.remove(i - 1);
            }
            if (!relMod.getImportConnectionStamps().isEmpty()) {
                if (relMod.getImportConnectionStamps().size() == 1) {
                    this.pnSummaryGrid.add(this.pnDataDictConnection);
                    DBConnectionStamp stamp = relMod.getImportConnectionStamp(0);
                    String conn = stamp.getConnName() + ", URL = " + stamp.getConnUrl() + ", DBTYPE = " + stamp.getConnTypeDisplay();
                    if (stamp.getSyncSelected() == 1) {
                        conn = conn + ", SYNC";
                        if (relMod.getRedirectConnectionStamp() != null) {
                            conn = conn + " REDIRECT = " + relMod.getRedirectConnectionStamp().getConnName();
                        }
                    }
                    this.tfDataDictConnection.setText(conn);
                } else {
                    this.pnSummaryGrid.add(this.pnDataDictConnections);
                    this.cbDataDictConnections.removeAllItems();
                    for (DBConnectionStamp dbStamp : relMod.getImportConnectionStamps()) {
                        String dbConn = dbStamp.getConnName() + ", URL = " + dbStamp.getConnUrl() + ", DBTYPE = " + dbStamp.getConnTypeDisplay();
                        if (dbStamp.getSyncSelected() == 1) {
                            dbConn = dbConn + ", SYNC";
                            if (relMod.getRedirectConnectionStamp() != null) {
                                dbConn = dbConn + " REDIRECT = " + relMod.getRedirectConnectionStamp().getConnName();
                            }
                        }
                        this.cbDataDictConnections.addItem(dbConn);
                    }
                }
            }
            if (!relMod.getImportDDLFileStamps().isEmpty()) {
                if (relMod.getImportDDLFileStamps().size() == 1) {
                    this.pnSummaryGrid.add(this.pnDDLFileName);
                    DDLFileStamp stamp = relMod.getImportDDLFileStamp(0);
                    String file = stamp.getFileName() + " , PATH = " + stamp.getPathName() + " , DBTYPE = " + stamp.getDBTypeDisplay();
                    this.tfDDLFileName.setText(file);
                } else {
                    this.pnSummaryGrid.add(this.pnDDLFileNames);
                    this.cbDDLFileNames.removeAllItems();
                    for (DDLFileStamp ddlStamp : relMod.getImportDDLFileStamps()) {
                        String ddlFile = ddlStamp.getFileName() + " , PATH = " + ddlStamp.getPathName() + " , DBTYPE = " + ddlStamp.getDBTypeDisplay();
                        this.cbDDLFileNames.addItem(ddlFile);
                    }
                }
            }
            this.pnSummaryGrid.validate();
        }
    }

    @Override
    protected void setProperties() throws EmptyFieldException {
        if (!this.readonlyName) {
            if (!"".equalsIgnoreCase(this.tfName.getText().trim())) {
                this.checkNameExists(this.tfName.getText());
                this.model.setName(this.tfName.getText());
            } else {
                this.tfName.requestFocus();
                throw new EmptyFieldException(Messages.getString("RelationalModelDialogEx.NameCanNotBeEmpty"));
            }
        }
        this.model.setComment(this.taComments.getText());
        this.model.setNotes(this.taNotes.getText());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
            ((DesignPart)this.model).setMainViewVisible(this.chbVisible.isSelected());
            this.setResponsibleParties();
            this.setDocuments();
        } else if (this.model instanceof DesignPartViewPlaceHolder && ((DesignPartViewPlaceHolder)this.model).getDesignPartView() != null && ((DesignPartViewPlaceHolder)this.model).getDesignPartView().isMasterDPV()) {
            ((DesignPartViewPlaceHolder)this.model).setVisible(this.chbVisible.isSelected());
        }
        ((RelationalDesign)this.model).getNamingOptionsHolderList().clear();
        this.tblOptionsPanel.setHolderValues();
        this.clmOptionsPanel.setHolderValues();
        this.viewOptionsPanel.setHolderValues();
        this.indexOptionsPanel.setHolderValues();
        this.constraintOptionsPanel.setHolderValues();
        List namigOptionsHolderList = ((RelationalDesign)this.model).getNamingOptionsHolderList();
        namigOptionsHolderList.add(this.tblOptionsPanel.getNamingOptionsHolder().copy());
        namigOptionsHolderList.add(this.clmOptionsPanel.getNamingOptionsHolder().copy());
        namigOptionsHolderList.add(this.viewOptionsPanel.getNamingOptionsHolder().copy());
        namigOptionsHolderList.add(this.indexOptionsPanel.getNamingOptionsHolder().copy());
        namigOptionsHolderList.add(this.constraintOptionsPanel.getNamingOptionsHolder().copy());
        ((RelationalDesign)this.model).setSelectedRDBMSSite((RDBMSSite)this.cbRDBMSSite.getSelectedItem());
        if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null && ((DesignPart)this.model).getMainView().isVisible()) {
            ((DesignPart)this.model).getMainView().getWorkSpace().repaint();
        }
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("RelationalModelDialogEx.General"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.getDefaultSize());
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.getDefaultSize());
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(lbName, this.tfName));
            JLabel lbVisible = new JLabel(LB_VISIBLE);
            lbVisible.setPreferredSize(this.getDefaultSize());
            this.chbVisible = new JCheckBox();
            this.chbVisible.setPreferredSize(this.getDefaultSize());
            this.chbVisible.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(lbVisible, this.chbVisible));
            JLabel lbDefaultRDBMSType = new JLabel(Messages.getString("RelationalModelDialogEx.RDBMSType"));
            lbDefaultRDBMSType.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSType = new JComboBox();
            this.cbRDBMSType.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSType.setMaximumRowCount(20);
            this.cbRDBMSType.setEnabled(this.isEditable());
            this.cbRDBMSType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationalModelDialogEx.this.updateSites();
                    RelationalModelDialogEx.this.setDefaultValues();
                }
            });
            this.pnGeneralGrid.add(this.createRow(lbDefaultRDBMSType, this.cbRDBMSType));
            JLabel lbDefaultRDBMSSite = new JLabel(Messages.getString("RelationalModelDialogEx.RDBMSSite"));
            lbDefaultRDBMSSite.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSSite = new JComboBox();
            this.cbRDBMSSite.setPreferredSize(this.getDefaultSize());
            this.cbRDBMSSite.setMaximumRowCount(20);
            this.cbRDBMSSite.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(lbDefaultRDBMSSite, this.cbRDBMSSite));
            jpanel.add((Component)this.pnGeneralGrid, "North");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    public JPanel getPane() {
        if (this.pane == null) {
            this.pane = new JPanel(this.cardLayout);
            this.pane.setMinimumSize(new Dimension(400, 0));
        }
        return this.pane;
    }

    private JPanel getTblOptionsPanel() {
        if (this.pnTable == null) {
            this.pnTable = this.createPage(Messages.getString("RelationalModelDialogEx.Table"));
            this.tblOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Table.class), false);
            this.pnTable.add((Component)this.tblOptionsPanel, "West");
        }
        return this.pnTable;
    }

    private JPanel getClmOptionsPanel() {
        if (this.pnColumn == null) {
            this.pnColumn = this.createPage(Messages.getString("RelationalModelDialogEx.Column"));
            this.clmOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Column.class), false);
            this.pnColumn.add((Component)this.clmOptionsPanel, "West");
        }
        return this.pnColumn;
    }

    private JPanel getViewOptionsPanel() {
        if (this.pnView == null) {
            this.pnView = this.createPage(Messages.getString("RelationalModelDialogEx.View"));
            this.viewOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(TableView.class), false);
            this.pnView.add((Component)this.viewOptionsPanel, "West");
        }
        return this.pnView;
    }

    private JPanel getIndexOptionsPanel() {
        if (this.pnIndex == null) {
            this.pnIndex = this.createPage(Messages.getString("RelationalModelDialogEx.Index"));
            this.indexOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(Index.class), false);
            this.pnIndex.add((Component)this.indexOptionsPanel, "West");
        }
        return this.pnIndex;
    }

    private JPanel getConstraintOptionsPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("RelationalModelDialogEx.Constraint"));
            this.constraintOptionsPanel = new NamingOptionsHolderPanel(this.getNamingOptionsHolderFor(TableLevelConstraint.class), false);
            this.pnConstraint.add((Component)this.constraintOptionsPanel, "West");
        }
        return this.pnConstraint;
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 160;
    }

    @Override
    public JTree getTree() {
        if (this.tree == null) {
            this.root = new DefaultMutableTreeNode("");
            this.tree = new JTree(this.root);
            this.tree.setCellRenderer(new ModelPropertiesDialogEx.TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.addToTree(this.root, this.getGeneralPanel());
            DefaultMutableTreeNode nameNode = new DefaultMutableTreeNode(Messages.getString("RelationalModelDialogEx.NamingOptions"));
            this.addToTree(nameNode, this.getTblOptionsPanel());
            this.addToTree(nameNode, this.getClmOptionsPanel());
            this.addToTree(nameNode, this.getViewOptionsPanel());
            this.addToTree(nameNode, this.getIndexOptionsPanel());
            this.addToTree(nameNode, this.getConstraintOptionsPanel());
            this.root.add(nameNode);
            this.addToTree(this.root, this.getCommentsPanel());
            this.addToTree(this.root, this.getNotesPanel());
            if (this.model instanceof DesignPart && ((DesignPart)this.model).getMainView() != null) {
                this.chbVisible.setSelected(((DesignPart)this.model).isMainViewVisible());
                this.addToTree(this.root, this.getResPartiesPanel());
                this.addToTree(this.root, this.getDocumentsPanel());
            }
            this.addToTree(this.root, this.getSummaryPanel());
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    private NamingOptionsHolder getNamingOptionsHolderFor(Class className) {
        for (NamingOptionsHolder holder : ((RelationalDesign)this.model).getNamingOptionsHolderList()) {
            if (!holder.getClassName().equals(className)) continue;
            return holder.copy();
        }
        return new NamingOptionsHolder(className);
    }

    public String getSelectedRDBMSType() {
        return this.cbRDBMSType.getSelectedItem().toString();
    }

    public void fillComboItems(Object[] items, JComboBox comboBox) {
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    private void updateSites() {
        if (this.cbRDBMSType.getSelectedItem() != null) {
            RDBMSSite[] allSites = (RDBMSSite[])this.model.getDesign().getRDBMSSiteSet().toArray();
            this.cbRDBMSSite.removeAllItems();
            for (int i = 0; i < allSites.length; ++i) {
                RDBMSSite site = allSites[i];
                if (site.getType() == null || !site.getType().equals(this.cbRDBMSType.getSelectedItem())) continue;
                this.cbRDBMSSite.addItem(site);
            }
        }
    }

    private void setDefaultValues() {
        RDBMSType type = (RDBMSType)this.cbRDBMSType.getSelectedItem();
        if (type != null) {
            if (type.equals(StorageDesignDB2v70.RDBMS_TYPE)) {
                this.setMaxNameLength(18, 18, 18, 18, 18);
            } else if (type.equals(StorageDesignDB2v80.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 30, 128, 30, 30);
            } else if (type.equals(StorageDesignOraclev9i.RDBMS_TYPE)) {
                this.setMaxNameLength(30, 30, 30, 30, 30);
            } else if (type.equals(StorageDesignOraclev10g.RDBMS_TYPE)) {
                this.setMaxNameLength(30, 30, 30, 30, 30);
            } else if (type.equals(StorageDesignOraclev11g.RDBMS_TYPE) || type.equals(StorageDesignOraclev12c.RDBMS_TYPE)) {
                this.setMaxNameLength(30, 30, 30, 30, 30);
            } else if (type.equals(StorageDesignOraclev12cR2.RDBMS_TYPE) || type.equals(StorageDesignOraclev20c.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            } else if (type.equals(StorageDesignSqlServerv2k.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            } else if (type.equals(StorageDesignSqlServerv2k5.RDBMS_TYPE) || type.equals(StorageDesignSqlServerv2k8.RDBMS_TYPE) || type.equals(StorageDesignSqlServerv2k12.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            } else if (type.equals(StorageDesignUDBv71.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 30, 128, 128, 128);
            } else if (type.equals(StorageDesignUDBv81.RDBMS_TYPE) || type.equals(StorageDesignUDBv9.RDBMS_TYPE)) {
                this.setMaxNameLength(128, 128, 128, 128, 128);
            }
        }
    }

    private void setMaxNameLength(int tableMaxNameLength, int columnMaxNameLength, int viewMaxNameLength, int indexMaxNameLength, int constraintMaxNameLength) {
        this.tblOptionsPanel.setNameLength(tableMaxNameLength);
        this.clmOptionsPanel.setNameLength(columnMaxNameLength);
        this.viewOptionsPanel.setNameLength(viewMaxNameLength);
        this.indexOptionsPanel.setNameLength(indexMaxNameLength);
        this.constraintOptionsPanel.setNameLength(constraintMaxNameLength);
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)RelationalModelDialogEx.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                RelationalModelDialogEx.this.cardLayout.show(RelationalModelDialogEx.this.getMainPanel(), ((Component)obj).getName());
            } else if (node.getFirstLeaf() != null && (obj = node.getFirstLeaf().getUserObject()) instanceof Component) {
                RelationalModelDialogEx.this.cardLayout.show(RelationalModelDialogEx.this.getMainPanel(), ((Component)obj).getName());
            }
        }
    }
}

