/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PermissionsPropertiesDialogSqlServer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ViewPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private TableViewProxySqlServer view;
    private String comment = "";
    private String commentInRDBMS = "";
    private ExtPropertiesModel model;
    private JComboBox cbDatabase;
    private JComboBox cbOwner;
    private JComboBox cbCheckOption;
    private JComboBox cbEncryption;
    private JComboBox cbSchemaBinding;
    private JComboBox cbViewMetadata;
    private JTextArea taStatement;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private JButton bnPermissions;
    private PermissionsPropertiesDialogSqlServer dialog;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;

    public ViewPropertyDialogSqlServer(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.view = (TableViewProxySqlServer)object;
        this.setHeight(460);
        this.initCommentsView(190);
        this.initCommentsInRDBMS();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 210);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 190));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 230);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.taStatement.setText(this.view.getDefinition());
        this.cbDatabase.setSelectedItem(this.view.getDataBase());
        this.cbOwner.setSelectedItem(this.view.getUser());
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES);
        } else {
            this.cbCheckOption.setSelectedItem(NO);
        }
        this.cbEncryption.setSelectedItem(ViewPropertyDialogSqlServer.translateYesNoForDisplay(this.view.getEncryption()));
        this.cbSchemaBinding.setSelectedItem(ViewPropertyDialogSqlServer.translateYesNoForDisplay(this.view.getSchemaBinding()));
        this.cbViewMetadata.setSelectedItem(ViewPropertyDialogSqlServer.translateYesNoForDisplay(this.view.getViewMetaData()));
        if (this.view.getExtPropsSet() != null) {
            Object[] props = this.view.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        this.comment = this.view.getObject().getComment();
        this.commentInRDBMS = this.view.getObject().getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            this.view.setName(this.tfName.getText());
            this.view.setDataBase((DataBaseSqlServer)this.cbDatabase.getSelectedItem());
            this.view.setUser((UserSqlServer)this.cbOwner.getSelectedItem());
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setEncryption(ViewPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbEncryption.getSelectedItem()));
            this.view.setSchemaBinding(ViewPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbSchemaBinding.getSelectedItem()));
            this.view.setViewMetaData(ViewPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbViewMetadata.getSelectedItem()));
            this.view.setDefinition(this.taStatement.getText());
            Object[] propSet = this.model.getRows();
            this.view.clear();
            String name = null;
            String value = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken().trim();
                this.view.setProps(name);
                this.view.setProps(value);
            }
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.view.setComment(commentText);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.view.setCommentInRDBMS(commentInRDBMSText);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataBase();
        this.initOwner();
        this.initCheckOption();
        this.initEncryption();
        this.initSchemaBinding();
        this.initViewMetadata();
        this.initStatement();
        this.initPermissionsButton();
    }

    @Override
    protected void addTabs() {
        this.initExtProperties();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("ViewPropertyDialogSqlServer.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("ViewPropertyDialogSqlServer.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 400);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 400);
        ViewPropertyDialogSqlServer.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ViewPropertyDialogSqlServer.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 392));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(416, 395));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    private void initDataBase() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.Database"));
        this.general.add(label);
        this.cbDatabase = new JComboBox<Object>(this.getStorageDesign().getDataBaseSet().toArray());
        this.cbDatabase.addActionListener(new DatabaseListener());
        this.setBG(this.cbDatabase);
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDatabase, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initCheckOption() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.CheckOption"));
        this.general.add(label);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbCheckOption, 110);
    }

    private void initEncryption() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.Encryption"));
        this.general.add(label);
        this.cbEncryption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEncryption);
        this.cbEncryption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEncryption);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbEncryption, 140);
    }

    private void initSchemaBinding() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.SchemaBinding"));
        this.general.add(label);
        this.cbSchemaBinding = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSchemaBinding);
        this.cbSchemaBinding.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaBinding);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSchemaBinding, 170);
    }

    private void initViewMetadata() {
        JLabel label = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.ViewMetadata"));
        this.general.add(label);
        this.cbViewMetadata = new JComboBox<String>(YES_NO);
        this.setBG(this.cbViewMetadata);
        this.cbViewMetadata.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbViewMetadata);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbViewMetadata, 200);
    }

    private void initStatement() {
        JLabel bodyLabel = new JLabel(Messages.getString("ViewPropertyDialogSqlServer.Definition"));
        this.general.add(bodyLabel);
        this.setLabelConstraints(bodyLabel, 230);
        this.taStatement = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taStatement);
        sp.setPreferredSize(new Dimension(395, 130));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.taStatement.setLineWrap(true);
        this.general.add(sp);
        this.setObjectConstraints(sp, 10, 250);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("ViewPropertyDialogSqlServer.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 400);
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            ViewPropertyDialogSqlServer.this.model.addRow(new Object[]{propertyName, propertyValue});
            ViewPropertyDialogSqlServer.this.extProperties.updateUI();
            ViewPropertyDialogSqlServer.this.extProperties.changeSelection(ViewPropertyDialogSqlServer.this.model.getRowCount() - 1, 0, false, false);
            ViewPropertyDialogSqlServer.this.extProperties.requestFocus();
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewPropertyDialogSqlServer.this.model.getRowCount() >= 1) {
                for (int i = ViewPropertyDialogSqlServer.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!ViewPropertyDialogSqlServer.this.extProperties.isRowSelected(i)) continue;
                    ViewPropertyDialogSqlServer.this.model.removeRow(i);
                }
                ViewPropertyDialogSqlServer.this.extProperties.updateUI();
            }
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("ViewPropertyDialogSqlServer.PropertyName"), Messages.getString("ViewPropertyDialogSqlServer.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return ViewPropertyDialogSqlServer.this.isEditable();
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = ViewPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = ViewPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = ViewPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = ViewPropertyDialogSqlServer.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    private class DatabaseListener
    implements ActionListener {
        private DatabaseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataBaseSqlServer database = (DataBaseSqlServer)ViewPropertyDialogSqlServer.this.cbDatabase.getSelectedItem();
            if (database != null) {
                ViewPropertyDialogSqlServer.this.cbOwner.removeAllItems();
                for (UserSqlServer user : database.getUsers()) {
                    if (user.getName().equalsIgnoreCase("GUEST")) continue;
                    ViewPropertyDialogSqlServer.this.cbOwner.addItem(user);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewPropertyDialogSqlServer.this.dialog == null) {
                ViewPropertyDialogSqlServer.this.dialog = new PermissionsPropertiesDialogSqlServer(ViewPropertyDialogSqlServer.this.getAppView(), ViewPropertyDialogSqlServer.this.getStorageDesign(), ViewPropertyDialogSqlServer.this.view);
            }
            ViewPropertyDialogSqlServer.this.dialog.show();
        }
    }
}

