/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.preferences.SearchPP;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.search.Messages;
import oracle.dbtools.crest.swingui.search.SearchProfile;
import oracle.dbtools.crest.swingui.search.SearchProfilesPersistence;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;

public class SearchProfilePropertiesDialog
extends CustomDialog {
    private JPanel mainPanel;
    private List propertiesList;
    private DefaultListModel relationalModelObjectsModel;
    private DefaultListModel logicalModelObjectsModel;
    private JTabbedPane objectsPane;
    private JScrollPane relationalModelObjectsScrollPane;
    private JScrollPane logicalModelObjectsScrollPane;
    private JTextField txtName;
    private JTextArea description;
    private JTextField txtFilePath;
    private JList relationalModelObjectsList;
    private JList logicalModelObjectsList;
    private JTable propertiesTable;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private SearchProfilesPersistence persistence;
    private MetaDataManager metaDataManager;
    private ApplicationView appView;
    private SearchProfile originalSearchProfile;
    private SearchPP parent;
    private JTextField propertiesFilter;
    private boolean isSaved = true;
    private JDialog dialog;
    private static File lastDir = null;

    public SearchProfilePropertiesDialog(ApplicationView appView, SearchProfile sp, SearchProfilesPersistence persistence, SearchPP parent) {
        super(appView);
        this.appView = appView;
        this.originalSearchProfile = sp;
        this.persistence = persistence;
        this.parent = parent;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(510, 550));
        this.metaDataManager = appView.getXMLTransformationManager().getMetaDataManager();
        this.initNorthPanel();
        this.initWestPanel();
        this.initEastPanel();
        this.initButtonsPanel();
        this.initObjects();
        this.add(this.mainPanel);
    }

    private void initNorthPanel() {
        JPanel nameAndDecriptionPanel = new JPanel(new SpringLayout());
        nameAndDecriptionPanel.setPreferredSize(new Dimension(510, 150));
        JLabel lblName = new JLabel(Messages.getString("SearchProfilePropertiesDialog.Name"));
        lblName.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), lblName, 5, 5);
        this.txtName = new JTextField();
        this.txtName.setPreferredSize(new Dimension(300, 20));
        CommonUtil.setObjectConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), this.txtName, 100, 5);
        JLabel lblExtension = new JLabel(".sposdm");
        lblExtension.setPreferredSize(new Dimension(50, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), lblExtension, 405, 5);
        JLabel lblFileName = new JLabel(Messages.getString("SearchProfilePropertiesDialog.Filepath"));
        lblFileName.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), lblFileName, 5, 35);
        this.txtFilePath = new JTextField();
        this.txtFilePath.setPreferredSize(new Dimension(300, 20));
        CommonUtil.setObjectConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), this.txtFilePath, 100, 35);
        JButton bnSelectFilePath = new JButton(Messages.getString("SearchProfilePropertiesDialog.Select"));
        bnSelectFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                URLFileChooser fileChooser = new URLFileChooser();
                fileChooser.clearChooseableURLFilters();
                fileChooser.setSelectionScope(1);
                fileChooser.setSelectionMode(0);
                fileChooser.setShowJarsAsDirs(false);
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)SearchProfilePropertiesDialog.this.txtFilePath.getText()));
                fileChooser.setPathContext("dataModeler_Systypes");
                if (lastDir != null) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastDir));
                } else {
                    String lastDir = XMLTransformationManager.getDefaultSystemTypesPath(SearchProfilePropertiesDialog.this.appView.getSettings());
                    if (lastDir != null && lastDir.length() > 0) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                    } else {
                        URL url = SearchProfilePropertiesDialog.this.appView.getUserHomeDirectory();
                        if (url != null) {
                            fileChooser.setSelectedURL(url);
                        }
                    }
                }
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("SearchProfilePropertiesDialog.SelectDir"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    SearchProfilePropertiesDialog.this.txtFilePath.setText(file.getAbsolutePath());
                }
            }
        });
        CommonUtil.setObjectConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), bnSelectFilePath, 405, 35);
        JLabel lblDescription = new JLabel(Messages.getString("SearchProfilePropertiesDialog.Secription"));
        lblDescription.setPreferredSize(new Dimension(80, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), lblDescription, 5, 65);
        this.description = new JTextArea();
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        JScrollPane descriptionScrollPane = new JScrollPane(this.description);
        descriptionScrollPane.setPreferredSize(new Dimension(300, 50));
        CommonUtil.setObjectConstraints((SpringLayout)nameAndDecriptionPanel.getLayout(), descriptionScrollPane, 100, 65);
        nameAndDecriptionPanel.add(lblName);
        nameAndDecriptionPanel.add(this.txtName);
        nameAndDecriptionPanel.add(lblFileName);
        nameAndDecriptionPanel.add(lblExtension);
        nameAndDecriptionPanel.add(this.txtFilePath);
        nameAndDecriptionPanel.add(bnSelectFilePath);
        nameAndDecriptionPanel.add(lblDescription);
        nameAndDecriptionPanel.add(descriptionScrollPane);
        this.mainPanel.add((Component)nameAndDecriptionPanel, "North");
    }

    private void initWestPanel() {
        JPanel objectsPanel = new JPanel(new BorderLayout());
        objectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchProfilePropertiesDialog.Objects")));
        this.objectsPane = new JTabbedPane();
        this.objectsPane.setPreferredSize(new Dimension(200, 400));
        this.relationalModelObjectsModel = new DefaultListModel();
        this.relationalModelObjectsList = new JList(this.relationalModelObjectsModel);
        this.relationalModelObjectsList.setSelectionMode(0);
        this.relationalModelObjectsList.setCellRenderer(new SearchSetRenderer());
        this.relationalModelObjectsList.getSelectionModel().addListSelectionListener(new ObjectSelectionListener());
        this.relationalModelObjectsScrollPane = new JScrollPane(this.relationalModelObjectsList);
        this.relationalModelObjectsScrollPane.setPreferredSize(new Dimension(180, 432));
        this.logicalModelObjectsModel = new DefaultListModel();
        this.logicalModelObjectsList = new JList(this.logicalModelObjectsModel);
        this.logicalModelObjectsList.setSelectionMode(0);
        this.logicalModelObjectsList.setCellRenderer(new SearchSetRenderer());
        this.logicalModelObjectsList.getSelectionModel().addListSelectionListener(new ObjectSelectionListener());
        this.logicalModelObjectsScrollPane = new JScrollPane(this.logicalModelObjectsList);
        this.logicalModelObjectsScrollPane.setPreferredSize(new Dimension(180, 432));
        this.objectsPane.addTab(Messages.getString("SearchProfilePropertiesDialog.7"), this.relationalModelObjectsScrollPane);
        this.objectsPane.addTab(Messages.getString("SearchProfilePropertiesDialog.RelationalModel"), this.logicalModelObjectsScrollPane);
        this.objectsPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SearchSet selectedSearchSet = null;
                if (SearchProfilePropertiesDialog.this.objectsPane.getSelectedComponent() == SearchProfilePropertiesDialog.this.relationalModelObjectsScrollPane) {
                    if (SearchProfilePropertiesDialog.this.relationalModelObjectsList.getSelectedIndex() != -1) {
                        selectedSearchSet = (SearchSet)SearchProfilePropertiesDialog.this.relationalModelObjectsModel.get(SearchProfilePropertiesDialog.this.relationalModelObjectsList.getSelectedIndex());
                    }
                } else if (SearchProfilePropertiesDialog.this.objectsPane.getSelectedComponent() == SearchProfilePropertiesDialog.this.logicalModelObjectsScrollPane && SearchProfilePropertiesDialog.this.logicalModelObjectsList.getSelectedIndex() != -1) {
                    selectedSearchSet = (SearchSet)SearchProfilePropertiesDialog.this.logicalModelObjectsModel.get(SearchProfilePropertiesDialog.this.logicalModelObjectsList.getSelectedIndex());
                }
                if (selectedSearchSet != null) {
                    SearchProfilePropertiesDialog.this.reloadSearchableProperties(selectedSearchSet);
                }
            }
        });
        objectsPanel.add(this.objectsPane);
        this.mainPanel.add((Component)objectsPanel, "West");
    }

    private void initEastPanel() {
        JPanel propertiesPanel = new JPanel();
        propertiesPanel.setPreferredSize(new Dimension(300, 400));
        propertiesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchProfilePropertiesDialog.Properties")));
        JPanel objectsFilterPanel = new JPanel(new SpringLayout());
        objectsFilterPanel.setPreferredSize(new Dimension(290, 25));
        JLabel selectedObjectsFilterLabel = new JLabel(Messages.getString("SearchProfilePropertiesDialog.Filter"));
        this.propertiesFilter = new JTextField();
        this.propertiesFilter.setEnabled(false);
        this.propertiesFilter.setPreferredSize(new Dimension(108, 20));
        this.propertiesFilter.getDocument().addDocumentListener(new FilterPropertiesListener());
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), selectedObjectsFilterLabel, 5, 0);
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), this.propertiesFilter, 50, 0);
        this.btnSelectAll = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL"));
        this.btnSelectAll.setEnabled(false);
        this.btnSelectAll.setMnemonic(83);
        this.btnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAll.setToolTipText(Messages.getString("SearchProfilePropertiesDialog.SelectAll"));
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), this.btnSelectAll, 230, 0);
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchProfilePropertiesDialog.this.checkAll(SearchProfilePropertiesDialog.this.propertiesTable, SearchProfilePropertiesDialog.this.propertiesList, true);
                SearchProfilePropertiesDialog.this.propertiesTable.updateUI();
            }
        });
        this.btnDeselectAll = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL"));
        this.btnDeselectAll.setEnabled(false);
        this.btnDeselectAll.setMnemonic(68);
        this.btnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnDeselectAll.setToolTipText(Messages.getString("SearchProfilePropertiesDialog.DeselectAll"));
        CommonUtil.setObjectConstraints((SpringLayout)objectsFilterPanel.getLayout(), this.btnDeselectAll, 260, 0);
        this.btnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchProfilePropertiesDialog.this.checkAll(SearchProfilePropertiesDialog.this.propertiesTable, SearchProfilePropertiesDialog.this.propertiesList, false);
                SearchProfilePropertiesDialog.this.propertiesTable.updateUI();
            }
        });
        objectsFilterPanel.add(selectedObjectsFilterLabel);
        objectsFilterPanel.add(this.propertiesFilter);
        objectsFilterPanel.add(this.btnSelectAll);
        objectsFilterPanel.add(this.btnDeselectAll);
        this.propertiesList = new ArrayList();
        PropertiesModel pm = new PropertiesModel();
        this.propertiesTable = new JTable(pm);
        this.propertiesTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col1 = this.propertiesTable.getColumnModel().getColumn(1);
        col1.setMinWidth(50);
        col1.setPreferredWidth(50);
        col1.setMaxWidth(50);
        JScrollPane propertiesSP = new JScrollPane(this.propertiesTable);
        propertiesSP.setPreferredSize(new Dimension(290, 320));
        propertiesPanel.add((Component)objectsFilterPanel, "North");
        propertiesPanel.add((Component)propertiesSP, "Center");
        this.mainPanel.add((Component)propertiesPanel, "East");
    }

    private void initObjects() {
        SearchSet ss;
        this.txtName.setText(this.originalSearchProfile.getFileName());
        this.txtFilePath.setText(this.originalSearchProfile.getFilePath());
        this.description.setText(this.originalSearchProfile.getDescription());
        Iterator relSetsIt = this.appView.getCurrentDesign().getRelationalDesign().getSearchableSets(true).iterator();
        Iterator logSetsIt = this.appView.getCurrentDesign().getLogicalDesign().getSearchableSets().iterator();
        while (relSetsIt.hasNext()) {
            ss = (SearchSet)relSetsIt.next();
            this.relationalModelObjectsModel.addElement(ss);
        }
        this.sort(this.relationalModelObjectsModel);
        while (logSetsIt.hasNext()) {
            ss = (SearchSet)logSetsIt.next();
            this.logicalModelObjectsModel.addElement(ss);
        }
        this.sort(this.logicalModelObjectsModel);
        this.txtName.getDocument().addDocumentListener(new TxtFieldsListener());
        this.txtFilePath.getDocument().addDocumentListener(new TxtFieldsListener());
        this.description.getDocument().addDocumentListener(new TxtFieldsListener());
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.appView.getFrame(), Messages.getString("SearchProfilePropertiesDialog.Searchprofile"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "SEARCH_PROFILE_PROPERTIES_DIALOG";
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private void initButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JButton bnClose = new JButton(Messages.getString("SearchProfilePropertiesDialog.Close"));
        bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnClose.addActionListener(new CloseAction());
        bnClose.setMnemonic(67);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton bnSave = new JButton(Messages.getString("SearchProfilePropertiesDialog.Save"));
        bnSave.addActionListener(new SaveAction());
        bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnSave.setMnemonic(83);
        buttonsPanel.add(bnSave);
        buttonsPanel.add(bnClose);
        buttonsPanel.add(bnHelp);
        this.mainPanel.add((Component)buttonsPanel, "South");
    }

    private void reloadSearchableProperties(SearchSet ss) {
        for (Map.Entry<SearchSet, List<SearchProfile.Property>> pairs : this.originalSearchProfile.getObjects().entrySet()) {
            if (pairs.getKey().getClazz() != ss.getClazz()) continue;
            ArrayList pList = (ArrayList)pairs.getValue();
            this.propertiesList.addAll(pList);
            break;
        }
        this.propertiesTable.updateUI();
        if (this.propertiesList.size() > 0) {
            this.btnSelectAll.setEnabled(true);
            this.btnDeselectAll.setEnabled(true);
            this.propertiesFilter.setEnabled(true);
        } else {
            this.btnSelectAll.setEnabled(false);
            this.btnDeselectAll.setEnabled(false);
            this.propertiesFilter.setEnabled(false);
        }
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        block5: {
            try {
                RowFilter rf = null;
                if (currentTable == null) break block5;
                if (!"".equals(filterText.getText())) {
                    try {
                        rf = RowFilter.regexFilter("(?i)" + filterText.getText(), 0);
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                    ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
                    break block5;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private void checkAll(JTable table, List<SearchProfile.Property> objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                SearchProfile.Property p = (SearchProfile.Property)this.propertiesList.get(table.convertRowIndexToModel(selected[i]));
                p.setUsed(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List<SearchProfile.Property> objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                SearchProfile.Property o = (SearchProfile.Property)list.get(index);
                this.setSelected(o, true);
            }
        } else {
            for (SearchProfile.Property o : list) {
                this.setSelected(o, true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                SearchProfile.Property o = (SearchProfile.Property)list.get(index);
                this.setSelected(o, false);
            }
        } else {
            for (SearchProfile.Property o : list) {
                this.setSelected(o, false);
            }
        }
    }

    private void setSelected(SearchProfile.Property obj, boolean selected) {
        if (obj != null) {
            obj.setUsed(selected);
        }
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = Messages.getString("SearchProfilePropertiesDialog.Yes");
            String s2 = Messages.getString("SearchProfilePropertiesDialog.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("SearchProfilePropertiesDialog.ProfileNotSaved"), Messages.getString("SearchProfilePropertiesDialog.ColseConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    public DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                if (((SearchSet)list.get(i)).getTypeName().compareTo(((SearchSet)list.get(i - 1)).getTypeName()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private class FilterPropertiesListener
    implements DocumentListener {
        private FilterPropertiesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchProfilePropertiesDialog.this.newFilter(SearchProfilePropertiesDialog.this.propertiesFilter, SearchProfilePropertiesDialog.this.propertiesTable);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchProfilePropertiesDialog.this.newFilter(SearchProfilePropertiesDialog.this.propertiesFilter, SearchProfilePropertiesDialog.this.propertiesTable);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchProfilePropertiesDialog.this.newFilter(SearchProfilePropertiesDialog.this.propertiesFilter, SearchProfilePropertiesDialog.this.propertiesTable);
        }
    }

    private class TxtFieldsListener
    implements DocumentListener {
        private TxtFieldsListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SearchPP cfr_ignored_0 = SearchProfilePropertiesDialog.this.parent;
            SearchPP.validateDirectory(SearchProfilePropertiesDialog.this.txtFilePath);
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getFileName().equals(SearchProfilePropertiesDialog.this.txtName.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getFilePath().equals(SearchProfilePropertiesDialog.this.txtFilePath.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getDescription().equals(SearchProfilePropertiesDialog.this.description.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SearchPP cfr_ignored_0 = SearchProfilePropertiesDialog.this.parent;
            SearchPP.validateDirectory(SearchProfilePropertiesDialog.this.txtFilePath);
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getFileName().equals(SearchProfilePropertiesDialog.this.txtName.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getFilePath().equals(SearchProfilePropertiesDialog.this.txtFilePath.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getDescription().equals(SearchProfilePropertiesDialog.this.description.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SearchPP cfr_ignored_0 = SearchProfilePropertiesDialog.this.parent;
            SearchPP.validateDirectory(SearchProfilePropertiesDialog.this.txtFilePath);
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getFileName().equals(SearchProfilePropertiesDialog.this.txtName.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getFilePath().equals(SearchProfilePropertiesDialog.this.txtFilePath.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
            if (!SearchProfilePropertiesDialog.this.originalSearchProfile.getDescription().equals(SearchProfilePropertiesDialog.this.description.getText())) {
                SearchProfilePropertiesDialog.this.isSaved = false;
            }
        }
    }

    private class ObjectSelectionListener
    implements ListSelectionListener {
        private ObjectSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            SearchProfilePropertiesDialog.this.propertiesList.clear();
            SearchProfilePropertiesDialog.this.propertiesFilter.setText("");
            SearchSet selectedSearchSet = null;
            if (SearchProfilePropertiesDialog.this.objectsPane.getSelectedComponent() == SearchProfilePropertiesDialog.this.relationalModelObjectsScrollPane) {
                if (SearchProfilePropertiesDialog.this.relationalModelObjectsList.getSelectedIndex() != -1) {
                    selectedSearchSet = (SearchSet)SearchProfilePropertiesDialog.this.relationalModelObjectsModel.get(SearchProfilePropertiesDialog.this.relationalModelObjectsList.getSelectedIndex());
                }
            } else if (SearchProfilePropertiesDialog.this.objectsPane.getSelectedComponent() == SearchProfilePropertiesDialog.this.logicalModelObjectsScrollPane && SearchProfilePropertiesDialog.this.logicalModelObjectsList.getSelectedIndex() != -1) {
                selectedSearchSet = (SearchSet)SearchProfilePropertiesDialog.this.logicalModelObjectsModel.get(SearchProfilePropertiesDialog.this.logicalModelObjectsList.getSelectedIndex());
            }
            if (selectedSearchSet != null) {
                SearchProfilePropertiesDialog.this.reloadSearchableProperties(selectedSearchSet);
                SearchProfilePropertiesDialog.this.btnSelectAll.setEnabled(true);
                SearchProfilePropertiesDialog.this.btnDeselectAll.setEnabled(true);
                SearchProfilePropertiesDialog.this.propertiesFilter.setEnabled(true);
                SearchProfilePropertiesDialog.this.propertiesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(SearchProfilePropertiesDialog.this.propertiesTable, 0);
            } else {
                SearchProfilePropertiesDialog.this.btnSelectAll.setEnabled(false);
                SearchProfilePropertiesDialog.this.btnDeselectAll.setEnabled(false);
                SearchProfilePropertiesDialog.this.propertiesFilter.setEnabled(false);
                SearchProfilePropertiesDialog.this.propertiesTable.setAutoCreateRowSorter(false);
                SearchProfilePropertiesDialog.this.propertiesTable.setRowSorter(null);
            }
            SearchProfilePropertiesDialog.this.propertiesTable.updateUI();
        }
    }

    class SearchSetRenderer
    extends JLabel
    implements ListCellRenderer {
        SearchSetRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SearchSet ss = (SearchSet)value;
            this.setText(ss.getTypeName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class PropertiesModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SearchProfilePropertiesDialog.Property"), Messages.getString("SearchProfilePropertiesDialog.Use")};

        private PropertiesModel() {
        }

        @Override
        public int getRowCount() {
            return SearchProfilePropertiesDialog.this.propertiesList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchProfile.Property p = (SearchProfile.Property)SearchProfilePropertiesDialog.this.propertiesList.get(rowIndex);
            if (columnIndex == 0) {
                return ReportUtils.getDisplayName(p.getPd().name);
            }
            if (columnIndex == 1) {
                return p.isUsed();
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SearchProfile.Property p = (SearchProfile.Property)SearchProfilePropertiesDialog.this.propertiesList.get(rowIndex);
            if (columnIndex == 1) {
                boolean v = (Boolean)aValue;
                if (p.isUsed() != v) {
                    SearchProfilePropertiesDialog.this.isSaved = false;
                }
                p.setUsed(v);
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SearchProfilePropertiesDialog.this.txtName.getText() == null || SearchProfilePropertiesDialog.this.txtName.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(SearchProfilePropertiesDialog.this, Messages.getString("SearchProfilePropertiesDialog.NameCanNotBeEmpty"), Messages.getString("SearchProfilePropertiesDialog.Error"), 0);
                return;
            }
            if (SearchProfilePropertiesDialog.this.txtFilePath.getText() == null || SearchProfilePropertiesDialog.this.txtFilePath.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(SearchProfilePropertiesDialog.this, Messages.getString("SearchProfilePropertiesDialog.FilePathCanNotBeEmpty"), Messages.getString("SearchProfilePropertiesDialog.Error"), 0);
                return;
            }
            SearchProfilePropertiesDialog.this.originalSearchProfile.setFileName(SearchProfilePropertiesDialog.this.txtName.getText());
            SearchProfilePropertiesDialog.this.originalSearchProfile.setFilePath(SearchProfilePropertiesDialog.this.txtFilePath.getText());
            SearchProfilePropertiesDialog.this.originalSearchProfile.setDescription(SearchProfilePropertiesDialog.this.description.getText());
            boolean fileSaved = SearchProfilePropertiesDialog.this.persistence.save(SearchProfilePropertiesDialog.this.originalSearchProfile, true);
            if (fileSaved) {
                if (!SearchProfilePropertiesDialog.this.appView.getSearchProfiles().contains(SearchProfilePropertiesDialog.this.originalSearchProfile)) {
                    SearchProfilePropertiesDialog.this.appView.getSearchProfiles().add(SearchProfilePropertiesDialog.this.originalSearchProfile);
                }
                SearchProfilePropertiesDialog.this.parent.updateTable();
                SearchProfilePropertiesDialog.this.parent.reloadActiveSearchProfileComboBox();
                SearchProfilePropertiesDialog.this.parent.reloadSearchDockablePanels();
                ReportUtils.reloadSearchProfilesMap(SearchProfilePropertiesDialog.this.getApplicationView());
                SearchProfilePropertiesDialog.this.isSaved = true;
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SearchProfilePropertiesDialog.this.canClose()) {
                SearchProfilePropertiesDialog.this.close();
            }
        }
    }
}

