/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class DeleteGlossaryDialog
extends JDialog {
    private static final String KEY_ESCAPE = "ESCAPE";
    private JTable jtable;
    private JTable glossTable;
    private List elmList;
    private List glossList;
    private List allGlossaries;
    private Connection connection;
    private JButton bnDelete;
    private static final Logger LOGGER = new Logger(DeleteGlossaryDialog.class);
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeleteGlossaryDialog.this.dispose();
        }
    };

    public DeleteGlossaryDialog(Frame owner, Connection connection) {
        super(owner, "Select Glossary and Repository Version");
        this.connection = connection;
        this.getContentPane().add((Component)this.init(), "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        this.setSize(new Dimension(800, 350));
        CommonUtil.centerOnScreen(this);
        this.setModal(true);
    }

    private JPanel init() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.glossList = new ArrayList();
        this.glossTable = new JTable(new GlossaryTableModel());
        this.glossTable.setSelectionMode(0);
        this.glossTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = DeleteGlossaryDialog.this.glossTable.getSelectedRow();
                if (row != -1 && DeleteGlossaryDialog.this.glossList.size() > 0 && row < DeleteGlossaryDialog.this.glossList.size()) {
                    GlossaryDescriptor glossObj = (GlossaryDescriptor)DeleteGlossaryDialog.this.glossList.get(row);
                    DeleteGlossaryDialog.this.loadVersions(glossObj);
                }
            }
        });
        JScrollPane spd = new JScrollPane(this.glossTable);
        this.elmList = new ArrayList();
        this.jtable = new JTable(new ElementTableModel());
        this.jtable.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.jtable.getColumnModel().getColumn(3).setPreferredWidth(120);
        JScrollPane sp = new JScrollPane(this.jtable);
        JSplitPane splitPane = new JSplitPane(1, spd, sp);
        splitPane.setDividerLocation(220);
        jpanel.add(splitPane);
        return jpanel;
    }

    public JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        this.bnDelete = new JButton(Messages.getString("DeleteGlossaryDialog.DeleteSelected"));
        this.bnDelete.setMnemonic(68);
        this.bnDelete.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.bnDelete.setEnabled(false);
        this.bnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteGlossaryDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    DeleteGlossaryDialog.this.deleteSelectedGlossaries();
                }
                finally {
                    DeleteGlossaryDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                DeleteGlossaryDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.bnDelete);
        bottomPanel.add(this.bnDelete);
        JButton bnCancel = new JButton(Messages.getString("Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteGlossaryDialog.this.dispose();
            }
        });
        bottomPanel.add(bnCancel);
        return bottomPanel;
    }

    private void loadGlossaryNames() {
        for (GlossaryDescriptor next : this.allGlossaries) {
            GlossaryDescriptor glossObj = this.getGlossary(this.glossList, next.getID());
            if (glossObj != null) continue;
            this.glossList.add(next);
        }
        Collections.sort(this.glossList);
        this.glossTable.updateUI();
        if (this.glossList.size() > 0) {
            this.glossTable.setRowSelectionInterval(0, 0);
        }
    }

    private GlossaryDescriptor getGlossary(List list, String id) {
        for (GlossaryDescriptor glossObj : list) {
            if (!id.equalsIgnoreCase(glossObj.getID())) continue;
            return glossObj;
        }
        return null;
    }

    private List getGlossaries(List list, String id) {
        ArrayList<GlossaryDescriptor> result = new ArrayList<GlossaryDescriptor>();
        for (GlossaryDescriptor glossObj : list) {
            if (!id.equalsIgnoreCase(glossObj.getID())) continue;
            result.add(glossObj);
        }
        return result;
    }

    private void enableDelete() {
        boolean enable = false;
        for (GlossaryDescriptor glossObj : this.allGlossaries) {
            if (!glossObj.isSelected()) continue;
            enable = true;
            break;
        }
        this.bnDelete.setEnabled(enable);
    }

    private boolean loadGlossaries() {
        boolean result;
        block10: {
            result = false;
            try {
                this.allGlossaries = new ArrayList();
                if (this.connection == null) break block10;
                try {
                    float vers = SchemaFactory.schemaVersion(this.connection);
                    if (vers != 0.0f) {
                        String query = "SELECT Glossary_ID, Glossary_OVID, Glossary_Name, to_char(Date_Published, 'DD.MM.YYYY HH24:MI'), File_Name, Version_Comments FROM DMRS_Glossaries ORDER BY Glossary_ID, Date_Published ASC";
                        try {
                            Statement stmt = this.connection.createStatement();
                            ResultSet rset = stmt.executeQuery(query);
                            while (rset.next()) {
                                String id = rset.getString(1);
                                String ovid = rset.getString(2);
                                String name = rset.getString(3);
                                String date = rset.getString(4);
                                String file = rset.getString(5);
                                String comments = rset.getString(6);
                                GlossaryDescriptor glossObj = new GlossaryDescriptor(name, id);
                                glossObj.setOvid(ovid);
                                glossObj.setDate(date);
                                glossObj.setFile(file);
                                if (comments != null) {
                                    glossObj.setComments(comments);
                                }
                                this.allGlossaries.add(glossObj);
                            }
                            stmt.close();
                            this.loadGlossaryNames();
                            result = true;
                        }
                        catch (SQLException sQLException) {}
                        break block10;
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteGlossaryDialog.RepositoryNotWorking"));
                }
                catch (DifferentVersionException dve) {
                    MessageDialogs.showWarningMessage(Messages.getString("DeleteGlossaryDialog.DbSchemaOutOFDate"));
                }
                catch (Exception e) {
                    LOGGER.error("DeleteGlossaryDialog.loadGlossaries", e);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteGlossaryDialog.UnableToLoadGlossaries"), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedGlossaries() {
        block12: {
            try {
                if (this.connection == null) break block12;
                boolean autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                try {
                    for (GlossaryDescriptor next : this.allGlossaries) {
                        if (!next.isSelected()) continue;
                        String ovid = next.getOvid();
                        String query = "DELETE FROM DMRS_GLOSSARY_TERMS WHERE Glossary_OVID='" + ovid + "'";
                        PreparedStatement stmt = this.connection.prepareStatement(query);
                        try {
                            stmt.executeUpdate();
                            query = "DELETE FROM DMRS_GLOSSARIES WHERE Glossary_OVID='" + ovid + "'";
                            stmt = this.connection.prepareStatement(query);
                            stmt.executeUpdate();
                        }
                        finally {
                            JDBCUtils.close(stmt);
                        }
                    }
                    MessageDialogs.showMessage(Messages.getString("DeleteGlossaryDialog.SelectedGlosariesDeleted"));
                }
                catch (Exception e) {
                    if (this.connection != null) {
                        this.connection.rollback();
                    }
                    LOGGER.error("DeleteGlossaryDialog.deleteSelectedGlossaries", e);
                    MessageDialogs.showErrorMessage(Messages.getString("DeleteGlossaryDialog.UnableToDeleteSelectedGlossaries"), true);
                }
                finally {
                    this.connection.setAutoCommit(autoCommit);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadVersions(GlossaryDescriptor glossObj) {
        this.elmList.clear();
        try {
            this.elmList.addAll(this.getGlossaries(this.allGlossaries, glossObj.getID()));
            Collections.sort(this.elmList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jtable.updateUI();
    }

    public static void showDialog(Frame owner, Connection connection) {
        DeleteGlossaryDialog dialog = new DeleteGlossaryDialog(owner, connection);
        if (dialog.loadGlossaries()) {
            dialog.setVisible(true);
        } else {
            dialog.dispose();
        }
    }

    private class ElementTableModel
    extends AbstractTableModel {
        private ElementTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DeleteGlossaryDialog.this.elmList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DeleteGlossaryDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DeleteGlossaryDialog.Date");
            }
            if (column == 2) {
                return Messages.getString("DeleteGlossaryDialog.FileName");
            }
            if (column == 3) {
                return Messages.getString("DeleteGlossaryDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            GlossaryDescriptor version = (GlossaryDescriptor)DeleteGlossaryDialog.this.elmList.get(row);
            if (col == 0) {
                return version.isSelected();
            }
            if (col == 1) {
                return version.getDate();
            }
            if (col == 2) {
                return version.getFile();
            }
            if (col == 3) {
                return version.getComments();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 0) {
                GlossaryDescriptor version = (GlossaryDescriptor)DeleteGlossaryDialog.this.elmList.get(row);
                version.setSelected((Boolean)aValue);
                DeleteGlossaryDialog.this.enableDelete();
            }
        }
    }

    private class GlossaryTableModel
    extends AbstractTableModel {
        private GlossaryTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return DeleteGlossaryDialog.this.glossList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DeleteGlossaryDialog.GlossaryName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            GlossaryDescriptor glossObj = (GlossaryDescriptor)DeleteGlossaryDialog.this.glossList.get(row);
            if (col == 0) {
                return glossObj.getName();
            }
            return new Integer(row * col);
        }
    }

    public class GlossaryDescriptor
    implements Comparable {
        private String name;
        private String id;
        private String ovid;
        private String comments = "";
        private String file;
        private String date;
        private boolean selected = false;

        public GlossaryDescriptor(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getID() {
            return this.id;
        }

        public String getOvid() {
            return this.ovid;
        }

        public void setOvid(String ovid) {
            this.ovid = ovid;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public int compareTo(Object o) {
            return this.getName().compareToIgnoreCase(((GlossaryDescriptor)o).getName());
        }
    }
}

