/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;

public class RaptorTaskSerialiser
implements Runnable {
    Vector<RaptorTask> tasks = new Vector();
    Iterator<RaptorTask> taskIterator;
    TaskListener taskListener = new TaskListener();
    RaptorTask currentTask;

    public RaptorTaskSerialiser(RaptorTask ... raptorTaskArray) {
        if (raptorTaskArray != null) {
            for (RaptorTask raptorTask : raptorTaskArray) {
                if (raptorTask == null) continue;
                this.tasks.add(raptorTask);
            }
        }
    }

    public RaptorTaskSerialiser(List<RaptorTask> list) {
        Collections.copy(this.tasks, list);
    }

    @Override
    public void run() {
        this.taskIterator = this.tasks.iterator();
        if (this.taskIterator.hasNext()) {
            this.runTask(this.taskIterator.next());
        }
    }

    private void runTask(RaptorTask raptorTask) {
        this.currentTask = raptorTask;
        if (raptorTask != null) {
            RaptorTaskDescriptor raptorTaskDescriptor = raptorTask.getDescriptor();
            System.out.println("Running task : " + raptorTaskDescriptor.getName() + "(" + raptorTaskDescriptor.getMessage() + ")");
            raptorTaskDescriptor.addListener((IRaptorTaskListener)this.taskListener);
            RaptorTaskManager.getInstance().addTask(raptorTask);
        } else {
            this.nextTask();
        }
    }

    private void nextTask() {
        if (this.currentTask != null) {
            RaptorTaskDescriptor raptorTaskDescriptor = this.currentTask.getDescriptor();
            raptorTaskDescriptor.removeListener((IRaptorTaskListener)this.taskListener);
        }
        if (this.taskIterator.hasNext()) {
            this.runTask(this.taskIterator.next());
        }
    }

    private class TaskListener
    extends RaptorTaskAdapter {
        private TaskListener() {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskSerialiser.this.nextTask();
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskSerialiser.this.nextTask();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskSerialiser.this.nextTask();
        }
    }
}

