/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NamedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.OffsetModifier;

public class ScheduleClause
implements Comparable<ScheduleClause>,
ClauseElement {
    protected final NamedSchedule namedSchedule;
    protected final OffsetModifier offsetModifier;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public ScheduleClause(NamedSchedule namedSchedule, OffsetModifier offsetModifier) {
        this.namedSchedule = namedSchedule;
        this.offsetModifier = offsetModifier;
    }

    public ScheduleClause(NamedSchedule namedSchedule) {
        this.namedSchedule = namedSchedule;
        this.offsetModifier = null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ScheduleClause scheduleClause = (ScheduleClause)object;
        return ScheduleClause.areEqual(this.namedSchedule, scheduleClause.namedSchedule) && ScheduleClause.areEqual(this.offsetModifier, scheduleClause.offsetModifier);
    }

    @Override
    public int compareTo(ScheduleClause scheduleClause) {
        int n = 0;
        if (this != scheduleClause) {
            if (this.namedSchedule != scheduleClause.namedSchedule) {
                n = this.namedSchedule == null && scheduleClause.namedSchedule != null ? -1 : (this.namedSchedule != null && scheduleClause.namedSchedule == null ? 1 : this.namedSchedule.compareTo(scheduleClause.namedSchedule));
            }
            if (n == 0 && this.offsetModifier != scheduleClause.offsetModifier) {
                n = this.offsetModifier == null && scheduleClause.offsetModifier != null ? -1 : (this.offsetModifier != null && scheduleClause.offsetModifier == null ? 1 : this.offsetModifier.compareTo(scheduleClause.offsetModifier));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.namedSchedule == null ? 0 : this.namedSchedule.hashCode());
        n = n * 31 + (this.offsetModifier == null ? 0 : this.offsetModifier.hashCode());
        return n;
    }

    public NamedSchedule getNamedSchedule() {
        return this.namedSchedule;
    }

    public OffsetModifier getOffsetModifier() {
        return this.offsetModifier;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        if (this.namedSchedule != null) {
            this.namedSchedule.buildClause(stringBuilder);
            if (this.offsetModifier != null) {
                this.offsetModifier.buildClause(stringBuilder);
            }
        }
        return stringBuilder;
    }
}

