/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractPanel
extends JPanel
implements WorksheetResultPanel {
    protected int PIN_CMD_ID = 68;
    protected int NULL_CMD_ID = -123456;
    boolean isExplainPlan;
    Map<RaptorTaskDescriptor, ITaskUI> _descUIMap;
    JPanel _statusPanel;
    private JLabel _statusLabel;
    protected boolean m_isPinned;
    protected ToggleToolButton _pinToggle;
    private WorksheetState m_state;
    private String m_id;
    private String m_tabName;
    private static final long serialVersionUID = 1L;
    protected Toolbar _toolbar;
    private WorksheetContext m_ctx;
    private Icon overlayIcon;
    private final Icon _waiting;
    private final Icon _running;
    private final Icon _problemIcon;

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public WorksheetState getState() {
        return this.m_state;
    }

    @Override
    public String getTabLabel() {
        return this.m_tabName;
    }

    @Override
    public void setTabLabel(String string) {
        this.m_tabName = string;
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public void setState(WorksheetState worksheetState) {
        this.m_state = worksheetState;
    }

    public void tabClosed() {
    }

    public AbstractPanel(String string, String string2) {
        DBConfig dBConfig = null;
        try {
            dBConfig = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            dBConfig = new DBConfig();
        }
        this.m_isPinned = dBConfig.getBoolean("AUTOPIN_RESULTS_TABS");
        this.isExplainPlan = false;
        this._descUIMap = new HashMap<RaptorTaskDescriptor, ITaskUI>();
        this._statusPanel = new JPanel(new BorderLayout());
        this._statusLabel = new JLabel();
        this.m_isPinned = false;
        this.m_state = WorksheetState.CLOSED;
        this.m_id = null;
        this.overlayIcon = null;
        this._waiting = IImageRegistry.LIGHT_YELLOW;
        this._running = OracleIcons.getIcon((String)"throbber.gif");
        this._problemIcon = OracleIcons.getIcon((String)"exception.png");
        this.m_id = string;
        this.m_tabName = string2;
    }

    void addSQLbutton() {
    }

    void addHotspotButton() {
    }

    void addSearchPanel() {
    }

    protected void initToolbar() {
        if (this.m_id == null) {
            return;
        }
        this._toolbar = new Toolbar();
        this.add((Component)this._toolbar, "North");
        if (this.PIN_CMD_ID != this.NULL_CMD_ID && this.isCloseable()) {
            Icon icon = this.m_isPinned ? RaptorImagesArb.getIcon((String)"PINNED") : OracleIcons.getIcon((String)"pin.png");
            ToggleAction toggleAction = new ToggleAction(Messages.getString("AbstractWorksheetResultPanel.1"), icon){

                public void actionPerformed(ActionEvent actionEvent) {
                    Icon icon = AbstractPanel.this.m_isPinned ? OracleIcons.getIcon((String)"pin.png") : RaptorImagesArb.getIcon((String)"PINNED");
                    AbstractPanel.this._pinToggle.setIcon(icon);
                    AbstractPanel.this.m_isPinned = !AbstractPanel.this.m_isPinned;
                }
            };
            toggleAction.setName(toggleAction.getValue("Name").toString());
            this._pinToggle = this._toolbar.addToggleButton(toggleAction);
            toggleAction.setState(this.isPinned());
            this._pinToggle.setIcon(icon);
        }
        this.addSQLbutton();
        if (!this.isExplainPlan) {
            this.addHotspotButton();
        }
        this.addSearchPanel();
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this._statusPanel.setOpaque(false);
        this._statusLabel.setOpaque(false);
        this._toolbar.add((Component)this._statusPanel);
        this._toolbar.add(Box.createHorizontalGlue());
    }

    @Override
    public boolean isPinned() {
        return this.m_isPinned;
    }

    @Override
    public void setPinned(boolean bl) {
        if (this._pinToggle.isSelected() && !bl) {
            this._pinToggle.doClick();
        } else if (!this._pinToggle.isSelected() && bl) {
            this._pinToggle.doClick();
        }
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public String getTabToolTip() {
        return this.getTabLabel();
    }

    public String getLastStatusMessage() {
        return null;
    }

    public void publishStatusMessage(String string, Exception exception) {
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
    }

    public void setStatusMessage(String string, Exception exception) {
    }

    @Override
    public WorksheetContext getContext() {
        return this.m_ctx;
    }

    @Override
    public void setContext(WorksheetContext worksheetContext) {
        this.m_ctx = worksheetContext;
    }

    @Override
    public Icon getTabIcon() {
        return this.overlayIcon;
    }

    public void setOverlayIcon(Icon icon) {
        this.overlayIcon = icon;
    }

    public final class ResultsPanelTaskListener
    extends RaptorTaskAdapter {
        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            AbstractPanel.this.setOverlayIcon(AbstractPanel.this._waiting);
        }

        public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
            AbstractPanel.this.setOverlayIcon(AbstractPanel.this._running);
        }

        public void taskPaused(RaptorTaskEvent raptorTaskEvent) {
            AbstractPanel.this.setOverlayIcon(AbstractPanel.this._waiting);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                this.showError(raptorTaskEvent);
            } else {
                AbstractPanel.this.setOverlayIcon(null);
                this.removeTask(raptorTaskEvent);
            }
        }

        private void showError(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (throwable != null) {
                throwable.printStackTrace();
            }
            AbstractPanel.this.setOverlayIcon(AbstractPanel.this._problemIcon);
            this.removeTask(raptorTaskEvent);
        }

        private void removeTask(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JPanel jPanel = AbstractPanel.this._statusPanel;
                    synchronized (jPanel) {
                        RaptorTaskDescriptor raptorTaskDescriptor = raptorTaskEvent.getTaskDescriptor();
                        if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTaskDescriptor.getStatus())) {
                            AbstractPanel.this._descUIMap.remove(raptorTaskDescriptor);
                            AbstractPanel.this._statusPanel.add(Box.createHorizontalStrut(5));
                            AbstractPanel.this._statusPanel.add(AbstractPanel.this._statusLabel);
                            this.updateTimer(raptorTaskEvent.getTaskDescriptor().getElapsedTime());
                            AbstractPanel.this._toolbar.revalidate();
                            AbstractPanel.this._toolbar.repaint();
                        }
                    }
                }

                private void updateTimer(long l) {
                    float f = 0.0f;
                    if (l > 0L) {
                        f = Float.parseFloat("" + l) / 1000.0f;
                    }
                    Object[] objectArray = new Object[]{new Float(f)};
                    String string = MessageFormat.format(Messages.getString("Worksheet.4"), objectArray);
                    AbstractPanel.this._statusLabel.setText(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

