/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.Distinct;
import oracle.dmt.dataminer.core.dal.sql.builder.Order;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlStringMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public abstract class StringSearchQuery
extends SqlBaseModelQuery<String, OraclePreparedStatement> {
    private String searchString;
    private SqlUtils.LikeMode likeSearchMode = SqlUtils.LikeMode.CONTAINS;

    public StringSearchQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlStringMapper(), modelDescriptor);
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.select(Distinct.columns(this.getColumn())).from(this.getSource()).where(Conditional.equals(this.getPartitionColumnName(), this.getPartitionId()), Conditional.like(this.getColumnExpression(), this.getColumn(), this.searchString), this.getAdditionalConditions()).orderBy(Order.ASC(this.getColumn()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(this.getSchemaReplacement(), this.getSchema());
        hashMap.put(this.getModelNameReplacement(), this.getModelName());
        String string = StringUtils.getReplacedString(sqlBuilder.toString(), hashMap);
        return string;
    }

    protected String getAdditionalConditions() {
        return "";
    }

    protected abstract String getSource();

    protected abstract String getColumn();

    protected String getColumnExpression() {
        return this.getColumn();
    }

    protected String getPartitionColumnName() {
        return "PARTITION_NAME";
    }

    protected String getSchemaReplacement() {
        return "SCHEMA";
    }

    protected String getModelNameReplacement() {
        return "MODEL_NAME";
    }

    public void setSearchString(String string) {
        this.searchString = string;
    }

    public void setLikeSearchMode(SqlUtils.LikeMode likeMode) {
        this.likeSearchMode = likeMode;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, this.getPartitionColumnName(), this.getPartitionId());
        if (this.searchString != null) {
            SqlUtils.setLikeParameter((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, this.getColumn(), this.searchString, this.likeSearchMode);
        }
    }
}

