/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.ar.ARNodeSettings;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class AssociationItemSetQuery
extends ModelDetailsQuery {
    private ARNodeSettings _nodeSettings;

    public AssociationItemSetQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, ARNodeSettings aRNodeSettings, boolean bl) {
        super(version, modelDetailType, list, map, bl);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
    }

    public AssociationItemSetQuery(Version version, ModelDetailType modelDetailType, ARNodeSettings aRNodeSettings) {
        super(version, modelDetailType);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"SUPPORT", "NUMBER"}, {"NUMBER_OF_ITEMS", "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_STR_VALUE", "VARCHAR2"}, {"ATTRIBUTE_NUM_VALUE", "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"SUPPORT", "NUMBER"}, {"NUMBER_OF_ITEMS", "NUMBER"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_STR_VALUE", "VARCHAR2"}, {"ATTRIBUTE_NUM_VALUE", "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        Object object = null;
        object = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\", \n     PARTITION_NAME as \"{$PARTITION_NAME}\",\n     ITEMSET_ID as \"{$ID}\", \n     SUPPORT as \"{$SUPPORT}\", \n     NUMBER_OF_ITEMS as \"{$NUMBER_OF_ITEMS}\", \n     CAST('" + this._nodeSettings.getItemID() + "' AS VARCHAR(30)) as \"{$ATTRIBUTE_NAME}\", \n     ITEM_NAME as \"{$ATTRIBUTE_SUBNAME}\", \n     ITEM_VALUE as \"{$ATTRIBUTE_STR_VALUE}\", \n     ' ' as \"{$ATTRIBUTE_NUM_VALUE}\" \n     FROM {$MODEL_SCHEMA_VALUE}.DM$VI{$MODEL_NAME_VALUE} V,\n      XMLTABLE('/itemset/item' \n       PASSING V.ITEMSET \n       COLUMNS \n         ITEM_NAME VARCHAR2(128) PATH 'item_name', \n         ITEM_VALUE VARCHAR2(128) PATH 'item_value')" : "\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\", \n     itemset_id as \"{$ID}\", \n     support as \"{$SUPPORT}\", \n     number_of_items as \"{$NUMBER_OF_ITEMS}\", \n     item.attribute_name as \"{$ATTRIBUTE_NAME}\", \n     item.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\", \n     item.attribute_num_value as \"{$ATTRIBUTE_NUM_VALUE}\", \n     item.attribute_str_value as \"{$ATTRIBUTE_STR_VALUE}\" \n     FROM TABLE(dbms_data_mining.get_frequent_itemsets('{$GET_MODEL_NAME}',   NULL,   NULL)) t, \n     TABLE(t.items) item";
        return object;
    }
}

