/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class DTFullTreeQuery
extends ModelDetailsQuery {
    static final String NODE_ID = "NODE_ID";
    static final String PARENT_NODE_ID = "PARENT_NODE_ID";
    static final String TOTAL_RECORD_COUNT = "TOTAL_RECORD_COUNT";
    static final String PREDICTION_COUNT = "PREDICTION_COUNT";
    static final String IS_LEAF_NODE = "IS_LEAF_NODE";
    static final String LOCAL_RULE = "LOCAL_RULE";
    static final String LOCAL_SURROGATE = "LOCAL_SURROGATE";
    private static final String DT_LEAF_NODES_ONLY_QUERY = " AND IS_LEAF = 1 ";
    private static final String DT_LEAF_NODES_ONLY_QUERY_122 = "WHERE IS_LEAF = 'Y' ";

    public DTFullTreeQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
        this.hasWithBlock = DbVersionHelper.isDB122Up(version);
    }

    public DTFullTreeQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {PARENT_NODE_ID, "VARCHAR2"}, {NODE_ID, "VARCHAR2"}, {"PROFILE_ID", "NUMBER"}, {"PREDICTION", "VARCHAR2"}, {PREDICTION_COUNT, "NUMBER"}, {"RECORD_COUNT", "NUMBER"}, {TOTAL_RECORD_COUNT, "NUMBER"}, {IS_LEAF_NODE, "VARCHAR2"}, {"CONFIDENCE", "NUMBER"}, {"SUPPORT", "NUMBER"}, {LOCAL_RULE, "VARCHAR2"}, {LOCAL_SURROGATE, "VARCHAR2"}, {"FULL_SIMPLE_RULE", "VARCHAR2"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {PARENT_NODE_ID, "VARCHAR2"}, {NODE_ID, "VARCHAR2"}, {"PROFILE_ID", "NUMBER"}, {"PREDICTION", "VARCHAR2"}, {PREDICTION_COUNT, "NUMBER"}, {"RECORD_COUNT", "NUMBER"}, {TOTAL_RECORD_COUNT, "NUMBER"}, {IS_LEAF_NODE, "VARCHAR2"}, {"CONFIDENCE", "NUMBER"}, {"SUPPORT", "NUMBER"}, {LOCAL_RULE, "VARCHAR2"}, {LOCAL_SURROGATE, "VARCHAR2"}, {"FULL_SIMPLE_RULE", "VARCHAR2"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\nSELECT \nCAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\nCAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\nVI.PARTITION_NAME as \"{$PARTITION_NAME}\",\nVO.PARENT as \"{$PARENT_NODE_ID}\",\nVI.NODE as \"{$NODE_ID}\",\nVO.NODE + 1 as \"{$PROFILE_ID}\",\nVO.PREDICTED_TARGET_VALUE as \"{$PREDICTION}\",\nVI.TARGET_SUPPORT as \"{$PREDICTION_COUNT}\",\nVI.NODE_SUPPORT as \"{$RECORD_COUNT}\",\nVO.PARENT_SUPPORT as \"{$TOTAL_RECORD_COUNT}\",\nVO.IS_LEAF as \"{$IS_LEAF_NODE}\",\nVI.TARGET_SUPPORT/VI.NODE_SUPPORT as \"{$CONFIDENCE}\",\nVI.NODE_SUPPORT/VO.PARENT_SUPPORT as \"{$SUPPORT}\",\nRL.LOCAL_RULE as \"{$LOCAL_RULE}\",\nRL.LOCAL_SURROGATE as \"{$LOCAL_SURROGATE}\",\nRL.FULL_RULE as \"{$FULL_SIMPLE_RULE}\"\nFROM {$MODEL_SCHEMA_VALUE}.DM$VI{$MODEL_NAME_VALUE} VI \nINNER JOIN\n(SELECT VO.PARTITION_NAME, VO.PARENT, VO.NODE, VO.PREDICTED_TARGET_VALUE, O.NODE_SUPPORT PARENT_SUPPORT, decode(P.PARENT, null, 'Y', 'N') IS_LEAF\nFROM {$MODEL_SCHEMA_VALUE}.DM$VO{$MODEL_NAME_VALUE} VO \nINNER JOIN (SELECT PARTITION_NAME, NODE_SUPPORT FROM {$MODEL_SCHEMA_VALUE}.DM$VO{$MODEL_NAME_VALUE} WHERE NODE = 0) O\nON NVL(VO.PARTITION_NAME, 0) = NVL(O.PARTITION_NAME, 0) \nLEFT JOIN (SELECT DISTINCT PARENT, PARTITION_NAME FROM {$MODEL_SCHEMA_VALUE}.DM$VO{$MODEL_NAME_VALUE}) P \nON VO.NODE = P.PARENT and NVL(VO.PARTITION_NAME, 0) = NVL(P.PARTITION_NAME, 0)) VO \nON VI.NODE = VO.NODE and NVL(VI.PARTITION_NAME, 0) = NVL(VO.PARTITION_NAME, 0) and VI.TARGET_VALUE = VO.PREDICTED_TARGET_VALUE \nLEFT JOIN \"{$NODE_SQL_NAME}.{$MODEL_POSITION}.2\" RL ON VI.NODE = RL.NODE AND NVL(VI.PARTITION_NAME, 0) = NVL(RL.PARTITION_NAME, 0) \n{$LEAF_NODES_ONLY_QUERY}" : "\n    SELECT TO_CHAR(pid)                      AS \"PARENT_NODE_ID\",\n    TO_CHAR(nid)                               AS \"NODE_ID\",\n    rownum                                     AS \"PROFILE_ID\",\n    score                                      AS \"PREDICTION\",\n    rec                                        AS \"RECORD_COUNT\",\n    pred_count                                 AS \"PREDICTION_COUNT\",\n    total_rec_count                            AS \"TOTAL_RECORD_COUNT\",\n    pred_count / rec                           AS \"CONFIDENCE\",\n    rec        / total_rec_count               AS \"SUPPORT\",\n    rule_pred                                  AS \"LOCAL_RULE\",\n    surr_pred                                  AS \"LOCAL_SURROGATE\",\n    rtrim(REPLACE(full_rule,'$O$D$M$'),' AND') AS \"FULL_SIMPLE_RULE\",\n    CAST(DECODE(is_leaf,'0','N','Y') AS VARCHAR2(3))            AS \"IS_LEAF_NODE\",\n    CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30))  AS \"MODEL_SCHEMA\",\n    CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30))  AS \"MODEL_NAME\"\n  FROM\n    (SELECT row_number() over (partition BY nid order by rn DESC) rn,\n      pid,\n      nid,\n      rec,\n      score,\n      rule_pred,\n      surr_pred,\n      full_rule,\n      is_leaf,\n      pred_count,\n      total_rec_count\n    FROM\n      (SELECT rn,\n        pid,\n        nid,\n        rec,\n        score,\n        rule_pred,\n        surr_pred,\n        sys_connect_by_path(pred, '$O$D$M$') full_rule,\n        is_leaf,\n        pred_count,\n        total_rec_count\n      FROM\n        (SELECT row_number() over (partition BY nid order by rid) rn,\n          pid,\n          nid,\n          rec,\n          score,\n          rule_pred,\n          surr_pred,\n          nvl2(pred,pred\n          || ' AND ',NULL) pred ,\n          is_leaf,\n          pred_count,\n          total_rec_count\n        FROM\n          (SELECT rid,\n            pid,\n            nid,\n            rec,\n            score,\n            rule_pred,\n            surr_pred,\n            DECODE(rn, 1, pred, NULL) pred,\n            is_leaf,\n            pred_count,\n            total_rec_count\n          FROM\n            (SELECT rid,\n              nid,\n              rec,\n              score,\n              pid,\n              rule_pred,\n              surr_pred,\n              nvl2(root_op, '('\n              || root_field\n              || ' '\n              || root_op\n              || ' '\n              || root_value\n              || ')', NULL) pred,\n              row_number() over (partition BY nid, root_field, root_op order by rid DESC) rn,\n              is_leaf,\n              pred_count,\n              total_rec_count\n            FROM\n              (SELECT connect_by_root(parent_node_id) rid,\n                child_node_id nid,\n                rec,\n                score,\n                connect_by_root(rule_field) root_field,\n                connect_by_root(rule_op) root_op,\n                connect_by_root(rule_value) root_value,\n                nvl2(rule_op, '('\n                || rule_field\n                || ' '\n                || rule_op\n                || ' '\n                || rule_value\n                || ')', NULL) rule_pred,\n                nvl2(surr_op, '('\n                || surr_field\n                || ' '\n                || surr_op\n                || ' '\n                || surr_value\n                || ')', NULL) surr_pred,\n                parent_node_id pid,\n                CONNECT_BY_ISLEAF is_leaf,\n                pred_count,\n                total_rec_count\n              FROM\n                (SELECT parent_node_id,\n                  child_node_id,\n                  rec,\n                  score,\n                  rule_field,\n                  surr_field,\n                  rule_op,\n                  surr_op,\n                  REPLACE(REPLACE(rule_value,CHR(38) || 'quot; ' || CHR(38) || 'quot;', ''', '''),CHR(38) || 'quot;', '''') rule_value,\n                  REPLACE(REPLACE(surr_value,CHR(38) || 'quot; ' || CHR(38) || 'quot;', ''', '''),CHR(38) || 'quot;', '''') surr_value,\n                  pred_count,\n                  total_rec_count\n                FROM\n                  (SELECT parent_node_id,\n                    child_node_id,\n                    rec,\n                    score,\n                    rule_field,\n                    surr_field,\n                    DECODE(rule_op,'lessOrEqual','{$=','greaterThan','}',rule_op) rule_op,\n                    DECODE(rule_op,'in','('\n                    ||rule_value\n                    ||')',rule_value) rule_value,\n                    DECODE(surr_op,'lessOrEqual','{$=','greaterThan','}',surr_op) surr_op,\n                    DECODE(surr_op,'in','('\n                    ||surr_value\n                    ||')',surr_value) surr_value,\n                    pred_count,\n                    total_rec_count\n                  FROM\n                    (SELECT *\n                    FROM XMLTable(\n                      'for $n in /PMML/TreeModel//Node let $rf := if (count($n/CompoundPredicate) > 0) then $n/CompoundPredicate/*[1]/@field else if (count($n/SimplePredicate) > 0) then $n/SimplePredicate/@field else $n/SimpleSetPredicate/@field let $ro := if (count($n/CompoundPredicate) > 0) then if ($n/CompoundPredicate/*[1] instance of element(SimplePredicate)) then $n/CompoundPredicate/*[1]/@operator else if ($n/CompoundPredicate/*[1] instance of element(SimpleSetPredicate)) then (\"in\") else () else if (count($n/SimplePredicate) > 0) then $n/SimplePredicate/@operator else if (count($n/SimpleSetPredicate) > 0) then (\"in\") else () let $rv := if (count($n/CompoundPredicate) > 0) then if ($n/CompoundPredicate/*[1] instance of element(SimplePredicate)) then $n/CompoundPredicate/*[1]/@value else $n/CompoundPredicate/*[1]/Array/text() else if (count($n/SimplePredicate) > 0) then $n/SimplePredicate/@value else $n/SimpleSetPredicate/Array/text() let $sf := if (count($n/CompoundPredicate) > 0) then $n/CompoundPredicate/*[2]/@field else () let $so := if (count($n/CompoundPredicate) > 0) then if ($n/CompoundPredicate/*[2] instance of element(SimplePredicate)) then $n/CompoundPredicate/*[2]/@operator else if ($n/CompoundPredicate/*[2] instance of element(SimpleSetPredicate)) then (\"in\") else () else () let $sv := if (count($n/CompoundPredicate) > 0) then if ($n/CompoundPredicate/*[2] instance of element(SimplePredicate)) then $n/CompoundPredicate/*[2]/@value else $n/CompoundPredicate/*[2]/Array/text() else () let $pcn := $n/ScoreDistribution[@value = $n/@score] let $pc := $pcn/@recordCount let $rtn := /PMML/TreeModel//Node[@id=0] let $trc := $rtn/@recordCount return <pred id=\"{$n/../@id}\" score=\"{$n/@score}\" rec=\"{$n/@recordCount}\" cid=\"{$n/@id}\" rf=\"{$rf}\" ro=\"{$ro}\" rv=\"{$rv}\" sf=\"{$sf}\" so=\"{$so}\" sv=\"{$sv}\" pc=\"{$pc}\" trc=\"{$trc}\" />'\n                      passing dbms_data_mining.get_model_details_xml('{$GET_MODEL_NAME}') COLUMNS parent_node_id NUMBER PATH '/pred/@id', child_node_id NUMBER PATH '/pred/@cid', rec NUMBER PATH '/pred/@rec', score VARCHAR2(4000) PATH '/pred/@score', rule_field VARCHAR2(4000) PATH '/pred/@rf', rule_op VARCHAR2(20) PATH '/pred/@ro', rule_value VARCHAR2(4000) PATH '/pred/@rv', surr_field VARCHAR2(4000) PATH '/pred/@sf', surr_op VARCHAR2(20) PATH '/pred/@so', surr_value VARCHAR2(4000) PATH '/pred/@sv', pred_count NUMBER PATH '/pred/@pc', total_rec_count NUMBER PATH '/pred/@trc')\n                    ) X\n                  )\n                )\n                CONNECT BY PRIOR child_node_id = parent_node_id\n              )\n            )\n          )\n        )\n        CONNECT BY PRIOR rn = rn - 1\n      AND PRIOR nid         = nid\n        START WITH rn       = 1\n      )\n    )\n  WHERE rn    = 1  {$LEAF_NODES_ONLY_QUERY} \n  ORDER BY node_id\n";
        return string;
    }

    @Override
    public String getVirtualTables() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\"{$NODE_SQL_NAME}.{$MODEL_POSITION}.1\" AS (\n  SELECT PARTITION_NAME, NODE, PARENT, LOCAL_RULE, LOCAL_SURROGATE \n  FROM\n  (SELECT PARTITION_NAME, NODE, PARENT, SPLIT_TYPE,\n  DECODE(OPERATOR,\n  'IN',\n  '(' || ATTRIBUTE_NAME || ' ' || LOWER(OPERATOR) || ' (' || \n  REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(\n  CAST(XMLQUERY('for $e in /Element order by $e return concat(''\"'', $e, ''\"'')' PASSING VALUE RETURNING CONTENT) AS VARCHAR2(4000)),\n  CHR(38) || 'quot;', '\"'),CHR(38) || 'apos;', ''''),CHR(38) || 'lt;', '<'),CHR(38) || 'gt;', '>'),CHR(38) || 'amp;', '&') || ' ))'\n  ,\n  '(' || ATTRIBUTE_NAME || ' ' || OPERATOR || ' ' ||\n  CAST(XMLQUERY('/Element[1]/text()' PASSING VALUE RETURNING CONTENT) AS VARCHAR2(4000)) || ')'\n  ) RULE \n  FROM {$MODEL_SCHEMA_VALUE}.DM$VP{$MODEL_NAME_VALUE})\nPIVOT(MIN(RULE) FOR SPLIT_TYPE IN ('Main' AS LOCAL_RULE, 'Surrogate' AS LOCAL_SURROGATE))),\n\n\"{$NODE_SQL_NAME}.{$MODEL_POSITION}.2\"(PARTITION_NAME, NODE, PARENT, LOCAL_RULE, LOCAL_SURROGATE, FULL_RULE) AS (\nSELECT PARTITION_NAME, NODE, PARENT, LOCAL_RULE, LOCAL_SURROGATE, LOCAL_RULE\nFROM \"{$NODE_SQL_NAME}.{$MODEL_POSITION}.1\" WHERE PARENT = 0\nUNION ALL\nSELECT R.PARTITION_NAME, R.NODE, R.PARENT, R.LOCAL_RULE, R.LOCAL_SURROGATE, \"{$NODE_SQL_NAME}.{$MODEL_POSITION}.2\".FULL_RULE || ' AND ' || R.LOCAL_RULE\nFROM \"{$NODE_SQL_NAME}.{$MODEL_POSITION}.1\" R INNER JOIN \"{$NODE_SQL_NAME}.{$MODEL_POSITION}.2\" ON R.PARENT = \"{$NODE_SQL_NAME}.{$MODEL_POSITION}.2\".NODE AND NVL(R.PARTITION_NAME, 0) = NVL(\"{$NODE_SQL_NAME}.{$MODEL_POSITION}.2\".PARTITION_NAME, 0)), \n" : super.getVirtualTables();
        return string;
    }

    @Override
    public String getUnionOrderBy() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            return "MODEL_NAME, PARTITION_NAME, NODE_ID";
        }
        return "";
    }

    @Override
    public String getSQLCommand() {
        String string = "";
        if (this.outputType.equals(ModelDetailType.DT_LEAF_NODES_ONLY)) {
            string = DbVersionHelper.isDB122Up(this.dbVersion) ? DT_LEAF_NODES_ONLY_QUERY_122 : DT_LEAF_NODES_ONLY_QUERY;
        }
        this._builder = new StringBuilder(StringUtils.getReplacedString(super.getSQLCommand(), StringUtils.formatReplacement("LEAF_NODES_ONLY_QUERY"), string));
        return this._builder.toString();
    }
}

