/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.control.AreaComponent;

public class RectangleComponent
extends AreaComponent {
    private final Rectangle rectangle;

    public RectangleComponent(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Override
    public double getHeight() {
        return this.rectangle.getHeight();
    }

    @Override
    public double getWidth() {
        return this.rectangle.getWidth();
    }

    @Override
    public void setHeight(double d) {
        this.rectangle.setHeight(d);
    }

    @Override
    public void setWidth(double d) {
        this.rectangle.setWidth(d);
    }

    public Rectangle getNode() {
        return this.rectangle;
    }

    @Override
    protected void doMove() {
        this.rectangle.setX(this.getX());
        this.rectangle.setY(this.getY());
    }

    @Override
    protected void doAnimate(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler) {
        this.addKeyFrame(timeline, duration, this.rectangle.xProperty(), this.getX());
        this.addKeyFrame(timeline, duration, eventHandler, this.rectangle.yProperty(), this.getY());
    }

    private double getX() {
        return this.getCenterX() - 0.5 * this.rectangle.getWidth();
    }

    private double getY() {
        return this.getCenterY() - 0.5 * this.rectangle.getHeight();
    }
}

