/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.ArithmeticDataObject;
import oracle.dbtools.raptor.metrics.panel.NumberDataObject;

@DefaultProperty(value="items")
public abstract class CollectionArithmeticDataObject
extends ArithmeticDataObject {
    private final ObservableList<NumberDataObject> items = FXCollections.observableArrayList();
    private BooleanExpression available;
    private BooleanExpression connected;

    public ObservableList<NumberDataObject> getItems() {
        return this.items;
    }

    @Override
    public BooleanExpression connectedProperty() {
        if (this.connected == null) {
            for (NumberDataObject numberDataObject : this.items) {
                if (this.connected == null) {
                    this.connected = numberDataObject.connectedProperty();
                    continue;
                }
                this.connected = Bindings.and((ObservableBooleanValue)this.connected, (ObservableBooleanValue)numberDataObject.connectedProperty());
            }
        }
        return this.connected;
    }

    @Override
    public BooleanExpression availableProperty() {
        if (this.available == null) {
            for (NumberDataObject numberDataObject : this.items) {
                if (this.available == null) {
                    this.available = numberDataObject.availableProperty();
                    continue;
                }
                this.available = Bindings.and((ObservableBooleanValue)this.available, (ObservableBooleanValue)numberDataObject.availableProperty());
            }
        }
        return this.available;
    }

    @Override
    protected List<ObservableValue<?>> getDependencies() {
        ArrayList arrayList = new ArrayList();
        for (NumberDataObject numberDataObject : this.items) {
            arrayList.add((ObservableValue<?>)numberDataObject.valueProperty());
        }
        return arrayList;
    }

    @Override
    protected Number calculateValue() {
        for (NumberDataObject numberDataObject : this.items) {
            Number number = (Number)numberDataObject.valueProperty().getValue();
            if (!(number instanceof Double)) continue;
            return this.calculateAsDoubles((List<NumberDataObject>)this.items);
        }
        return this.calculateAsLongs((List<NumberDataObject>)this.items);
    }

    protected abstract Number calculateAsDoubles(List<NumberDataObject> var1);

    protected abstract Number calculateAsLongs(List<NumberDataObject> var1);
}

