/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.raptor.metrics.engine.DXException;

public class DXIds {
    private static final String PARAMETER_SPLIT_CHAR = "&";
    private static final char PARAMETER_DELIMITER = '&';
    private static final char PARAMETER_VALUE_DELIMITER = '=';
    private static final char[] HEX_CHAR_AT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] INT_VALUE_OF_HEX = new int[128];

    public static URI newConnectionTypeId(String string) {
        return DXIds.newTypeId(string, "*");
    }

    public static URI newTypeId(String string, String string2) {
        return DXIds.newId(string, "*", string2);
    }

    public static URI newId(String string, String string2, String string3) {
        URI uRI = null;
        String string4 = DXIds.encodeValue(string2, false);
        String string5 = string3 != null ? "/" + DXIds.encodeValue(string3, true) : null;
        try {
            uRI = new URI(string, string4, string5, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DXException(uRISyntaxException);
        }
        return uRI;
    }

    public static URI newId(String string, String string2, String string3, Map<String, String> map, Map<String, String> map2) {
        String string4;
        URI uRI = null;
        Object object = DXIds.encodeValue(string2, false);
        String string5 = string4 = string3 != null ? "/" + DXIds.encodeValue(string3, true) : null;
        if (map != null && !map.isEmpty()) {
            object = (String)object + DXIds.buildParametersString(map);
        }
        if (map2 != null && !map2.isEmpty()) {
            string4 = string4 + DXIds.buildParametersString(map2);
        }
        try {
            uRI = new URI(string, (String)object, string4, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DXException(uRISyntaxException);
        }
        return uRI;
    }

    public static boolean isTypeId(URI uRI) {
        return DXIds.getConnectionName(uRI).equals("*");
    }

    public static URI getConnectionTypeId(URI uRI) {
        return DXIds.newConnectionTypeId(DXIds.getConnectionTypeName(uRI));
    }

    public static URI getTypeId(URI uRI) {
        return DXIds.newTypeId(DXIds.getConnectionTypeName(uRI), DXIds.getPath(uRI));
    }

    public static String getConnectionTypeName(URI uRI) {
        return uRI.getScheme();
    }

    public static String getConnectionName(URI uRI) {
        return DXIds.decodeValue(DXIds.getSubstringBeforeDelimiter(uRI.getAuthority()));
    }

    public static String getPath(URI uRI) {
        String string = uRI.getPath();
        return !"".equals(string) ? DXIds.decodeValue(DXIds.getSubstringBeforeDelimiter(string.substring(1))) : null;
    }

    public static String getConnectionParametersAsString(URI uRI) {
        return DXIds.getSubstringAfterDelimiter(uRI.getAuthority());
    }

    public static String getQueryParametersAsString(URI uRI) {
        return DXIds.getSubstringAfterDelimiter(uRI.getPath());
    }

    public static Map<String, String> getConnectionParameters(URI uRI) {
        Map<String, String> map = null;
        String string = DXIds.getConnectionParametersAsString(uRI);
        if (string != null) {
            map = DXIds.buildParametersMap(string);
        }
        return map;
    }

    public static Map<String, String> getQueryParameters(URI uRI) {
        Map<String, String> map = null;
        String string = DXIds.getQueryParametersAsString(uRI);
        if (string != null) {
            map = DXIds.buildParametersMap(string);
        }
        return map;
    }

    private static Map<String, String> buildParametersMap(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split(PARAMETER_SPLIT_CHAR)) {
            int n = string2.indexOf(61);
            String string3 = string2.substring(0, n);
            String string4 = DXIds.decodeValue(string2.substring(n + 1));
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private static String buildParametersString(Map<String, String> map) {
        TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            stringBuilder.append('&');
            stringBuilder.append(DXIds.encodeValue(string, false));
            stringBuilder.append('=');
            stringBuilder.append(DXIds.encodeValue(map.get(string), false));
        }
        return stringBuilder.toString();
    }

    private static String getSubstringBeforeDelimiter(String string) {
        int n = string.indexOf(38);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String getSubstringAfterDelimiter(String string) {
        int n = string.indexOf(38);
        if (n >= 0) {
            String string2 = string.substring(n + 1);
            return string2.isEmpty() ? null : string2;
        }
        return null;
    }

    private static String encodeValue(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isLetterOrDigit(c) || DXIds.isUnreservedPunctuation(c, bl)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(DXIds.encodeChar(c));
            }
        }
        return stringBuilder.toString();
    }

    private static String decodeValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length() - 2) {
            char c = string.charAt(n);
            if (c == '%') {
                stringBuilder.append(DXIds.decodeChar(string.charAt(n + 1), string.charAt(n + 2)));
                n += 3;
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    private static boolean isUnreservedPunctuation(char c, boolean bl) {
        return bl && c == '/' || c == '*' || c == '_' || c == '-' || c == '.' || c == '\'' || c == '(' || c == ')' || c == '!' || c == '~';
    }

    private static String encodeChar(char c) {
        int n = (c & 0xF0) >>> 4;
        int n2 = c & 0xF;
        return new String(new char[]{'%', HEX_CHAR_AT[n], HEX_CHAR_AT[n2]});
    }

    private static char decodeChar(char c, char c2) {
        int n = INT_VALUE_OF_HEX[c];
        int n2 = INT_VALUE_OF_HEX[c2];
        int n3 = n * 16 + n2;
        return (char)n3;
    }

    private DXIds() {
    }

    static {
        for (int i = 0; i < 16; ++i) {
            DXIds.INT_VALUE_OF_HEX[DXIds.HEX_CHAR_AT[i]] = i;
        }
    }
}

