/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.generation;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import oracle.dbtools.raptor.metrics.generation.AbstractGenerationElement;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.Formatter;
import oracle.dbtools.raptor.metrics.panel.GenerationResult;

@DefaultProperty(value="value")
public class Text
extends AbstractGenerationElement {
    private final StringProperty valueProperty = new SimpleStringProperty();

    public String getValue() {
        return (String)this.valueProperty.get();
    }

    public void setValue(String string) {
        this.valueProperty.set((Object)string);
    }

    public StringProperty valueProperty() {
        return this.valueProperty;
    }

    @Override
    boolean isSynchronous() {
        return true;
    }

    @Override
    void generate(Consumer<GenerationResult> consumer) {
        String string = this.getValue();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            int n2 = 0;
            block6: while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '$': {
                        int n3;
                        int n4 = ++n2;
                        while (n2 < n && (n3 = (int)string.charAt(n2)) != 36) {
                            if (n3 == 92) {
                                ++n2;
                            }
                            ++n2;
                        }
                        if (n2 < n) {
                            String string2 = string.substring(n4, n2);
                            String string3 = this.evaluateParam(string2);
                            stringBuilder.append(string3);
                        }
                        ++n2;
                        continue block6;
                    }
                    case '\\': {
                        int n3 = n2 + 1;
                        if (n3 < n) {
                            char c2 = string.charAt(n3);
                            char c3 = this.decodeLiteral(c2);
                            stringBuilder.append(c3);
                            n2 = n3;
                        }
                        ++n2;
                        continue block6;
                    }
                }
                stringBuilder.append(c);
                ++n2;
            }
            consumer.accept(new GenerationResult(true, stringBuilder.toString()));
        }
        catch (Exception exception) {
            Logger.getLogger(Text.class.getName()).log(Level.WARNING, "error generating '" + string + "'", exception);
            consumer.accept(new GenerationResult(false, "generation error"));
        }
    }

    private String evaluateParam(String string) {
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 0;
        block4: while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ':': {
                    string2 = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    ++n2;
                    continue block4;
                }
                case '\\': {
                    int n3 = n2 + 1;
                    if (n3 < n) {
                        stringBuilder.append(string.charAt(n3));
                        n2 = n3;
                    }
                    ++n2;
                    continue block4;
                }
            }
            stringBuilder.append(c);
            ++n2;
        }
        String string3 = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        Object object = this.getResolvedParameterValue(string3);
        if (object != null) {
            if (string2 != null) {
                stringBuilder2.append(Formatter.format(string2, object));
            } else {
                stringBuilder2.append(object.toString());
            }
        } else {
            stringBuilder2.append("?").append(string3).append("?");
        }
        return this.getGenerationSettings().processEscapes(stringBuilder2.toString());
    }

    private char decodeLiteral(char c) {
        char c2;
        switch (c) {
            case 'n': {
                c2 = '\n';
                break;
            }
            case 't': {
                c2 = '\t';
                break;
            }
            default: {
                c2 = c;
            }
        }
        return c2;
    }

    private Object getResolvedParameterValue(String string) {
        DataObject dataObject;
        ObservableValue observableValue;
        Object object = null;
        Object object2 = this.getGenerationParameterValue(string);
        if (object2 instanceof ObservableValue) {
            ObservableValue observableValue2 = (ObservableValue)object2;
            object = observableValue2.getValue();
        } else if (object2 instanceof DataObject && (observableValue = (dataObject = (DataObject)object2).valueProperty()) != null) {
            object = observableValue.getValue();
        }
        if (object == null) {
            object = object2;
        }
        return object;
    }
}

