/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.translation.api.components;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.internalapi.IFoldingBlock;
import org.antlr.stringtemplate.StringTemplate;

public class Block
implements IFoldingBlock {
    private HashMap<String, Object> _properties = new HashMap();
    public static final String GRAMMARROOTBLOCK = "GRAMMARROOTBLOCK";
    public static final String CREATEOBJBLOCK = "CREATEOBJBLOCK";
    public static final String BEGINBLOCK = "BEGINBLOCK";
    public static final String CONTROLBLOCK = "CONTROLBLOCK";
    public static final String STMTBLOCK = "STMTBLOCK";
    public static final String CLAUSEBLOCK = "CLAUSEBLOCK";
    public static final String OPERATIONBLOCK = "OPERATIONBLOCK";
    public static final String TRYBLOCK = "TRYBLOCK";
    public static final String EXCEPTIONBLOCK = "EXCEPTIONBLOCK";
    public static final String ERRORBLOCK = "ERRORBLOCK";
    public static final String PARAMBLOCK = "PARAMBLOCK";
    public static final String EXPRBLOCK = "EXPRBLOCK";
    public static final String CONTEXTBLOCK = "CONTEXTBLOCK";
    public static final String SUBCLAUSEBLOCK = "SUBCLAUSEBLOCK";
    public static final String ALIASLIST = "ALIASLIST";
    public static final String NAMELIST = "NAMELIST";
    private int m_startIndex = 0;
    private int m_endIndex = 0;
    private String m_labelName;
    private ArrayList<Block> m_children = new ArrayList();
    private ArrayList<Block> m_altBlocks = new ArrayList();
    private String m_blockType = null;
    private Block m_parent = null;
    private String m_blockName;
    private AST astNode;
    private int m_SourceStartLine = -1;
    private int m_SourceEndLine = -1;
    private int m_TargetStartLine = -1;
    private int m_TargetEndLine = -1;

    @Override
    public int getEndIndex() {
        return this.m_endIndex;
    }

    public void setEndIndex(int n) {
        this.m_endIndex = n;
    }

    @Override
    public int getStartIndex() {
        return this.m_startIndex;
    }

    public void setStartIndex(int n) {
        this.m_startIndex = n;
    }

    public ArrayList<Block> getAltBlocks() {
        return this.m_altBlocks;
    }

    public boolean hasAltBlock() {
        return this.m_altBlocks.size() > 0;
    }

    public void setAltBlocks(ArrayList<Block> arrayList) {
        this.m_altBlocks = arrayList;
    }

    @Override
    public String getBlockType() {
        return this.m_blockType;
    }

    public void setBlockType(String string) {
        this.m_blockType = string;
    }

    public void setChildren(ArrayList<Block> arrayList) {
        this.m_children = arrayList;
    }

    public ArrayList<IFoldingBlock> getFoldingBlocks() {
        ArrayList<IFoldingBlock> arrayList = new ArrayList<IFoldingBlock>();
        ArrayList<Block> arrayList2 = this.getBlockList();
        for (Block block : arrayList2) {
            if (!block.getBlockType().equals(CREATEOBJBLOCK) && !block.getBlockType().equals(BEGINBLOCK) && !block.getBlockType().equals(STMTBLOCK)) continue;
            arrayList.add(block);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this);
        }
        return arrayList;
    }

    public ArrayList<Block> getBlockList() {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        ArrayList<Block> arrayList2 = this.getChildren();
        ArrayList<Block> arrayList3 = null;
        if (arrayList2 != null) {
            for (Block block : arrayList2) {
                arrayList3 = block.getBlockList();
                arrayList.addAll(arrayList3);
            }
        }
        arrayList.add(this);
        return arrayList;
    }

    public ArrayList<Block> getSiblings() {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (Block block : this.m_parent.getChildren()) {
            if (block.equals(this)) continue;
            arrayList.add(block);
        }
        return arrayList;
    }

    public void addChild(Block block) {
        this.m_children.add(block);
        block.setParent(this);
    }

    public void addAlt(Block block) {
        this.m_altBlocks.add(block);
    }

    public void add(Block block) {
        this.m_children.add(block);
    }

    public void setParent(Block block) {
        this.m_parent = block;
    }

    public Block getParent() {
        return this.m_parent;
    }

    public ArrayList<Block> getChildren() {
        return this.m_children;
    }

    public boolean hasChildren() {
        return this.m_children.size() > 0;
    }

    public boolean hasChildBlock(String string) {
        for (Block block : this.m_children) {
            if (block == null || !string.equalsIgnoreCase(block.getBlockType())) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildBlock(String string, String string2) {
        for (Block block : this.m_children) {
            if (block == null || !string.equalsIgnoreCase(block.getBlockType()) || !string2.equalsIgnoreCase(block.getBlockName())) continue;
            return true;
        }
        return false;
    }

    public Block getDescendentBlock(String string, String string2) {
        return this.getDescendentBlock(this, string, string2);
    }

    public boolean hasDescendentBlock(String string) {
        return this.getDescendentBlock(this, string, null) != null;
    }

    public boolean hasDescendentBlock(String string, String string2) {
        return this.getDescendentBlock(this, string, string2) != null;
    }

    private Block getDescendentBlock(Block block, String string, String string2) {
        Block block2 = null;
        for (Block block3 : block.getChildren()) {
            if (block3 != null && string.equalsIgnoreCase(block3.getBlockType()) && string2 != null && string2.equalsIgnoreCase(block3.getBlockName())) {
                block2 = block3;
                break;
            }
            block2 = this.getDescendentBlock(block3, string, string2);
            if (block2 == null) continue;
            break;
        }
        return block2;
    }

    public List<Block> getAllDescendentBlock(String string) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        this.getAllDescendentBlock(this, string, null, arrayList);
        return arrayList;
    }

    public List<Block> getAllDescendentBlock(String string, String string2) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        this.getAllDescendentBlock(this, string, string2, arrayList);
        return arrayList;
    }

    private void getAllDescendentBlock(Block block, String string, String string2, List<Block> list) {
        for (Block block2 : block.getChildren()) {
            if (block2.getBlockType().equals(string) && (string2 == null || string2 != null && block2.getBlockName() != null && block2.getBlockName().equals(string2))) {
                list.add(block2);
            }
            this.getAllDescendentBlock(block2, string, string2, list);
        }
    }

    public ArrayList<Block> getChildrenBlock(String string, String string2) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (Block block : this.m_children) {
            if (block == null || !string.equalsIgnoreCase(block.getBlockType()) || !string2.equalsIgnoreCase(block.getBlockName())) continue;
            arrayList.add(block);
        }
        return arrayList;
    }

    public Block getChildBlock(String string, int n) {
        Block block = null;
        int n2 = 1;
        for (Block block2 : this.m_children) {
            if (block2 != null && n2 == n && string.equalsIgnoreCase(block2.getBlockType())) {
                block = block2;
                break;
            }
            ++n2;
        }
        return block;
    }

    public void setIndexes(int n, int n2) {
        this.m_startIndex = n;
        this.m_endIndex = n2;
    }

    public void setBlockName(String string) {
        this.m_blockName = string;
    }

    public String getBlockName() {
        return this.m_blockName;
    }

    public AST getAST() {
        return this.astNode;
    }

    public void setAST(AST aST) {
        this.astNode = aST;
    }

    public Block getTopAncestor() {
        Block block = this;
        while (block.getParent().m_blockType != GRAMMARROOTBLOCK) {
            block = block.getParent();
        }
        return block;
    }

    public boolean hasProgramChildBlock() {
        for (Block block : this.m_children) {
            if (!block.getBlockType().equals(CREATEOBJBLOCK)) continue;
            return true;
        }
        return false;
    }

    public Block getEnclosingProgramBlock() {
        Block block = null;
        for (Block block2 = this.m_parent; block2 != null; block2 = block2.getParent()) {
            String string = block2.getBlockType();
            if (!string.equals(BEGINBLOCK) && !string.equals(CREATEOBJBLOCK) && !string.equals(CONTEXTBLOCK)) continue;
            block = block2;
            break;
        }
        return block;
    }

    public Block getOutermostBeginBlock() {
        Block block = null;
        for (Block block2 = this.m_parent; block2 != null; block2 = block2.getParent()) {
            String string = block2.getBlockType();
            if (!string.equals(BEGINBLOCK)) continue;
            block = block2;
        }
        return block;
    }

    public Block getOutermostProgramBlock() {
        Block block = null;
        for (Block block2 = this.m_parent; block2 != null; block2 = block2.getParent()) {
            String string = block2.getBlockType();
            if (!string.equals(BEGINBLOCK) && !string.equals(CREATEOBJBLOCK) && !string.equals(CONTEXTBLOCK)) continue;
            block = block2;
        }
        return block;
    }

    public boolean isDescendentOf(Block block) {
        for (Block block2 = this.getParent(); block2 != null; block2 = block2.getParent()) {
            if (!block2.equals(block)) continue;
            return true;
        }
        return false;
    }

    public Block getEnclosingBlockByName(String string) {
        Block block = null;
        for (Block block2 = this.m_parent; block2 != null; block2 = block2.getParent()) {
            String string2 = block2.getBlockName();
            if (!string.equalsIgnoreCase(string2)) continue;
            block = block2;
            break;
        }
        return block;
    }

    public Block getEnclosingBlockByType(String string) {
        Block block = null;
        for (Block block2 = this.m_parent; block2 != null; block2 = block2.getParent()) {
            String string2 = block2.getBlockType();
            if (!string.equalsIgnoreCase(string2)) continue;
            block = block2;
            break;
        }
        return block;
    }

    public Block getEnclosingBlock(String string, String string2) {
        Block block = null;
        for (Block block2 = this.m_parent; block2 != null; block2 = block2.getParent()) {
            String string3 = block2.getBlockName();
            if (!string.equalsIgnoreCase(string) || !string2.equalsIgnoreCase(string3)) continue;
            block = block2;
            break;
        }
        return block;
    }

    public int getSourceStartLine() {
        if (this.m_SourceStartLine == -1 && this.astNode != null) {
            this.m_SourceStartLine = this.astNode.getSourceStartLine();
        }
        return this.m_SourceStartLine == -1 ? 0 : this.m_SourceStartLine;
    }

    public void setSourceStartLine(int n) {
        this.m_SourceStartLine = n;
    }

    public int getSourceEndLine() {
        if (this.m_SourceEndLine == -1 && this.astNode != null) {
            this.m_SourceEndLine = this.astNode.getSourceEndLine();
        }
        return this.m_SourceEndLine == -1 ? 100000 : this.m_SourceEndLine;
    }

    public void setSourceEndLine(int n) {
        this.m_SourceEndLine = n;
    }

    public void setTargetStartLine(int n) {
        this.m_TargetStartLine = n;
    }

    public int getTargetStartLine() {
        if (this.astNode != null && this.astNode.getSt() != null) {
            this.m_TargetStartLine = this.astNode.getSt().getStartLine();
        }
        return this.m_TargetStartLine == -1 ? 0 : this.m_TargetStartLine;
    }

    public int getTargetEndLine() {
        if (this.astNode != null) {
            StringTemplate[] stringTemplateArray = ((ExtAST)this.astNode).getAllStringTemplates();
            if (stringTemplateArray.length > 1) {
                this.m_TargetEndLine = stringTemplateArray[stringTemplateArray.length - 1].getEndLine();
            } else if (this.astNode.getSt() != null) {
                this.m_TargetEndLine = this.astNode.getSt().getEndLine();
            }
        }
        return this.m_TargetEndLine == -1 ? 0 : this.m_TargetEndLine;
    }

    public void setTargetEndLine(int n) {
        this.m_TargetEndLine = n;
    }

    public void setLabelName(String string) {
        this.m_labelName = string;
    }

    public String getLabelName() {
        return this.m_labelName;
    }

    public String generateLabel() {
        Object object = "";
        String string = "loop_";
        int n = 1;
        for (Block block = this.m_parent; block != null; block = block.getParent()) {
            String string2 = block.getLabelName();
            if (string2 == null || !string2.startsWith(string)) continue;
            try {
                n = Integer.parseInt(string2.substring(string2.indexOf(string) + 1));
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = false;
        while (true) {
            Block block;
            object = string + n;
            Iterator<Block> iterator = this.m_children.iterator();
            while (iterator.hasNext() && !(bl = this.hasConflictChildLabel(block = iterator.next(), (String)object))) {
            }
            if (!bl) break;
            ++n;
        }
        this.m_labelName = object;
        return object;
    }

    private boolean hasConflictChildLabel(Block block, String string) {
        Block block2;
        boolean bl = false;
        if (block.getLabelName() != null && string.equalsIgnoreCase(block.getLabelName())) {
            return true;
        }
        Iterator<Block> iterator = block.getChildren().iterator();
        while (iterator.hasNext() && !(bl = this.hasConflictChildLabel(block2 = iterator.next(), string))) {
        }
        return bl;
    }

    public Block getLastSiblingBlock(String string, String[] stringArray) {
        Block block = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        Block block2 = this;
        block1: do {
            int n = block2.getParent().getChildren().indexOf(block2);
            block2 = block2.getParent();
            for (int i = n - 1; i >= 0; --i) {
                Block block3 = block2.getChildren().get(i);
                if (!block3.getBlockType().equalsIgnoreCase(string) || !arrayList.contains(block3.getBlockName())) continue;
                block = block3;
                continue block1;
            }
        } while (block == null && block2.getParent() != null);
        return block;
    }

    public Object getProperty(String string) {
        return this._properties.get(string);
    }

    public void putProperties(String string, Object object) {
        this._properties.put(string, object);
    }
}

