/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.concurrent;

import java.net.URL;

public abstract class IntentionLock {
    private IntentionLock() {
    }

    public static IntentionLock newIntentionReadLock(URL resource) {
        return new IS(resource);
    }

    public static IntentionLock newIntentionWriteLock(URL resource) {
        return new IX(resource);
    }

    public static IntentionLock newIntentionCompositeLock(IntentionLock[] locks) {
        return new Group(locks);
    }

    public abstract boolean includes(IntentionLock var1);

    public abstract boolean isCompatible(IntentionLock var1);

    private static final class Group
    extends IntentionLock {
        private final IntentionLock[] _locks;

        private Group(IntentionLock[] locks) {
            this._locks = locks;
        }

        private IntentionLock[] getLocks() {
            return this._locks;
        }

        @Override
        public boolean includes(IntentionLock otherLock) {
            if (otherLock != null && this._locks != null) {
                Group otherGroup;
                IntentionLock[] otherLocks;
                Class<?> otherClass = otherLock.getClass();
                if (otherClass == IS.class || otherClass == IX.class) {
                    int n = this._locks.length;
                    for (int i = 0; i < n; ++i) {
                        if (!this._locks[i].includes(otherLock)) continue;
                        return true;
                    }
                } else if (otherClass == Group.class && (otherLocks = (otherGroup = (Group)otherLock).getLocks()) != null) {
                    int n = otherLocks.length;
                    for (int i = 0; i < n; ++i) {
                        if (this.includes(otherLocks[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isCompatible(IntentionLock otherLock) {
            if (otherLock != null && this._locks != null) {
                int n = this._locks.length;
                for (int i = 0; i < n; ++i) {
                    if (otherLock.isCompatible(this._locks[i])) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static final class IX
    extends IntentionLock {
        private URL _resource;

        private IX(URL resource) {
            this._resource = resource;
        }

        @Override
        public boolean includes(IntentionLock otherLock) {
            if (otherLock != null) {
                Class<?> otherClass = otherLock.getClass();
                URL resource = null;
                if (otherClass == IS.class) {
                    resource = ((IS)otherLock)._resource;
                } else if (otherClass == IX.class) {
                    resource = ((IX)otherLock)._resource;
                }
                return this._resource.equals(resource);
            }
            return false;
        }

        @Override
        public boolean isCompatible(IntentionLock otherLock) {
            if (otherLock != null) {
                Group otherGroup;
                IntentionLock[] locks;
                Class<?> otherClass = otherLock.getClass();
                if (otherClass == IS.class) {
                    IS otherIS = (IS)otherLock;
                    return !otherIS._resource.equals(this._resource);
                }
                if (otherClass == IX.class) {
                    IX otherIX = (IX)otherLock;
                    return !otherIX._resource.equals(this._resource);
                }
                if (otherClass == Group.class && (locks = (otherGroup = (Group)otherLock).getLocks()) != null) {
                    int n = locks.length;
                    for (int i = 0; i < n; ++i) {
                        if (this.isCompatible(locks[i])) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private static final class IS
    extends IntentionLock {
        private URL _resource;

        private IS(URL resource) {
            this._resource = resource;
        }

        @Override
        public boolean includes(IntentionLock otherLock) {
            if (otherLock != null && otherLock.getClass() == IS.class) {
                IS otherIS = (IS)otherLock;
                if (otherIS._resource.equals(this._resource)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isCompatible(IntentionLock otherLock) {
            if (otherLock != null) {
                Group otherGroup;
                IntentionLock[] locks;
                Class<?> otherClass = otherLock.getClass();
                if (otherClass == IS.class) {
                    return true;
                }
                if (otherClass == IX.class) {
                    IX otherIX = (IX)otherLock;
                    return !otherIX._resource.equals(this._resource);
                }
                if (otherClass == Group.class && (locks = (otherGroup = (Group)otherLock).getLocks()) != null) {
                    int n = locks.length;
                    for (int i = 0; i < n; ++i) {
                        if (this.isCompatible(locks[i])) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

