/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.GuardedException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.util.Log;

public class BasicDocument
implements Document,
TextBufferListener,
PropertyChangeListener {
    private Element[] rootElements;
    private TextBuffer textBuffer;
    private Map<Object, Object> properties;
    private CopyOnWriteArrayList<DocumentListener> docListenerList;
    private CopyOnWriteArrayList<UndoableEditListener> undoListenerList;
    private LanguageSupport support;
    private DocumentRenderer renderer;
    private WeakPropertyChangeSupport changeSupport;
    private OffsetMark startComposedMark;
    private OffsetMark endComposedMark;
    private NumberRange composedRange;
    private boolean isComposedTextInput;
    private boolean compoundEditInProgress;
    private static final String REUSE_UNDOABLE_EDIT = "reuse-undoable-edit";
    private UndoEvent freeUndoEvent;
    private boolean reuseUndoEvent;
    public static final String readOnlyPropertyName = "read-only-mode";
    public static final String eolTypePropertyName = "eol-type";
    private static final Log LOG = new Log("compound-edit");
    private CopyOnWriteArrayList<PrePostDocumentListener> prePostListenerList;

    public BasicDocument() {
        this((TextBuffer)null);
    }

    public BasicDocument(String fileName) {
        this(fileName, null);
    }

    public BasicDocument(String fileName, TextBuffer buffer) {
        this(buffer);
        this.setLanguageSupport(fileName);
    }

    public BasicDocument(TextBuffer buffer) {
        if (buffer == null) {
            buffer = TextBufferFactory.createTextBuffer();
        }
        this.textBuffer = buffer;
        this.textBuffer.addTextBufferListener((TextBufferListener)this);
        this.rootElements = new Element[]{new RootElement()};
        this.properties = new HashMap<Object, Object>(5);
        this.docListenerList = new CopyOnWriteArrayList();
        this.prePostListenerList = new CopyOnWriteArrayList();
        this.undoListenerList = new CopyOnWriteArrayList();
        this.isComposedTextInput = false;
        EditorProperties properties = EditorProperties.getProperties();
        properties.addPropertyChangeListener(this);
        this.changeSupport = new WeakPropertyChangeSupport(this);
        Object value = this.getProperty(REUSE_UNDOABLE_EDIT);
        this.reuseUndoEvent = value == null || value.equals(Boolean.TRUE);
        this.setLanguageSupport(LanguageModule.createDefaultSupport());
    }

    protected NumberRange getComposedTextRange() {
        if (this.startComposedMark == null) {
            return null;
        }
        int start = this.startComposedMark.getOffset();
        int end = this.endComposedMark.getOffset();
        if (this.composedRange == null) {
            this.composedRange = new NumberRange(start, end);
            return this.composedRange;
        }
        this.composedRange.start = start;
        this.composedRange.end = end;
        return this.composedRange;
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    public void setLanguageSupport(String fileName) {
        LanguageSupport support = LanguageModule.createSupportForFileType(fileName);
        this.setLanguageSupport(support);
    }

    public void setLanguageSupport(LanguageSupport support) {
        LanguageSupport oldSupport = this.support;
        if (oldSupport != null) {
            oldSupport.deinstall();
        }
        this.renderer = null;
        this.support = support;
        this.support.install(this);
        this.firePropertyChange("language-support", oldSupport, support);
    }

    public LanguageSupport getLanguageSupport() {
        return this.support;
    }

    public DocumentRenderer getDocumentRenderer() {
        if (this.renderer == null) {
            this.renderer = this.getLanguageSupport().getDocumentRenderer();
        }
        return this.renderer;
    }

    public void beginEdit() {
        this.textBuffer.beginEdit();
    }

    public void endEdit() {
        UndoableEdit edit = this.textBuffer.endEdit();
        this.fireUndoableEditEvent(edit);
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEditInProgress;
    }

    public void readLock() {
        this.textBuffer.readLock();
    }

    public void readUnlock() {
        this.textBuffer.readUnlock();
    }

    public void writeLock() {
        this.textBuffer.writeLock();
    }

    public void writeLock(boolean checkIfReadOnly) {
        this.textBuffer.writeLock(checkIfReadOnly);
    }

    public void writeUnlock() {
        this.textBuffer.writeUnlock();
    }

    public int getLineCount() {
        int lineCount;
        this.readLock();
        try {
            lineCount = this.getLineMap().getLineCount();
        }
        finally {
            this.readUnlock();
        }
        return lineCount;
    }

    public int getLineFromOffset(int offset) {
        int line;
        this.readLock();
        try {
            line = this.getLineMap().getLineFromOffset(offset);
        }
        finally {
            this.readUnlock();
        }
        return line;
    }

    public int getLineStartOffset(int line) {
        int startOffset;
        this.readLock();
        try {
            startOffset = this.getLineMap().getLineStartOffset(line);
        }
        finally {
            this.readUnlock();
        }
        return startOffset;
    }

    public int getLineEndOffset(int line) {
        int endOffset;
        this.readLock();
        try {
            endOffset = this.getLineMap().getLineEndOffset(line);
        }
        finally {
            this.readUnlock();
        }
        return endOffset;
    }

    public Element getParagraphElement(int pos) {
        return this.rootElements[0];
    }

    @Override
    public Element getDefaultRootElement() {
        return this.rootElements[0];
    }

    public LineMap getLineMap() {
        return this.textBuffer.getLineMap();
    }

    @Override
    public int getLength() {
        return this.textBuffer.getLength();
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        try {
            UndoableEdit edit = this.textBuffer.remove(offset, length);
            this.fireUndoableEditEvent(edit);
        }
        catch (GuardedException guardedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offset, String str, AttributeSet set) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        UndoableEdit edit = null;
        this.textBuffer.writeLock();
        try {
            if (set != null && set.isDefined(StyleConstants.ComposedTextAttribute)) {
                this.isComposedTextInput = true;
            }
            edit = this.textBuffer.insert(offset, str.toCharArray());
        }
        catch (GuardedException guardedException) {
        }
        finally {
            this.textBuffer.writeUnlock();
        }
        if (edit != null) {
            this.fireUndoableEditEvent(edit);
        }
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        try {
            return this.textBuffer.getString(offset, length);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new BadLocationException("Index out of bounds", offset + length - 1);
        }
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        try {
            this.textBuffer.getText(offset, length, txt);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new BadLocationException("Index out of bounds", offset + length - 1);
        }
    }

    @Override
    public Position getStartPosition() {
        return new BoundaryPosition(1);
    }

    @Override
    public Position getEndPosition() {
        return new BoundaryPosition(2);
    }

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        return new StickyPosition(this.textBuffer, offset);
    }

    @Override
    public Element[] getRootElements() {
        return this.rootElements;
    }

    @Override
    public void render(Runnable r) {
        this.readLock();
        try {
            r.run();
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.docListenerList.add(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.docListenerList.remove(listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoListenerList.add(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoListenerList.remove(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.changeSupport.firePropertyChange(event);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Object getProperty(Object key) {
        Object value = this.properties.get(key);
        if (value == null && key != null && key instanceof String) {
            String keyString = key.toString();
            LanguageSupport support = this.getLanguageSupport();
            if (support != null) {
                value = support.getProperty(keyString);
            }
            if (value == null) {
                value = EditorProperties.getProperties().getProperty(keyString);
            }
        }
        return value;
    }

    @Override
    public void putProperty(Object key, Object value) {
        Object oldValue = this.properties.put(key, value);
        if (key instanceof String) {
            this.firePropertyChange((String)key, oldValue, value);
        }
    }

    protected void fireUndoableEditEvent(UndoableEdit edit) {
        if (!this.undoListenerList.isEmpty() && edit != null && edit.canUndo()) {
            UndoableEditEvent event = this.allocUndoEvent(edit);
            for (UndoableEditListener listener : this.undoListenerList) {
                listener.undoableEditHappened(event);
            }
            this.freeUndoEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndoableEditEvent allocUndoEvent(UndoableEdit edit) {
        if (this.reuseUndoEvent) {
            UndoEvent undoEvent;
            BasicDocument basicDocument = this;
            synchronized (basicDocument) {
                undoEvent = this.freeUndoEvent;
                this.freeUndoEvent = null;
            }
            if (undoEvent == null) {
                undoEvent = new UndoEvent();
            }
            undoEvent.setEdit(edit);
            return undoEvent;
        }
        return new UndoableEditEvent(this, edit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeUndoEvent(UndoableEditEvent undoEvent) {
        if (this.reuseUndoEvent && undoEvent instanceof UndoEvent) {
            BasicDocument basicDocument = this;
            synchronized (basicDocument) {
                this.freeUndoEvent = (UndoEvent)undoEvent;
                this.freeUndoEvent.clear();
            }
        }
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        if (this.isComposedTextInput) {
            this.isComposedTextInput = false;
            this.startComposedMark = this.textBuffer.addOffsetMark(offset);
            this.endComposedMark = this.textBuffer.addOffsetMark(offset + count);
        }
        if (!this.docListenerList.isEmpty() || !this.prePostListenerList.isEmpty() || this.renderer != null) {
            DocEvent event = new DocEvent(offset, count, insertedData, true);
            this.fireEvent(event);
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        int end;
        int start;
        if (this.isComposedTextInput) {
            throw new IllegalStateException("composed text input in remove");
        }
        if (this.startComposedMark != null && (start = this.startComposedMark.getOffset()) == (end = this.endComposedMark.getOffset())) {
            this.textBuffer.removeOffsetMark(this.startComposedMark);
            this.textBuffer.removeOffsetMark(this.endComposedMark);
            this.startComposedMark = null;
            this.endComposedMark = null;
        }
        if (!this.docListenerList.isEmpty() || !this.prePostListenerList.isEmpty() || this.renderer != null) {
            DocEvent event = new DocEvent(offset, count, removedData, false);
            this.fireEvent(event);
        }
    }

    private void fireEvent(DocEvent event) {
        if (this.renderer != null) {
            try {
                this.renderer.notifyUpdate(event);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        for (PrePostDocumentListener prePostDocumentListener : this.prePostListenerList) {
            try {
                prePostDocumentListener.preNotify(event);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        for (DocumentListener documentListener : this.docListenerList) {
            try {
                if (event.isInsert) {
                    documentListener.insertUpdate(event);
                    continue;
                }
                documentListener.removeUpdate(event);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        for (PrePostDocumentListener prePostDocumentListener : this.prePostListenerList) {
            try {
                prePostDocumentListener.postNotify(event);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        switch (attribute) {
            case 1: {
                String eolType = this.textBuffer.getEOLType();
                this.firePropertyChange(eolTypePropertyName, null, eolType);
                break;
            }
            case 2: {
                Boolean readOnlyMode = this.textBuffer.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
                this.firePropertyChange(readOnlyPropertyName, null, readOnlyMode);
                break;
            }
            case 6: {
                LOG.trace("text buffer compound edit begun");
                assert (!this.compoundEditInProgress);
                this.compoundEditInProgress = true;
                this.fireCompoundEditEvent(true);
                break;
            }
            case 7: {
                LOG.trace("text buffer compound edit end");
                assert (this.compoundEditInProgress);
                this.compoundEditInProgress = false;
                this.fireCompoundEditEvent(false);
                break;
            }
        }
    }

    public void addPrePostDocumentListener(PrePostDocumentListener listener) {
        this.prePostListenerList.add(listener);
    }

    public void removePrePostDocumentListener(PrePostDocumentListener listener) {
        this.prePostListenerList.remove(listener);
    }

    private void fireCompoundEditEvent(boolean compoundEditInProgress) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "compoundEditInProgress", !compoundEditInProgress, compoundEditInProgress);
        for (PrePostDocumentListener listener : this.prePostListenerList) {
            try {
                listener.preNotify(event);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.changeSupport.firePropertyChange(event);
        for (PrePostDocumentListener listener : this.prePostListenerList) {
            try {
                listener.postNotify(event);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public static interface PrePostDocumentListener
    extends EventListener {
        public void preNotify(DocumentEvent var1);

        public void postNotify(DocumentEvent var1);

        public void preNotify(PropertyChangeEvent var1);

        public void postNotify(PropertyChangeEvent var1);
    }

    private static final class StickyPosition
    implements Position {
        private OffsetMark offsetMark;
        private TextBuffer textBuffer;

        private StickyPosition(TextBuffer buffer, int offset) {
            this.textBuffer = buffer;
            this.offsetMark = buffer.addOffsetMark(offset);
        }

        @Override
        public int getOffset() {
            return this.offsetMark.getOffset();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.textBuffer.removeOffsetMark(this.offsetMark);
            this.offsetMark = null;
            this.textBuffer = null;
        }
    }

    private final class RootElement
    implements Element {
        private RootElement() {
        }

        @Override
        public Document getDocument() {
            return BasicDocument.this;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public String getName() {
            return "BD.RootElement";
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return BasicDocument.this.getLength();
        }

        @Override
        public int getElementIndex(int offset) {
            return -1;
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public Element getElement(int index) {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    private final class BoundaryPosition
    implements Position {
        private static final int START = 1;
        private static final int END = 2;
        private int position;

        private BoundaryPosition(int position) {
            this.position = position;
        }

        @Override
        public int getOffset() {
            return this.position == 1 ? 0 : BasicDocument.this.textBuffer.getLength();
        }
    }

    private final class DocEvent
    implements BasicDocumentEvent {
        private int offset;
        private int length;
        private char[] data;
        private boolean isInsert;

        private DocEvent(int offset, int length, char[] data, boolean isInsert) {
            this.setValues(offset, length, data, isInsert);
        }

        private void setValues(int offset, int length, char[] data, boolean isInsert) {
            this.offset = offset;
            this.length = length;
            this.data = data;
            this.isInsert = isInsert;
        }

        private void clear() {
            this.offset = 0;
            this.length = 0;
            this.data = null;
            this.isInsert = true;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public Document getDocument() {
            return BasicDocument.this;
        }

        @Override
        public DocumentEvent.EventType getType() {
            return this.isInsert ? DocumentEvent.EventType.INSERT : DocumentEvent.EventType.REMOVE;
        }

        @Override
        public char[] getData() {
            return this.data;
        }

        @Override
        public DocumentEvent.ElementChange getChange(Element elem) {
            return null;
        }

        public String toString() {
            return "DocumentEvent[" + (this.isInsert ? "insert " : "remove  ") + this.length + " at " + this.offset + ": " + (this.length < 20 ? new String(this.data) : new String(this.data, 0, 16) + "...") + "]";
        }
    }

    private final class UndoEvent
    extends UndoableEditEvent {
        private UndoableEdit undoableEdit;

        private UndoEvent() {
            super(BasicDocument.this, null);
        }

        @Override
        public UndoableEdit getEdit() {
            return this.undoableEdit;
        }

        private void setEdit(UndoableEdit edit) {
            this.undoableEdit = edit;
        }

        private void clear() {
            this.undoableEdit = null;
        }
    }
}

