/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.AbstractFoldingBlock;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.editor.folding.DefaultFoldingBlock;

public class DefaultCodeFoldingModel<B extends DefaultFoldingBlock>
implements CodeFoldingModel<B> {
    protected static final int MAX_TOOLTIP_LENGTH = 4096;
    protected static final DefaultFoldingBlock[] NO_BLOCKS = new DefaultFoldingBlock[0];
    protected DefaultFoldingBlock root = new DefaultFoldingBlock();
    protected BasicDocument document;
    protected EventListenerList listenerList;
    protected ReadWriteLock lock;

    public DefaultCodeFoldingModel(BasicDocument document) {
        this.document = document;
        this.listenerList = new EventListenerList();
        this.lock = new ReadWriteLock();
    }

    public BasicDocument getDocument() {
        return this.document;
    }

    public void reload() {
        Object root;
        this.readLock();
        try {
            root = this.getRoot();
        }
        finally {
            this.readUnlock();
        }
        this.fireStructureChanged(root);
    }

    public void setRoot(B root) {
        DefaultFoldingBlock oldRoot;
        this.writeLock();
        try {
            oldRoot = this.root;
            this.root = root;
        }
        finally {
            this.writeUnlock();
        }
        if (root != oldRoot) {
            this.fireStructureChanged(this.root);
        }
    }

    public CodeFoldingModelListener[] getCodeFoldingModelListeners() {
        return (CodeFoldingModelListener[])this.listenerList.getListeners(CodeFoldingModelListener.class);
    }

    public void insertUpdate(int offset, int length) {
        this.writeLock();
        try {
            this.insertUpdateChildren(this.getRoot(), offset, length);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeUpdate(int offset, int length) {
        this.writeLock();
        try {
            this.removeUpdateChildren(this.getRoot(), offset, length);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void insertUpdateChildren(B block, int offset, int length) {
        Iterator it = ((AbstractFoldingBlock)block).getChildren();
        while (it.hasNext()) {
            DefaultFoldingBlock child = (DefaultFoldingBlock)it.next();
            int startOffset = child.getStartOffset();
            int endOffset = child.getEndOffset();
            if (offset <= startOffset) {
                child.setStartOffset(startOffset + length);
                child.setEndOffset(endOffset + length);
                this.insertUpdateChildren(child, offset, length);
                continue;
            }
            if (offset >= endOffset) continue;
            child.setEndOffset(endOffset + length);
            this.insertUpdateChildren(child, offset, length);
        }
    }

    protected void removeUpdateChildren(B block, int offset, int length) {
        Iterator it = ((AbstractFoldingBlock)block).getChildren();
        while (it.hasNext()) {
            DefaultFoldingBlock child = (DefaultFoldingBlock)it.next();
            int startOffset = child.getStartOffset();
            int endOffset = child.getEndOffset();
            if (offset <= startOffset) {
                if (offset + length > startOffset) {
                    it.remove();
                    continue;
                }
                child.setStartOffset(startOffset - length);
                child.setEndOffset(endOffset - length);
                this.removeUpdateChildren(child, offset, length);
                continue;
            }
            if (offset >= endOffset) continue;
            if (offset + length >= endOffset) {
                child.setEndOffset(offset);
            } else {
                child.setEndOffset(endOffset - length);
            }
            this.removeUpdateChildren(child, offset, length);
        }
    }

    @Override
    public void readLock() {
        BasicDocument document = this.getDocument();
        document.readLock();
        this.lock.readLock();
    }

    @Override
    public void readUnlock() {
        BasicDocument document = this.getDocument();
        this.lock.readUnlock();
        document.readUnlock();
    }

    @Override
    public B getRoot() {
        return (B)this.root;
    }

    @Override
    public B getSmallestEnclosingBlock(int offset) {
        return (B)this.getEnclosingDescendant(this.getRoot(), offset);
    }

    @Override
    public B getFirstBlockAtLine(int line) {
        return (B)this.getFirstDescendantAtLine(this.getRoot(), line);
    }

    @Override
    public B[] getCollapsedBlocks() {
        ArrayList collapsed = new ArrayList();
        this.getCollapsedDescendants(this.getRoot(), collapsed);
        if (collapsed.size() == 0) {
            return NO_BLOCKS;
        }
        return collapsed.toArray(new DefaultFoldingBlock[collapsed.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipText(B block) {
        String text;
        BasicDocument document = this.getDocument();
        B fb = block;
        int startOffset = ((DefaultFoldingBlock)fb).getStartOffset();
        int endOffset = ((DefaultFoldingBlock)fb).getEndOffset();
        int startLine = this.getLineFromOffset(startOffset);
        int offset = this.getLineStartOffset(startLine);
        document.readLock();
        try {
            int length = endOffset - offset;
            length = Math.min(length, 4096);
            text = document.getText(offset, length);
        }
        catch (BadLocationException ex) {
            text = null;
        }
        finally {
            document.readUnlock();
        }
        return text;
    }

    @Override
    public Iterator<B> getChildren(B parent) {
        return ((AbstractFoldingBlock)parent).getChildren();
    }

    @Override
    public B getParent(B child) {
        DefaultFoldingBlock parent = (DefaultFoldingBlock)((AbstractFoldingBlock)child).getParent();
        return (B)parent;
    }

    @Override
    public int[] getTextOffsets(B block, int[] offsets) {
        if (offsets == null) {
            offsets = new int[]{((DefaultFoldingBlock)block).getStartOffset(), ((DefaultFoldingBlock)block).getEndOffset()};
        }
        return offsets;
    }

    @Override
    public String getAbbreviatedText(B block) {
        return ((DefaultFoldingBlock)block).getReplacementText();
    }

    @Override
    public boolean isExpanded(B block) {
        return ((AbstractFoldingBlock)block).isExpanded();
    }

    @Override
    public void setExpanded(B block, boolean isExpanded) {
        ((AbstractFoldingBlock)block).setExpanded(isExpanded);
    }

    @Override
    public void addCodeFoldingModelListener(CodeFoldingModelListener listener) {
        this.listenerList.add(CodeFoldingModelListener.class, listener);
    }

    @Override
    public void removeCodeFoldingModelListener(CodeFoldingModelListener listener) {
        this.listenerList.remove(CodeFoldingModelListener.class, listener);
    }

    protected void writeLock() {
        BasicDocument document = this.getDocument();
        document.readLock();
        this.lock.writeLock();
    }

    protected void writeUnlock() {
        this.lock.writeUnlock();
        BasicDocument document = this.getDocument();
        document.readUnlock();
    }

    protected int getLineFromOffset(int offset) {
        BasicDocument document = this.getDocument();
        return document.getLineFromOffset(offset);
    }

    protected int getLineCount() {
        BasicDocument document = this.getDocument();
        return document.getLineCount();
    }

    protected int getLineStartOffset(int line) {
        BasicDocument document = this.getDocument();
        return document.getLineStartOffset(line);
    }

    protected int getLineEndOffset(int line) {
        BasicDocument document = this.getDocument();
        return document.getLineEndOffset(line);
    }

    protected B getFirstDescendantAtLine(B block, int line) {
        DefaultFoldingBlock child;
        DefaultFoldingBlock ret = null;
        Iterator it = ((AbstractFoldingBlock)block).getChildren();
        while (it.hasNext()) {
            child = (DefaultFoldingBlock)it.next();
            int startOffset = child.getStartOffset();
            int startLine = this.getLineFromOffset(startOffset);
            if (startLine != line) continue;
            if (ret == null) {
                ret = child;
                continue;
            }
            int oldStartOffset = ret.getStartOffset();
            if (startOffset >= oldStartOffset) continue;
            ret = child;
        }
        if (ret == null) {
            it = ((AbstractFoldingBlock)block).getChildren();
            while (it.hasNext()) {
                child = (DefaultFoldingBlock)it.next();
                ret = this.getFirstDescendantAtLine(child, line);
                if (ret == null) continue;
                return (B)ret;
            }
        }
        return (B)ret;
    }

    protected B getEnclosingDescendant(B block, int offset) {
        Iterator it = ((AbstractFoldingBlock)block).getChildren();
        while (it.hasNext()) {
            DefaultFoldingBlock child = (DefaultFoldingBlock)it.next();
            if (!child.bounds(offset)) continue;
            DefaultFoldingBlock descendant = this.getEnclosingDescendant(child, offset);
            return (B)(descendant != null ? descendant : child);
        }
        return null;
    }

    protected void getCollapsedDescendants(B block, Collection collapsed) {
        Iterator it = ((AbstractFoldingBlock)block).getChildren();
        while (it.hasNext()) {
            DefaultFoldingBlock child = (DefaultFoldingBlock)it.next();
            boolean expanded = child.isExpanded();
            if (!expanded) {
                collapsed.add(child);
                continue;
            }
            this.getCollapsedDescendants(child, collapsed);
        }
    }

    protected void fireStructureChanged(B block) {
        CodeFoldingModelEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CodeFoldingModelListener.class) continue;
            if (event == null) {
                event = new CodeFoldingModelEvent(this, block);
            }
            CodeFoldingModelListener listener = (CodeFoldingModelListener)listeners[i + 1];
            listener.structureChanged(event);
        }
    }
}

