/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import oracle.javatools.editor.highlight.UnderlinePainter;

public final class HighlightStyle {
    public static final int MINIMUM_PRIORITY = 1;
    public static final int MAXIMUM_PRIORITY = 100;
    public static final int DEFAULT_SELECTION_PRIORITY = 100;
    public static final int FONT_NORMAL = 0;
    public static final int FONT_BOLD = 1;
    public static final int FONT_ITALIC = 2;
    public static final int FONT_BOLD_ITALIC = 3;
    private String _internalName;
    private String _presentationName;
    private boolean _enabled;
    private int _priority;
    private Color _fgColor;
    private Color _bgColor;
    private int _fontStyle;
    private Color _underlineColor;
    private UnderlinePainter _underlinePainter;
    private boolean _transience;

    HighlightStyle(String name, String presentationName, boolean enabled, int priority, Color fgColor, Color bgColor, int fontStyle, UnderlinePainter underlinePainter, Color underlineColor, boolean isTransient) {
        this._internalName = name;
        this._presentationName = presentationName;
        this.setEnabled(enabled);
        this.setPriority(priority);
        this.setForegroundColor(fgColor);
        this.setBackgroundColor(bgColor);
        this.setFontStyle(fontStyle);
        this.setUnderlinePainter(underlinePainter);
        this.setUnderlineColor(underlineColor);
        this.setTransient(isTransient);
    }

    public String getName() {
        return this._internalName;
    }

    public String getPresentationName() {
        return this._presentationName;
    }

    public String toString() {
        return this._presentationName;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public int getPriority() {
        return this._priority;
    }

    void setPriority(int newPriority) {
        newPriority = Math.max(1, newPriority);
        this._priority = newPriority = Math.min(100, newPriority);
    }

    public boolean getUseForegroundColor() {
        return this.getForegroundColor() != null;
    }

    public boolean getUseBackgroundColor() {
        return this.getBackgroundColor() != null;
    }

    public boolean getUseFontStyle() {
        return this.getFontStyle() != 0;
    }

    public boolean getUseUnderline() {
        boolean hasColor = this.getUnderlineColor() != null;
        boolean hasPainter = this.getUnderlinePainter() != null;
        return hasColor && hasPainter;
    }

    public boolean isTransient() {
        return this._transience;
    }

    void setTransient(boolean transience) {
        this._transience = transience;
    }

    public Color getForegroundColor() {
        return this._fgColor;
    }

    void setForegroundColor(Color newFgColor) {
        this._fgColor = newFgColor;
    }

    public Color getBackgroundColor() {
        return this._bgColor;
    }

    void setBackgroundColor(Color newBgColor) {
        this._bgColor = newBgColor;
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    void setFontStyle(int newFontStyle) {
        this._fontStyle = newFontStyle & 3;
    }

    public Color getUnderlineColor() {
        return this._underlineColor;
    }

    void setUnderlineColor(Color newUnderlineColor) {
        this._underlineColor = newUnderlineColor;
    }

    public UnderlinePainter getUnderlinePainter() {
        return this._underlinePainter;
    }

    void setUnderlinePainter(UnderlinePainter painter) {
        this._underlinePainter = painter;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HighlightStyle)) {
            return false;
        }
        HighlightStyle other = (HighlightStyle)object;
        if (!(this._internalName != null ? this._internalName.equals(other._internalName) : other._internalName == null)) {
            return false;
        }
        if (!(this._presentationName != null ? this._presentationName.equals(other._presentationName) : other._presentationName == null)) {
            return false;
        }
        if (this._enabled != other._enabled) {
            return false;
        }
        if (this._priority != other._priority) {
            return false;
        }
        if (!(this._fgColor != null ? this._fgColor.equals(other._fgColor) : other._fgColor == null)) {
            return false;
        }
        if (!(this._bgColor != null ? this._bgColor.equals(other._bgColor) : other._bgColor == null)) {
            return false;
        }
        if (this._fontStyle != other._fontStyle) {
            return false;
        }
        if (!(this._underlineColor != null ? this._underlineColor.equals(other._underlineColor) : other._underlineColor == null)) {
            return false;
        }
        if (!(this._underlinePainter != null ? this._underlinePainter.equals(other._underlinePainter) : other._underlinePainter == null)) {
            return false;
        }
        return this._transience == other._transience;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this._internalName == null ? 0 : this._internalName.hashCode());
        result = 37 * result + (this._presentationName == null ? 0 : this._presentationName.hashCode());
        result = 37 * result + (this._enabled ? 0 : 1);
        result = 37 * result + (this._fgColor == null ? 0 : this._fgColor.hashCode());
        result = 37 * result + (this._bgColor == null ? 0 : this._bgColor.hashCode());
        result = 37 * result + (this._underlineColor == null ? 0 : this._underlineColor.hashCode());
        result = 37 * result + (this._underlinePainter == null ? 0 : this._underlinePainter.hashCode());
        result = 37 * result + (this._transience ? 0 : 1);
        return result;
    }
}

