/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.config;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class NaBL2DebugConfig
implements Serializable {
    private static final long serialVersionUID = 42L;
    public static final NaBL2DebugConfig NONE = new NaBL2DebugConfig(EnumSet.noneOf(Flag.class));
    private final EnumSet<Flag> flags;

    public NaBL2DebugConfig(Flag ... flags) {
        this(Arrays.asList(flags));
    }

    public NaBL2DebugConfig(Collection<Flag> flags) {
        this.flags = Sets.newEnumSet(flags, Flag.class);
    }

    public boolean collection() {
        return this.flags.contains((Object)Flag.ALL) || this.flags.contains((Object)Flag.COLLECTION);
    }

    public boolean resolution() {
        return this.flags.contains((Object)Flag.ALL) || this.flags.contains((Object)Flag.RESOLUTION);
    }

    public boolean timing() {
        return this.flags.contains((Object)Flag.ALL) || this.flags.contains((Object)Flag.TIMING);
    }

    public boolean files() {
        return this.flags.contains((Object)Flag.ALL) || this.flags.contains((Object)Flag.FILES);
    }

    public boolean analysis() {
        return this.flags.contains((Object)Flag.ALL) || this.flags.contains((Object)Flag.ANALYSIS);
    }

    public boolean custom() {
        return this.flags.contains((Object)Flag.ALL) || this.flags.contains((Object)Flag.CUSTOM);
    }

    public static NaBL2DebugConfig of(Collection<Flag> flags) {
        return new NaBL2DebugConfig(flags);
    }

    public Collection<Flag> flags() {
        return this.flags;
    }

    public static enum Flag {
        ALL,
        ANALYSIS,
        FILES,
        COLLECTION,
        RESOLUTION,
        CUSTOM,
        TIMING;


        public static EnumSet<Flag> valuesOf(Collection<String> names) {
            Set flags = names.stream().map(String::toUpperCase).map(Flag::valueOf).collect(Collectors.toSet());
            return Sets.newEnumSet(flags, Flag.class);
        }

        public static List<String> namesOf(Collection<Flag> flags) {
            return flags.stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
        }
    }
}

