/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.resource;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.commons.vfs2.provider.res.ResourceFileSystemConfigBuilder;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.resource.ModifiedFileSelector;
import org.metaborg.util.file.FileUtils;
import org.metaborg.util.file.URIEncode;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.resource.ResourceUtils;

public class ResourceService
implements IResourceService {
    private static final ILogger logger = LoggerUtils.logger(ResourceService.class);
    private final FileSystemManager fileSystemManager;
    private final FileSystemOptions fileSystemOptions;

    @Inject
    public ResourceService(FileSystemManager fileSystemManager, @Named(value="ResourceClassLoader") ClassLoader classLoader) {
        this.fileSystemManager = fileSystemManager;
        this.fileSystemOptions = new FileSystemOptions();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ResourceFileSystemConfigBuilder.getInstance().setClassLoader(this.fileSystemOptions, classLoader);
    }

    @Override
    public void close() {
        if (this.fileSystemManager instanceof DefaultFileSystemManager) {
            DefaultFileSystemManager defaultFileSystemManager = (DefaultFileSystemManager)this.fileSystemManager;
            defaultFileSystemManager.close();
        } else {
            logger.warn("File system manager {} does not support cleaning up", this.fileSystemManager);
        }
    }

    @Override
    public FileObject root() {
        try {
            return this.fileSystemManager.getBaseFile();
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public FileObject resolve(String uri) {
        try {
            String uriEncoded = URIEncode.encode(uri);
            return this.fileSystemManager.resolveFile(uriEncoded, this.fileSystemOptions);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public FileObject resolve(File file) {
        try {
            return this.fileSystemManager.toFileObject(file);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public FileObject resolve(URI uri) {
        try {
            return this.fileSystemManager.resolveFile(uri.toString());
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public FileObject resolve(FileObject parent, String path) {
        try {
            String pathEncoded = URIEncode.encode(path);
            URI uri = new URI(pathEncoded);
            if (uri.isAbsolute()) {
                return this.resolve(uri);
            }
        }
        catch (URISyntaxException pathEncoded) {
            // empty catch block
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return this.resolve("file://" + path);
        }
        try {
            return ResourceUtils.resolveFile(parent, path);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public FileName resolveToName(String uri) {
        try {
            String uriEncoded = URIEncode.encode(uri);
            return this.fileSystemManager.resolveURI(uriEncoded);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public FileName resolveToName(URI uri) {
        try {
            return this.fileSystemManager.resolveURI(uri.toString());
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    @Override
    public File localFile(FileObject resource) {
        if (resource instanceof LocalFile) {
            return FileUtils.toFile(resource);
        }
        try {
            return resource.getFileSystem().replicateFile(resource, (FileSelector)new AllFileSelector());
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException("Could not get local file for " + resource, e);
        }
    }

    @Override
    public File localFile(FileObject resource, FileObject dir) {
        if (resource instanceof LocalFile) {
            return FileUtils.toFile(resource);
        }
        File localDir = this.localPath(dir);
        if (localDir == null) {
            throw new MetaborgRuntimeException("Replication directory " + dir + " is not on the local filesystem, cannot get local file for " + resource);
        }
        try {
            dir.createFolder();
            FileObject copyLoc = resource.getType() == FileType.FOLDER ? dir : ResourceUtils.resolveFile(dir, resource.getName().getBaseName());
            copyLoc.copyFrom(resource, (FileSelector)new AllFileSelector());
            return this.localPath(copyLoc);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException("Could not get local file for " + resource, e);
        }
    }

    @Override
    public File localFileUpdate(FileObject resource, FileObject dir) {
        if (resource instanceof LocalFile) {
            return FileUtils.toFile(resource);
        }
        File localDir = this.localPath(dir);
        if (localDir == null) {
            throw new MetaborgRuntimeException("Replication directory " + dir + " is not on the local filesystem, cannot get local file for " + resource);
        }
        try {
            FileObject copyLoc = resource.getType() == FileType.FOLDER ? dir : ResourceUtils.resolveFile(dir, resource.getName().getBaseName());
            copyLoc.copyFrom(resource, (FileSelector)new ModifiedFileSelector(copyLoc));
            return this.localPath(copyLoc);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException("Could not get local file for " + resource, e);
        }
    }

    @Override
    public File localPath(FileObject resource) {
        if (resource instanceof LocalFile) {
            return FileUtils.toFile(resource);
        }
        return null;
    }
}

