/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.cmd.spi.providers;

import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandReader;
import oracle.jdeveloper.deploy.cmd.spi.HashDeployCommandWriter;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public abstract class AbstractHashDeployCommandIOProvider
extends AbstractToolkitProvider {
    public AbstractHashDeployCommandIOProvider() {
        super(DefaultHashDeployCommandIO.class);
    }

    public AbstractHashDeployCommandIOProvider(Class<? extends Toolkit> intf) {
        super(intf);
    }

    @Override
    public AbstractToolkitBuilder create(ToolkitContext tkContext) {
        Object spi;
        final Element element = tkContext.getElement();
        Class classOrIntf = tkContext.getToolkitClass();
        Cookie c = null;
        if (classOrIntf.isAssignableFrom(HashDeployCommandReader.class)) {
            spi = new HashDeployCommandReader.SpiData(tkContext.getIdeContext());
            HashStructure hash = ((HashDeployCommandReader.SpiData)spi).getHashStructure();
            if (hash == null) {
                return null;
            }
            c = new Cookie();
            if (!this.canRead(element, hash, tkContext, c)) {
                return null;
            }
        } else if (classOrIntf.isAssignableFrom(HashDeployCommandWriter.class)) {
            spi = new HashDeployCommandWriter.SpiData(tkContext.getIdeContext());
            DeployCommand cmd = ((HashDeployCommandWriter.SpiData)spi).getCommand();
            if (cmd == null) {
                return null;
            }
            c = new Cookie();
            if (!this.canWrite(element, cmd, tkContext, c)) {
                return null;
            }
        }
        assert (c != null);
        final Cookie cookie = c;
        return new AbstractToolkitBuilder(this, tkContext){

            @Override
            protected Toolkit build() {
                return new DefaultHashDeployCommandIO(element, cookie);
            }
        };
    }

    protected HashDeployCommandWriter.HashDisplayable createDisplayable(DeployCommand cmd) {
        HashDeployCommandWriter.HashDisplayable d = new HashDeployCommandWriter.HashDisplayable();
        d.setLongLabel(cmd.getLongLabel());
        d.setShortLabel(cmd.getShortLabel());
        d.setToolTipText(cmd.getToolTipText());
        return d;
    }

    protected abstract boolean canRead(Element var1, HashStructure var2, ToolkitContext var3, Cookie var4);

    protected abstract boolean canWrite(Element var1, DeployCommand var2, ToolkitContext var3, Cookie var4);

    protected abstract DeployCommand read(Element var1, Cookie var2);

    protected abstract void write(HashStructure var1, Element var2, Cookie var3);

    protected abstract HashDeployCommandWriter.HashDisplayable getDisplayable(Element var1, Cookie var2);

    protected static void commandInstantiationException(Exception e) {
        throw new CommandInstantiationException("Could not read command " + e.getMessage(), e);
    }

    protected class DefaultHashDeployCommandIO
    implements HashDeployCommandReader,
    HashDeployCommandWriter {
        final Cookie cookie_;
        final Element element_;

        DefaultHashDeployCommandIO(Element element, Cookie cookie) {
            this.cookie_ = cookie;
            this.element_ = element;
        }

        @Override
        public DeployCommand read() {
            return AbstractHashDeployCommandIOProvider.this.read(this.element_, this.cookie_);
        }

        @Override
        public void write(HashStructure hash) {
            AbstractHashDeployCommandIOProvider.this.write(hash, this.element_, this.cookie_);
        }

        @Override
        public HashDeployCommandWriter.HashDisplayable getDisplayable() {
            return AbstractHashDeployCommandIOProvider.this.getDisplayable(this.element_, this.cookie_);
        }
    }

    public static class CommandInstantiationException
    extends RuntimeException {
        CommandInstantiationException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

