/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.contrib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import oracle.ide.Context;

public final class ProcessorCache {
    private static final String KEY = ProcessorCache.class.getName() + ".contextKey";
    private int ref = 0;
    private final HashMap<Class, Object> cacheMap = new HashMap();

    public static final synchronized ProcessorCache install(Context context) {
        ProcessorCache pc = ProcessorCache.get(context);
        if (pc == null) {
            pc = new ProcessorCache();
            ProcessorCache.set(context, pc);
        }
        pc.incrementRef();
        return pc;
    }

    public static final synchronized ProcessorCache uninstall(Context context) {
        ProcessorCache pc = ProcessorCache.get(context);
        assert (pc != null);
        pc.decrementRef();
        if (pc.ref() == 0) {
            ProcessorCache.set(context, null);
        }
        return pc;
    }

    public final ProcessorCache installInstance(Context context) {
        assert (ProcessorCache.get(context) == null);
        ProcessorCache.set(context, this);
        this.incrementRef();
        return this;
    }

    public final ProcessorCache uninstallInstance(Context context) {
        assert (ProcessorCache.get(context) != null);
        this.decrementRef();
        ProcessorCache.set(context, null);
        return this;
    }

    private static ProcessorCache get(Context context) {
        return (ProcessorCache)context.getProperty(KEY);
    }

    private static void set(Context context, ProcessorCache cache) {
        if (cache == null) {
            context.removeProperty(KEY);
            return;
        }
        context.setProperty(KEY, (Object)cache);
    }

    public final synchronized <T extends Member> T getCache(Class<T> cacheClass) throws CacheCreationException {
        Object o = this.cacheMap.get(cacheClass);
        if (o == null) {
            try {
                Constructor<T> ctor = cacheClass.getConstructor(ProcessorCache.class);
                Member t = (Member)ctor.newInstance(this);
                this.cacheMap.put(cacheClass, t);
                return (T)t;
            }
            catch (InstantiationException e) {
                this.throwCacheCreationException(e);
            }
            catch (IllegalAccessException e) {
                this.throwCacheCreationException(e);
            }
            catch (ClassCastException e) {
                this.throwCacheCreationException(e);
            }
            catch (NoSuchMethodException e) {
                this.throwCacheCreationException(e);
            }
            catch (InvocationTargetException e) {
                this.throwCacheCreationException(e);
            }
        }
        return (T)((Member)o);
    }

    private void throwCacheCreationException(Exception e) {
        throw new CacheCreationException("Unable to create Processor cache.", e);
    }

    public int ref() {
        return this.ref;
    }

    public void incrementRef() {
        ++this.ref;
    }

    public void decrementRef() {
        --this.ref;
    }

    public final class CacheCreationException
    extends RuntimeException {
        private static final long serialVersionUID = 94398987141166124L;

        private CacheCreationException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static abstract class Member {
        private final ProcessorCache cache;

        public Member(ProcessorCache cache) {
            this.cache = cache;
        }

        protected final ProcessorCache cache() {
            return this.cache;
        }
    }
}

