/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.extension.rules.Rule;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultDeployerListener;
import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.ListenerCondition;
import oracle.jdeveloper.deploy.VetoableDeployException;
import oracle.jdeveloper.deploy.meta.CustomMetaClass;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.shell.ShellAdapter;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;

public class DeployerListenersHandler
extends BaseElementVisitor
implements ElementVisitorFactory {
    static final ElementName EN_DEPLOYER_LISTENERS = DeployerListenersHandler.e("deployer-listeners");
    static final ElementName EN_DEPLOYER_LISTENER = DeployerListenersHandler.e("deployer-listener");
    static final ElementName EN_DEPLOYABLE_CLASS = DeployerListenersHandler.e("deployable-class");
    static final ElementName EN_DEPLOYER_CLASS = DeployerListenersHandler.e("deployer-class");
    static final ElementName EN_CURRENT_SEQUENCE = DeployerListenersHandler.e("current-sequence");
    static final ElementName EN_ANCESTOR_SEQUENCE = DeployerListenersHandler.e("ancestor-sequence");
    static final ElementName EN_PLATFORM_TYPE = DeployerListenersHandler.e("platform-type");
    static final ElementName EN_TECHNOLOGY_SCOPE = DeployerListenersHandler.e("technology-scope");
    static final ElementName EN_TECHNOLOGY_KEY = DeployerListenersHandler.e("key");
    static final ElementName EN_PRIORITY = DeployerListenersHandler.e("priority");
    static final ElementName EN_LISTENER_CLASS = DeployerListenersHandler.e("listener-class");
    static final String ATTR_RULE = "rule";
    static final String ATTR_IN = "in";
    static final String ATTR_MATCH = "match";
    static final String MATCH_ALL = "all";
    static final String MATCH_ANY = "any";
    static final String TECHSCOPE_IN_CURRENT_PROJECT = "current-project";
    static final String TECHSCOPE_IN_ANY_PROJECT = "any-project";
    static final String TECHSCOPE_IN_ALL_PROJECTS = "all-projects";

    public void start(ElementStartContext context) {
        ElementName name = context.getElementName();
        if (EN_DEPLOYER_LISTENERS.equals((Object)name)) {
            context.registerChildVisitor(EN_DEPLOYER_LISTENER, (ElementVisitor)this);
        } else if (EN_DEPLOYER_LISTENER.equals((Object)name)) {
            HookDeployerListener listener = new HookDeployerListener();
            listener.rule = context.getAttributeValue(ATTR_RULE);
            context.getScopeData().put(HookDeployerListener.class, listener);
            context.registerVisitorFactory((ElementVisitorFactory)this);
        } else if (EN_TECHNOLOGY_SCOPE.equals((Object)name)) {
            String in;
            HookDeployerListener listener = (HookDeployerListener)context.getScopeData().get(HookDeployerListener.class);
            listener.techScope = new TechnologyScope();
            String match = context.getAttributeValue(ATTR_MATCH);
            Assert.printStackTrace((match != null && !MATCH_ANY.equals(match) && !MATCH_ALL.equals(match) ? 1 : 0) != 0, (String)"Value of 'match' attribute should be 'any' or 'all' in <technology-scope> element.");
            if (MATCH_ANY.equals(context.getAttributeValue(ATTR_MATCH))) {
                listener.match = HookDeployerListener.MATCH_ANY_POLICY;
            }
            Assert.printStackTrace(((in = context.getAttributeValue(ATTR_IN)) != null && !TECHSCOPE_IN_CURRENT_PROJECT.equals(in) && !TECHSCOPE_IN_ANY_PROJECT.equals(in) && !TECHSCOPE_IN_ALL_PROJECTS.equals(in) ? 1 : 0) != 0, (String)"Value of 'in' attribute should be 'any' or 'all' in <technology-scope> element.");
            if (TECHSCOPE_IN_ANY_PROJECT.equals(in)) {
                listener.techScopeIn = HookDeployerListener.ANY_PROJECT_IN_WORKSPACE_POLICY;
            } else if (TECHSCOPE_IN_ALL_PROJECTS.equals(in)) {
                listener.techScopeIn = HookDeployerListener.ALL_PROJECTS_IN_WORKSPACE_POLICY;
            }
        }
    }

    private static boolean isTechScopeRule(String ruleId) {
        if (ruleId == null) {
            return false;
        }
        RuleEngine engine = RuleEngine.getInstance();
        Rule rule = engine.getRule(ruleId);
        return rule.matchesType(Collections.singleton("project-has-techscope"));
    }

    public void end(ElementEndContext context) {
        ElementName en = context.getElementName();
        HookDeployerListener listener = (HookDeployerListener)context.getScopeData().get(HookDeployerListener.class);
        if (EN_DEPLOYABLE_CLASS.equals((Object)en)) {
            listener.deployable = DeployerListenersHandler.makeMetaClass(context);
        } else if (EN_DEPLOYER_CLASS.equals((Object)en)) {
            listener.deployer = DeployerListenersHandler.makeMetaClass(context);
        } else if (EN_CURRENT_SEQUENCE.equals((Object)en)) {
            int sequenceId;
            String sequence = context.getText().trim();
            assert (ModelUtil.hasLength((String)sequence));
            listener.currentSequence = sequenceId = DeploymentManager.getDeploymentSequenceId(sequence);
        } else if (EN_ANCESTOR_SEQUENCE.equals((Object)en)) {
            String sequence = context.getText().trim();
            assert (ModelUtil.hasLength((String)sequence));
            int sequenceId = DeploymentManager.getDeploymentSequenceId(sequence);
            listener.addAncestor(sequenceId);
        } else if (EN_LISTENER_CLASS.equals((Object)en)) {
            listener.delegate = DeployerListenersHandler.makeMetaClass(context);
        } else if (EN_TECHNOLOGY_KEY.equals((Object)en)) {
            String techKey = context.getText().trim();
            TechnologyRegistry reg = TechnologyRegistry.getInstance();
            TechId id = reg.getTechId(techKey);
            if (id == null) {
                this.log((ElementContext)context, Level.SEVERE, "Technology key " + techKey + " not in registry");
            } else {
                listener.techScope.add(id);
            }
        } else if (EN_TECHNOLOGY_SCOPE.equals((Object)en)) {
            if (listener.techScope.getTechnologyKeys().length == 0) {
                listener.techScope = null;
            }
        } else if (EN_PLATFORM_TYPE.equals((Object)en)) {
            try {
                PlatformType ptype;
                listener.platformType = ptype = PlatformType.valueOf(context.getText().trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (EN_PRIORITY.equals((Object)en)) {
            try {
                float f;
                listener.priority = f = Float.parseFloat(context.getText().trim());
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid priority value in deployer-listener hook");
                e.printStackTrace();
            }
        } else if (EN_DEPLOYER_LISTENER.equals((Object)en)) {
            assert (listener.delegate != null);
            if (listener.deployable == null && listener.techScope == null && !DeployerListenersHandler.isTechScopeRule(listener.rule)) {
                context.getLogger().warning(String.format("%s: %s (%s)", "<deployer-listener> hook should specify a deployable-class or tech-scope elements or a tech-scope rule ", context.getExtension().getID(), context.getExtension().getName()));
            }
            DeploymentManager.addDeployerListener(listener, listener, listener.priority);
        }
    }

    public ElementVisitor getVisitor(ElementName name) {
        return this;
    }

    class AllKeysComparePolicy {
        AllKeysComparePolicy() {
        }

        boolean isMatch(TechnologyScope listenerScope, String[] keys) {
            TechnologyScope scope = new TechnologyScope();
            scope.setTechnologyKeys(keys);
            return scope.contains(listenerScope);
        }
    }

    private static class HookDeployerListener
    implements ListenerCondition,
    DeployerListener {
        static final MatchPolicy MATCH_ALL_POLICY = new MatchPolicy(){

            @Override
            public boolean isMatch(TechnologyScope listenerScope, String[] keys) {
                TechnologyScope techScope = new TechnologyScope();
                techScope.setTechnologyKeys(keys);
                return techScope.contains(listenerScope);
            }
        };
        static final MatchPolicy MATCH_ANY_POLICY = new MatchPolicy(){

            @Override
            public boolean isMatch(TechnologyScope listenerScope, String[] keys) {
                HashSet keysSet = new HashSet();
                Collections.addAll(keysSet, keys);
                for (String key : listenerScope.getTechnologyKeys()) {
                    if (!keysSet.contains(key)) continue;
                    return true;
                }
                return false;
            }
        };
        static final TechScopeInPolicy CURRENT_PROJECT_ONLY_POLICY = new TechScopeInPolicy(){

            @Override
            public boolean isTechScopeIn(Context context, TechnologyScope listenerScope, MatchPolicy matchPolicy) {
                Project project = context.getProject();
                String[] keys = NO_KEYS;
                if (project != null) {
                    keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope().getTechnologyKeys();
                }
                return matchPolicy.isMatch(listenerScope, keys);
            }
        };
        static final TechScopeInPolicy ANY_PROJECT_IN_WORKSPACE_POLICY = new TechScopeInPolicy(){

            @Override
            public boolean isTechScopeIn(Context context, TechnologyScope listenerScope, MatchPolicy matchPolicy) {
                Workspace workspace = context.getWorkspace();
                if (workspace != null) {
                    Iterator iterator = workspace.getChildren();
                    while (iterator.hasNext()) {
                        Project project = (Project)iterator.next();
                        String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope().getTechnologyKeys();
                        if (!matchPolicy.isMatch(listenerScope, keys)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        static final TechScopeInPolicy ALL_PROJECTS_IN_WORKSPACE_POLICY = new TechScopeInPolicy(){

            @Override
            public boolean isTechScopeIn(Context context, TechnologyScope listenerScope, MatchPolicy matchPolicy) {
                Workspace workspace = context.getWorkspace();
                String[] keys = NO_KEYS;
                if (workspace != null) {
                    Iterator iterator = workspace.getChildren();
                    ArrayList keysList = new ArrayList();
                    while (iterator.hasNext()) {
                        Project project = (Project)iterator.next();
                        Collections.addAll(keysList, TechnologyScopeConfiguration.getInstance((PropertyStorage)project).getTechnologyScope().getTechnologyKeys());
                    }
                    keys = keysList.toArray(new String[keysList.size()]);
                }
                return matchPolicy.isMatch(listenerScope, keys);
            }
        };
        MetaClass deployable;
        MetaClass deployer;
        int currentSequence = -1;
        int[] ancestorSequences = new int[0];
        TechnologyScope techScope = null;
        TechScopeInPolicy techScopeIn = CURRENT_PROJECT_ONLY_POLICY;
        MatchPolicy match = MATCH_ALL_POLICY;
        MetaClass<DeployerListener> delegate;
        PlatformType platformType;
        DeployerListener listener = null;
        float priority = 0.5f;
        String rule;

        private HookDeployerListener() {
        }

        void addAncestor(int seq) {
            this.ancestorSequences = Arrays.copyOf(this.ancestorSequences, this.ancestorSequences.length + 1);
            this.ancestorSequences[this.ancestorSequences.length - 1] = seq;
        }

        synchronized DeployerListener listener() {
            if (this.listener == null) {
                if (this.delegate != null) {
                    try {
                        this.listener = (DeployerListener)this.delegate.newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.delegate = null;
                    }
                } else {
                    this.listener = new DefaultDeployerListener();
                }
            }
            return this.listener;
        }

        @Override
        public boolean shouldFire(DeployEvent event) {
            RuleEngine engine;
            Deployer d;
            if (this.delegate == null) {
                return false;
            }
            if (this.currentSequence > 0 && event.getCurrentSequence() != this.currentSequence) {
                return false;
            }
            ShellAdapter sh = ShellAdapter.getInstance(event.getShell());
            if (this.ancestorSequences.length > 0 && !sh.isDeploying(this.ancestorSequences)) {
                return false;
            }
            if (this.platformType != null) {
                Platform platform = sh.getPlatform();
                if (platform == null) {
                    return false;
                }
                if (!platform.getType().isExtensionOf(this.platformType)) {
                    return false;
                }
            }
            if (this.deployable != null) {
                Element e = sh.getDeployElement();
                if (e == null) {
                    return false;
                }
                if (!CustomMetaClass.isAssignable(this.deployable, e.getClass())) {
                    return false;
                }
            }
            if (this.deployer != null && !CustomMetaClass.isAssignable(this.deployer, (d = event.getDeployer()).getClass())) {
                return false;
            }
            Context context = sh.getContext();
            if (this.techScope != null && !this.techScopeIn.isTechScopeIn(context, this.techScope, this.match)) {
                return false;
            }
            return this.rule == null || (engine = RuleEngine.getInstance()).evaluateRule(this.rule, context);
        }

        @Override
        public void willPrepare(DeployEvent event) throws VetoableDeployException {
            this.listener().willPrepare(event);
        }

        @Override
        public void prepared(DeployEvent event) throws VetoableDeployException {
            this.listener().prepared(event);
        }

        @Override
        public void willDeploy(DeployEvent event) throws VetoableDeployException {
            this.listener().willDeploy(event);
        }

        @Override
        public void deployed(DeployEvent event) {
            this.listener().deployed(event);
        }

        @Override
        public void willFinish(DeployEvent event) {
            this.listener().willFinish(event);
        }

        @Override
        public void finished(DeployEvent event) {
            this.listener().finished(event);
        }

        @Override
        public void willCancel(DeployEvent event) {
            this.listener().willCancel(event);
        }

        @Override
        public void cancelled(DeployEvent event) {
            this.listener().cancelled(event);
        }

        static interface MatchPolicy {
            public boolean isMatch(TechnologyScope var1, String[] var2);
        }

        static interface TechScopeInPolicy {
            public static final String[] NO_KEYS = new String[0];

            public boolean isTechScopeIn(Context var1, TechnologyScope var2, MatchPolicy var3);
        }
    }
}

