/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Date;
import oracle.express.idl.ExpressOlapiDataCursorModule.CompoundCursorBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.DependencyBlockUnion;
import oracle.express.idl.ExpressOlapiDataCursorModule.IncludedDependencyBlockStruct;
import oracle.express.idl.ExpressOlapiDataCursorModule.ValueCursorBlockStruct;
import oracle.express.idl.reconciliation.TxsOqCursorBlockStruct;
import oracle.express.idl.reconciliation.TxsOqCursorValueUnion;
import oracle.express.idl.reconciliation.TxsOqDataBlockStruct;
import oracle.express.idl.reconciliation.TxsOqDataUnion;
import oracle.express.idl.reconciliation.TxsOqParentStartEndBlockUnion;
import oracle.express.olapi.data.CursorTreeManager;
import oracle.olapi.data.cursor.NoDataAvailableException;
import oracle.olapi.data.source.Parameter;

public final class CursorBlock {
    private TxsOqCursorBlockStruct _cursorBlockStruct;
    private ValueCursorBlockStruct[] _idToValueCursorBlockTable;
    private CompoundCursorBlockStruct[] _idToCompoundCursorBlockTable;
    private TxsOqDataBlockStruct[] _idToDataBlockTable;
    private TxsOqParentStartEndBlockUnion[] _idToParentStartBlockTable;
    private TxsOqParentStartEndBlockUnion[] _idToParentEndBlockTable;
    private int _idTableSize;
    private TxsOqCursorValueUnion[] _paramValues;
    private boolean _initialized = false;

    public CursorBlock(TxsOqCursorBlockStruct txsOqCursorBlockStruct, TxsOqCursorValueUnion[] txsOqCursorValueUnionArray) {
        this._cursorBlockStruct = txsOqCursorBlockStruct;
        this._paramValues = txsOqCursorValueUnionArray;
        this._idTableSize = 0;
        TxsOqDataBlockStruct[] txsOqDataBlockStructArray = txsOqCursorBlockStruct.dataBlocks;
        for (int i = 0; i < txsOqDataBlockStructArray.length; ++i) {
            short s = txsOqDataBlockStructArray[i].id;
            if (s < this._idTableSize) continue;
            this._idTableSize = s + 1;
        }
        if (this._idTableSize > 0) {
            this.initializeLookupTables();
        }
    }

    private void initializeLookupTables() {
        DependencyBlockUnion[][] dependencyBlockUnionArray;
        TxsOqParentStartEndBlockUnion[] txsOqParentStartEndBlockUnionArray;
        TxsOqParentStartEndBlockUnion[] txsOqParentStartEndBlockUnionArray2;
        TxsOqDataBlockStruct[] txsOqDataBlockStructArray;
        CompoundCursorBlockStruct[] compoundCursorBlockStructArray;
        int n;
        this._initialized = true;
        this._idToValueCursorBlockTable = new ValueCursorBlockStruct[this._idTableSize];
        ValueCursorBlockStruct[] valueCursorBlockStructArray = this._cursorBlockStruct.valueCursorBlocks;
        for (n = 0; n < valueCursorBlockStructArray.length; ++n) {
            this._idToValueCursorBlockTable[compoundCursorBlockStructArray.indexBlock.id] = compoundCursorBlockStructArray = valueCursorBlockStructArray[n];
        }
        this._idToCompoundCursorBlockTable = new CompoundCursorBlockStruct[this._idTableSize];
        compoundCursorBlockStructArray = this._cursorBlockStruct.compoundCursorBlocks;
        for (n = 0; n < compoundCursorBlockStructArray.length; ++n) {
            this._idToCompoundCursorBlockTable[txsOqDataBlockStructArray.indexBlock.id] = txsOqDataBlockStructArray = compoundCursorBlockStructArray[n];
        }
        this._idToDataBlockTable = new TxsOqDataBlockStruct[this._idTableSize];
        txsOqDataBlockStructArray = this._cursorBlockStruct.dataBlocks;
        for (n = 0; n < txsOqDataBlockStructArray.length; ++n) {
            this._idToDataBlockTable[txsOqParentStartEndBlockUnionArray2.id] = txsOqParentStartEndBlockUnionArray2 = txsOqDataBlockStructArray[n];
        }
        this._idToParentStartBlockTable = new TxsOqParentStartEndBlockUnion[this._idTableSize];
        txsOqParentStartEndBlockUnionArray2 = this._cursorBlockStruct.parentStartBlocks;
        block11: for (n = 0; n < txsOqParentStartEndBlockUnionArray2.length; ++n) {
            txsOqParentStartEndBlockUnionArray = txsOqParentStartEndBlockUnionArray2[n];
            switch (txsOqParentStartEndBlockUnionArray.discriminator()) {
                case 0: {
                    this._idToParentStartBlockTable[txsOqParentStartEndBlockUnionArray.dataBlock().id] = txsOqParentStartEndBlockUnionArray;
                    continue block11;
                }
                case 1: {
                    this._idToParentStartBlockTable[txsOqParentStartEndBlockUnionArray.multiplierBlock().id] = txsOqParentStartEndBlockUnionArray;
                }
            }
        }
        this._idToParentEndBlockTable = new TxsOqParentStartEndBlockUnion[this._idTableSize];
        txsOqParentStartEndBlockUnionArray = this._cursorBlockStruct.parentEndBlocks;
        block12: for (n = 0; n < txsOqParentStartEndBlockUnionArray.length; ++n) {
            dependencyBlockUnionArray = txsOqParentStartEndBlockUnionArray[n];
            switch (dependencyBlockUnionArray.discriminator()) {
                case 0: {
                    this._idToParentEndBlockTable[dependencyBlockUnionArray.dataBlock().id] = dependencyBlockUnionArray;
                    continue block12;
                }
                case 1: {
                    this._idToParentEndBlockTable[dependencyBlockUnionArray.multiplierBlock().id] = dependencyBlockUnionArray;
                }
            }
        }
        dependencyBlockUnionArray = this._cursorBlockStruct.dependencyGroups;
        for (n = 0; n < dependencyBlockUnionArray.length; ++n) {
            DependencyBlockUnion[] dependencyBlockUnionArray2 = dependencyBlockUnionArray[n];
            for (int i = 0; i < dependencyBlockUnionArray2.length; ++i) {
                int n2;
                DependencyBlockUnion dependencyBlockUnion = dependencyBlockUnionArray2[i];
                if (dependencyBlockUnion.discriminator() != 1) continue;
                IncludedDependencyBlockStruct includedDependencyBlockStruct = dependencyBlockUnionArray2[i].includedDependencyBlock();
                ValueCursorBlockStruct valueCursorBlockStruct = this.getValueCursorBlocks()[includedDependencyBlockStruct.dependencyBlock.valueCursorBlockIndex];
                int[] nArray = new int[valueCursorBlockStruct.indexBlock.physicalExtents.length];
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = n2;
                }
                includedDependencyBlockStruct.spans = nArray;
                n2 = i;
                while (n2 >= 0) {
                    IncludedDependencyBlockStruct includedDependencyBlockStruct2 = dependencyBlockUnionArray2[n2].includedDependencyBlock();
                    ValueCursorBlockStruct valueCursorBlockStruct2 = this.getValueCursorBlocks()[includedDependencyBlockStruct2.dependencyBlock.valueCursorBlockIndex];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = valueCursorBlockStruct2.indexBlock.physicalExtents[nArray[j]];
                    }
                    n2 = includedDependencyBlockStruct2.dependencyBlock.dependentIndex;
                }
            }
        }
    }

    public final ValueCursorBlockStruct getValueCursorBlock(int n) {
        if (this.isInitialized()) {
            return this._idToValueCursorBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final ValueCursorBlockStruct[] getValueCursorBlocks() {
        return this._cursorBlockStruct.valueCursorBlocks;
    }

    public final CompoundCursorBlockStruct getCompoundCursorBlock(int n) {
        if (this.isInitialized()) {
            return this._idToCompoundCursorBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final CompoundCursorBlockStruct[] getCompoundCursorBlocks() {
        return this._cursorBlockStruct.compoundCursorBlocks;
    }

    public final TxsOqDataBlockStruct getDataBlock(int n) {
        if (this.isInitialized()) {
            return this._idToDataBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final TxsOqDataBlockStruct[] getDataBlocks() {
        return this._cursorBlockStruct.dataBlocks;
    }

    public final TxsOqParentStartEndBlockUnion getParentStartBlock(int n) {
        if (this.isInitialized()) {
            return this._idToParentStartBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final TxsOqParentStartEndBlockUnion getParentEndBlock(int n) {
        if (this.isInitialized()) {
            return this._idToParentEndBlockTable[n];
        }
        throw new NoDataAvailableException();
    }

    public final DependencyBlockUnion[][] getDependencyGroups() {
        return this._cursorBlockStruct.dependencyGroups;
    }

    public final int getIdTableSize() {
        return this._idTableSize;
    }

    public final boolean isEmpty() {
        return this.getIdTableSize() == 0;
    }

    public final boolean matchesParameterValues(CursorTreeManager cursorTreeManager, Parameter[] parameterArray) {
        if (parameterArray == null && this._paramValues == null || parameterArray == null && 0 == this._paramValues.length) {
            return true;
        }
        if (parameterArray.length != this._paramValues.length) {
            return false;
        }
        try {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (CursorBlock.isEqual(cursorTreeManager, parameterArray[i], this._paramValues[i])) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    private static boolean isEqual(CursorTreeManager cursorTreeManager, Parameter parameter, TxsOqCursorValueUnion txsOqCursorValueUnion) {
        TxsOqDataUnion txsOqDataUnion = txsOqCursorValueUnion.literal();
        Object object = CursorTreeManager.getParameterValueObject(cursorTreeManager, parameter);
        switch (txsOqDataUnion.discriminator()) {
            case 0: {
                return ((Short)object).shortValue() == txsOqDataUnion.shortValue();
            }
            case 1: {
                return ((Integer)object).intValue() == txsOqDataUnion.longValue();
            }
            case 2: {
                return ((Long)object).longValue() == txsOqDataUnion.longlongValue();
            }
            case 3: {
                return ((Float)object).floatValue() == txsOqDataUnion.floatValue();
            }
            case 4: {
                return ((Double)object).doubleValue() == txsOqDataUnion.doubleValue();
            }
            case 5: {
                return (String)object == txsOqDataUnion.wstringValue();
            }
            case 6: {
                return ((Boolean)object).booleanValue() == txsOqDataUnion.booleanValue();
            }
            case 7: {
                return ((Date)object).getTime() == txsOqDataUnion.dateValue().getTime();
            }
        }
        return false;
    }

    private boolean isInitialized() {
        return this._initialized;
    }
}

