/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageSearchPanel
extends JPanel
implements ClassPackageView {
    private final JLabel searchLabel = new JLabel();
    private final JTextField searchTextField = new JTextField();
    private final JLabel classPkgLabel = new JLabel();
    private final ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private final JList classPkgList = new JList();
    private final JScrollPane scroller = new JScrollPane(this.classPkgList);
    private final DefaultListCellRenderer renderer = new ListDataItemCellRenderer();
    private final GridBagLayout mainLayout = new GridBagLayout();
    private boolean _multiSelect;
    private int _classPackageMode;
    private BrowseHandler _browseHandler;
    private JavaManager _javaManager;
    private final ClassPackageBrowserContext _browserContext;
    private String[] _selection;

    public ClassPackageSearchPanel(ClassPackageBrowserContext browseContext) {
        this._browserContext = browseContext;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void activateView() {
        String lookup;
        Object firstElement;
        if (this.classPkgList.getModel().getSize() == 1 && (BrowseHandler.PROGRESS_LIST_ITEM.equals((firstElement = this.classPkgList.getModel().getElementAt(0)).toString()) || BrowseHandler.EMPTY_LIST_ITEM.equals(firstElement.toString())) && (lookup = this.searchTextField.getText()).length() > 0) {
            this._browseHandler.doLookup(lookup);
        }
        this.enableControls();
    }

    @Override
    public String getTitle() {
        return DialogsArb.getString((int)18);
    }

    @Override
    public Component getComponent() {
        return this.searchTextField;
    }

    @Override
    public void setSelection(String singleSelection) {
        this.searchTextField.setText(singleSelection);
    }

    @Override
    public String getSelection() {
        String[] sels = this.getSelectedItems();
        return sels.length > 0 ? sels[0] : null;
    }

    @Override
    public void setSelectedItems(String[] multiSelection) {
        if (multiSelection != null && multiSelection.length > 0) {
            this.setSelection(multiSelection[0]);
        }
    }

    @Override
    public String[] getSelectedItems() {
        return this._selection != null ? this._selection : new String[]{};
    }

    @Override
    public void setJavaManager(JavaManager javaManager) {
        this._javaManager = javaManager;
    }

    @Override
    public void setClassAndPackageNameFilters(ClassNameFilter classFilter, PackageNameFilter pkgFilter) {
        if (this._javaManager != null) {
            switch (this._classPackageMode) {
                case 1: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)11));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)10));
                    this._browseHandler = BrowseHandler.createPackageBrowserList(this._javaManager, this.searchTextField, this.classPkgList, pkgFilter);
                    break;
                }
                case 2: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)6));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)5));
                    this._browseHandler = BrowseHandler.createClassBrowserList(this._javaManager, this.searchTextField, this.classPkgList, classFilter);
                    break;
                }
                default: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)17));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)16));
                    this._browseHandler = BrowseHandler.createClassPackageBrowserList(this._javaManager, this.searchTextField, this.classPkgList, classFilter, pkgFilter);
                }
            }
        }
    }

    @Override
    public void setFilter(ClassPackageBrowserFilterV2 filterV2) {
    }

    @Override
    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect != this._multiSelect) {
            this._multiSelect = isMultiSelect;
        }
        this.selectionModel.setSelectionMode(this._multiSelect ? 2 : 0);
    }

    @Override
    public void setMode(int classPackageMode) {
        this._classPackageMode = classPackageMode;
        switch (this._classPackageMode) {
            case 1: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)11));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)10));
                break;
            }
            case 2: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)6));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)5));
                break;
            }
            default: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)17));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)16));
            }
        }
    }

    @Override
    public void dispose() {
        if (this._browseHandler != null) {
            this._browseHandler.dispose();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString((int)17));
        ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString((int)16));
        InteractionHandler guiHandler = new InteractionHandler();
        this.classPkgList.addListSelectionListener(guiHandler);
        this.searchTextField.addFocusListener(guiHandler);
        this.searchTextField.addKeyListener(guiHandler);
        this.classPkgList.addMouseListener(guiHandler);
        this.selectionModel.setSelectionMode(0);
        this.classPkgList.setCellRenderer(this.renderer);
        this.setLayout(this.mainLayout);
        int y = -1;
        this.add((Component)this.searchLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.searchTextField, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.classPkgLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.scroller, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
    }

    private void enableControls() {
        Object selection = this.classPkgList.getSelectedValue();
        String text = selection != null ? selection.toString() : null;
        this._browserContext.enableControls(selection != null && !BrowseHandler.EMPTY_LIST_ITEM.equals(text) && !BrowseHandler.PROGRESS_LIST_ITEM.equals(text));
    }

    static /* synthetic */ String[] access$402(ClassPackageSearchPanel x0, String[] x1) {
        x0._selection = x1;
        return x1;
    }

    private final class InteractionHandler
    implements FocusListener,
    KeyListener,
    ListSelectionListener,
    MouseListener {
        private InteractionHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() != ClassPackageSearchPanel.this.searchTextField) {
                return;
            }
            int len = ClassPackageSearchPanel.this.searchTextField.getText().length();
            ClassPackageSearchPanel.this.searchTextField.setSelectionStart(0);
            ClassPackageSearchPanel.this.searchTextField.setSelectionEnd(len);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ClassPackageSearchPanel.this.enableControls();
                Object[] selection = ClassPackageSearchPanel.this.classPkgList.getSelectedValues();
                if (selection.length == 0) {
                    ClassPackageSearchPanel.access$402(ClassPackageSearchPanel.this, new String[0]);
                } else {
                    ArrayList<String> resultList = new ArrayList<String>();
                    for (Object item : selection) {
                        if (BrowseHandler.EMPTY_LIST_ITEM.equals(item.toString()) || BrowseHandler.PROGRESS_LIST_ITEM.equals(item.toString())) continue;
                        resultList.add(item.toString());
                    }
                    String[] results = new String[resultList.size()];
                    ClassPackageSearchPanel.access$402(ClassPackageSearchPanel.this, resultList.toArray(results));
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int index;
            int keyCode = e.getKeyCode();
            if (40 == keyCode) {
                int index2 = ClassPackageSearchPanel.this.classPkgList.getSelectedIndex();
                if (index2 < ClassPackageSearchPanel.this.classPkgList.getModel().getSize() - 1) {
                    ClassPackageSearchPanel.this.classPkgList.setSelectedIndex(index2 + 1);
                }
            } else if (38 == keyCode && (index = ClassPackageSearchPanel.this.classPkgList.getSelectedIndex()) > 0) {
                ClassPackageSearchPanel.this.classPkgList.setSelectedIndex(index - 1);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int clicks = e.getClickCount();
            int index = ClassPackageSearchPanel.this.classPkgList.getSelectedIndex();
            if (clicks == 2 && index != -1) {
                Object selection;
                if (index == 0 && (BrowseHandler.EMPTY_LIST_ITEM.equals((selection = ClassPackageSearchPanel.this.classPkgList.getSelectedValue()).toString()) || BrowseHandler.PROGRESS_LIST_ITEM.equals(selection.toString()))) {
                    return;
                }
                ClassPackageSearchPanel.this._browserContext.classPackageSelected();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

