/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.deploy.redshift;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.dataload.DwcsSQLQueryExecution;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.jdbc.OracleCallableStatement;

public class DeployMetadataObjects {
    private static final boolean DEBUG = false;
    private Logger deployMetadataObjectsLogger = Logger.getLogger(DeployMetadataObjects.class.getName());
    private String[] m_deployableSchemas = null;
    private String[] m_selectedCommentScriptsCommands = null;
    private Connection m_targetConnection = null;
    private String[] m_sqlScriptsCommands;
    private String[] m_selectedSqlScriptsCommands;
    private String[] m_commentScriptsCommands;
    private String m_sqlScriptDirectory = null;
    private boolean m_startDeployment = false;
    ArrayList<String> m_allDefaultStrings = new ArrayList();
    ArrayList<String> m_selectedDefaultStrings = new ArrayList();
    String allObjectsScript = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_all_objects_scripts}";
    String selectedObjectsScript = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_selected_objects_scripts ( ? )}";
    String allDefaultsScript = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_all_default_objects_scripts}";
    String selectedDefaultsScript = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_selected_default_objects_scripts ( ? )}";
    String allCommentsScript = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_all_comment_scripts}";
    String selectedeCommentsScript = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_DEPLOY.get_selected_comment_scripts ( ? )}";

    public DeployMetadataObjects(Connection connection, String string, boolean bl, String[] stringArray) {
        this.m_targetConnection = connection;
        this.m_sqlScriptDirectory = string;
        this.m_startDeployment = bl;
        this.m_deployableSchemas = stringArray;
        if (this.m_deployableSchemas.length == 0) {
            this.m_startDeployment = false;
        }
    }

    public void deployMetadataObjectsToTarget(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws IOException, SQLException, ExecutionException, Exception {
        this.traceFlow("Start deployMetadataObjectsToTarget ...");
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_sqlScriptsCommands = this.getAllSqlScripts(this.allObjectsScript);
        this.m_allDefaultStrings = this.getDefaultSqlScripts(this.getAllSqlScripts(this.allDefaultsScript));
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_commentScriptsCommands = this.getAllSqlScripts(this.allCommentsScript);
        if (this.m_sqlScriptDirectory != null) {
            this.writeReadmeTextFile();
            this.writeDDLScript();
        }
        backendDelegatorRaptorTask.checkCanProceed();
        String string = this.convertDeployableSchemasToCommaSeparatedString(this.m_deployableSchemas);
        if (string != null && string.length() > 0) {
            this.m_selectedSqlScriptsCommands = this.getSelectedObjectsScript(string, this.selectedObjectsScript);
            backendDelegatorRaptorTask.checkCanProceed();
            this.m_selectedDefaultStrings = this.getDefaultSqlScripts(this.getSelectedObjectsScript(string, this.selectedDefaultsScript));
            backendDelegatorRaptorTask.checkCanProceed();
            this.m_selectedCommentScriptsCommands = this.getSelectedObjectsScript(string, this.selectedeCommentsScript);
            if (this.m_startDeployment) {
                int n;
                for (n = 0; n < this.m_selectedSqlScriptsCommands.length; ++n) {
                    backendDelegatorRaptorTask.checkCanProceed();
                    this.runSQLScriptOnTarget(this.m_selectedSqlScriptsCommands[n]);
                }
                for (n = 0; n < this.m_allDefaultStrings.size(); ++n) {
                    this.runSQLUpdateOnTarget(this.m_allDefaultStrings.get(n));
                }
                for (n = 0; n < this.m_selectedCommentScriptsCommands.length; ++n) {
                    backendDelegatorRaptorTask.checkCanProceed();
                    String string2 = this.m_selectedCommentScriptsCommands[n].trim();
                    this.runSQLOnTarget(string2);
                }
            }
        }
        this.traceFlow("End deployMetadataObjectsToTarget ...");
    }

    private ArrayList<String> getDefaultSqlScripts(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(Pattern.quote(" ;"));
            for (int j = 0; j < stringArray2.length; ++j) {
                String string = stringArray2[j].trim();
                if (string.equals("")) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAllSqlScripts(String string) throws SQLException {
        this.traceFlow("Start getAllSqlScripts ...");
        String[] stringArray = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall(string);
            oracleCallableStatement.registerOutParameter(1, 2003, "sqldev_migrepos".toUpperCase() + ".DATA_SCRIPT");
            oracleCallableStatement.executeUpdate();
            stringArray = (String[])oracleCallableStatement.getARRAY(1).getArray();
        }
        this.traceFlow("end getAllSqlScripts ...");
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSelectedObjectsScript(String string, String string2) throws SQLException {
        this.traceFlow("Start getSelectedObjectsScripts ...");
        String[] stringArray = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall(string2);
            oracleCallableStatement.registerOutParameter(1, 2003, "sqldev_migrepos".toUpperCase() + ".DATA_SCRIPT");
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.executeUpdate();
            stringArray = (String[])oracleCallableStatement.getARRAY(1).getArray();
        }
        this.traceFlow("end getSelectedObjectsScripts ...");
        return stringArray;
    }

    private void runSQLScriptOnTarget(String string) throws SQLException {
        this.traceFlow("Start runSQLScriptOnTarget ...");
        DwcsSQLQueryExecution.executeSQLQuery(string, this.getTargetConnection());
        this.traceFlow("end runSQLScriptOnTarget ...");
    }

    private void runSQLOnTarget(String string) throws SQLException {
        this.traceFlow("Start runSQLOnTarget ...");
        DwcsSQLQueryExecution.executeSQL(string, this.getTargetConnection());
        this.traceFlow("end runSQLOnTarget ...");
    }

    private void runSQLUpdateOnTarget(String string) throws SQLException {
        this.traceFlow("Start runSQLUpdateOnTarget ...");
        DwcsSQLQueryExecution.executeUpdateSQL(string, this.getTargetConnection());
        this.traceFlow("end runSQLUpdateOnTarget ...");
    }

    public void writeReadmeTextFile() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.m_sqlScriptDirectory + File.separator + "readme.txt"));
        printWriter.write(Utilities.nls("REDSHIFT_ADWC_MIGRATION_README_TXT") + MigrationUtilities.getLineSeparator());
        printWriter.close();
    }

    public void writeDDLScript() throws IOException {
        int n;
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.m_sqlScriptDirectory + File.separator + "ddl" + File.separator + "adwc_ddl.sql"));
        String string = "-- This is a generated SQL Script file 'adwc_ddl.sql' " + MigrationUtilities.getLineSeparator() + "-- Run this SQL Script in SQLDeveloper Worksheet using ADWC admin user to generate all database objects." + MigrationUtilities.getLineSeparator() + "-- Please read 'readme.txt' file for more details." + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator();
        String string2 = MigrationUtilities.getLineSeparator() + "-- This is generated defaults code on table objects" + MigrationUtilities.getLineSeparator();
        String string3 = MigrationUtilities.getLineSeparator() + "-- This is generated comments code on database objects" + MigrationUtilities.getLineSeparator();
        printWriter.write(string);
        printWriter.write("SET ECHO ON" + MigrationUtilities.getLineSeparator());
        printWriter.write("SET VERIFY OFF" + MigrationUtilities.getLineSeparator());
        printWriter.write("SET FEEDBACK ON" + MigrationUtilities.getLineSeparator());
        printWriter.write("SET CLASSIC OFF" + MigrationUtilities.getLineSeparator());
        printWriter.write("set serveroutput on" + MigrationUtilities.getLineSeparator());
        printWriter.write("spool output.log" + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        for (n = 0; n < this.m_sqlScriptsCommands.length; ++n) {
            printWriter.write(this.m_sqlScriptsCommands[n] + ";" + MigrationUtilities.getLineSeparator());
        }
        if (this.m_allDefaultStrings.size() > 0) {
            printWriter.write(string2);
        }
        for (n = 0; n < this.m_allDefaultStrings.size(); ++n) {
            printWriter.write(this.m_allDefaultStrings.get(n) + ";" + MigrationUtilities.getLineSeparator());
        }
        if (this.m_commentScriptsCommands.length > 0) {
            printWriter.write(string3);
        }
        for (n = 0; n < this.m_commentScriptsCommands.length; ++n) {
            printWriter.write(this.m_commentScriptsCommands[n] + ";" + MigrationUtilities.getLineSeparator());
        }
        printWriter.write(MigrationUtilities.getLineSeparator() + "spool off" + MigrationUtilities.getLineSeparator());
        printWriter.close();
    }

    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    private String convertDeployableSchemasToCommaSeparatedString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return Utilities.convertToCommaSeparatedString(stringArray);
    }

    private void traceFlow(String string) {
    }
}

