/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.extender.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderData;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderEvaluator;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderThread;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerThread;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.extender.evaluator.CustomDataProvider;
import oracle.jdevimpl.debugger.extender.evaluator.DebuggeeDataInfo;
import oracle.jdevimpl.debugger.extender.evaluator.ExtenderEvaluatorContext;
import oracle.jdevimpl.debugger.extender.evaluator.ThreadHandle;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

public class EvaluatorHandle {
    protected boolean expired;
    protected EvaluatorProxy evaluator;
    protected DebuggingProcess debuggingProcess;
    protected CustomDataProvider customDataProvider;
    protected ExtenderEvaluatorContext context;

    private EvaluatorHandle() {
    }

    public static EvaluatorHandleVersion12 createEvaluatorHandleVersion12(EvaluatorProxy evaluator, DebuggingProcess debuggingProcess, CustomDataProvider customDataProvider) {
        EvaluatorHandle evaluatorHandle = new EvaluatorHandle();
        evaluatorHandle.getClass();
        return evaluatorHandle.new EvaluatorHandleVersion12(evaluator, debuggingProcess, customDataProvider);
    }

    public static EvaluatorHandleVersion13 createEvaluatorHandleVersion13(EvaluatorProxy evaluator, DebuggingProcess debuggingProcess, CustomDataProvider customDataProvider) {
        EvaluatorHandle evaluatorHandle = new EvaluatorHandle();
        evaluatorHandle.getClass();
        return evaluatorHandle.new EvaluatorHandleVersion13(evaluator, debuggingProcess, customDataProvider);
    }

    public synchronized void expire() {
        this.expired = true;
        this.debuggingProcess = null;
        this.evaluator = null;
        this.context = null;
        this.customDataProvider = null;
    }

    public synchronized boolean hasExpired() {
        return this.expired;
    }

    public synchronized Context getContext() {
        if (!this.expired) {
            return this.debuggingProcess.getContext();
        }
        return null;
    }

    public synchronized int getStackFrame() {
        if (!this.expired && this.evaluator.getEvaluatorContext().getFrame() != null) {
            return this.evaluator.getEvaluatorContext().getFrame().getFrameNumber();
        }
        return -1;
    }

    public synchronized int getStackFrameCount() {
        int size;
        if (!this.expired && (size = this.getDebugStackFrameInfos().size()) > 0) {
            return size;
        }
        return -1;
    }

    public synchronized ExtenderEvaluatorContext getEvaluatorContext() {
        if (!this.expired) {
            if (this.context == null) {
                this.context = new ExtenderEvaluatorContext(this.evaluator.getEvaluatorContext());
            }
            return this.context;
        }
        return null;
    }

    protected DebugThreadInfo[] getDebugThreadInfos() {
        EvaluatorProxy currentEvaluator;
        if (!this.expired && (currentEvaluator = this.evaluator) != null && currentEvaluator.getEvaluatorContext().getVM() != null) {
            return currentEvaluator.getEvaluatorContext().getVM().listThreads();
        }
        return new DebugThreadInfo[0];
    }

    protected CustomDataProvider getCustomDataProvider() {
        return this.customDataProvider;
    }

    protected List<DebugStackFrameInfo> getDebugStackFrameInfos() {
        DebugThreadInfo thread;
        EvaluatorProxy currentEvaluator;
        if (!this.expired && (currentEvaluator = this.evaluator) != null && currentEvaluator.getEvaluatorContext().getVM() != null && (thread = currentEvaluator.getEvaluatorContext().getVM().getCurrentThread()) != null) {
            int count = thread.getStackFrameCount();
            ArrayList<DebugStackFrameInfo> frameList = new ArrayList<DebugStackFrameInfo>(count);
            for (int i = 0; i < count; ++i) {
                frameList.add(thread.getStackFrame(i));
            }
            return frameList;
        }
        return Collections.emptyList();
    }

    public class EvaluatorHandleVersion12
    extends EvaluatorHandle
    implements DebuggerEvaluator {
        private EvaluatorHandleVersion12(EvaluatorProxy evaluator, DebuggingProcess debuggingProcess, CustomDataProvider customDataProvider) {
            this.evaluator = evaluator;
            this.debuggingProcess = debuggingProcess;
            this.customDataProvider = customDataProvider;
            debuggingProcess.registerEvaluatorHandle(this);
        }

        public synchronized DebuggerThread getThread() {
            if (!this.expired && this.evaluator.getEvaluatorContext().getThread() != null) {
                return (DebuggerThread)new ThreadHandle(this.evaluator.getEvaluatorContext().getThread().getName());
            }
            return null;
        }

        public synchronized DebuggeeData evaluate(String expression, DebuggeeData context) {
            ArrayList<String> expressions = new ArrayList<String>(1);
            expressions.add(expression);
            List<DebuggeeData> result = this.evaluate(expressions, context);
            return result == null ? null : result.get(0);
        }

        public synchronized List<DebuggeeData> evaluate(List<String> expressions, DebuggeeData context) {
            CustomDataProvider customDataProvider = this.getCustomDataProvider();
            if (customDataProvider == null) {
                System.out.println("null custom data provider - debug this.");
                return null;
            }
            if (!this.expired) {
                Object info;
                if (JDebugger.logger.isEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Strings to evaluate:\n");
                    for (String expression : expressions) {
                        buf.append(expression);
                        buf.append('\n');
                    }
                    JDebugger.logger.trace(buf.toString());
                }
                long milliTime = System.currentTimeMillis();
                DebugThreadInfo thread = this.evaluator.getEvaluatorContext().getThread();
                DebugStackFrameInfo frame = this.evaluator.getEvaluatorContext().getFrame();
                DebuggeeDataInfo.DebuggeeDataInfoVersion12 parent = null;
                boolean restoreContext = false;
                if (context instanceof DebuggeeDataInfo.DebuggeeDataInfoVersion12 && (info = ((DebuggeeDataInfo)context).getDataInfo()) instanceof DebugDataObjectInfo) {
                    this.evaluator.setDebugContext((DebugDataObjectInfo)info);
                    restoreContext = true;
                    parent = (DebuggeeDataInfo.DebuggeeDataInfoVersion12)context;
                }
                ArrayList<DebuggeeData> results = new ArrayList<DebuggeeData>();
                for (String expression : expressions) {
                    Object value = this.evaluator.evaluate(expression);
                    if (value != null) {
                        String expressionOverride = parent == null ? expression : "." + expression;
                        DataItem dataItem = customDataProvider.makeDataItem(value, expressionOverride);
                        results.add((DebuggeeData)DebuggeeDataInfo.createDebuggeeDataInfoVersion12(parent, dataItem, this, customDataProvider));
                        continue;
                    }
                    results.add(null);
                }
                if (restoreContext) {
                    this.evaluator.setDebugContext(this.evaluator.getEvaluatorContext().getVM(), thread, frame);
                }
                if (JDebugger.logger.isEnabled()) {
                    long totalTime = System.currentTimeMillis() - milliTime;
                    StringBuilder buf = new StringBuilder();
                    buf.append("Debugger Extender Evaluation in ");
                    buf.append(totalTime);
                    buf.append(" msecs\n");
                    JDebugger.logger.trace(buf.toString());
                }
                return results;
            }
            return null;
        }

        public synchronized DebuggerEvaluator getEvaluator(int stackFrame) {
            List<DebugStackFrameInfo> stackFrames;
            if (!this.expired && stackFrame < (stackFrames = this.getDebugStackFrameInfos()).size()) {
                EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                newEvaluator.setAllowMethodInvocation(true);
                newEvaluator.setDebugContext(this.evaluator.getEvaluatorContext().getVM(), this.evaluator.getEvaluatorContext().getThread(), stackFrames.get(stackFrame));
                return EvaluatorHandleVersion12.createEvaluatorHandleVersion12(newEvaluator, this.debuggingProcess, this.customDataProvider);
            }
            return null;
        }

        public synchronized DebuggerEvaluator getEvaluator(DebuggerThread thread) {
            if (!this.expired) {
                DebugThreadInfo[] currentThreads = this.getDebugThreadInfos();
                DebugThreadInfo found = null;
                for (DebugThreadInfo currentThread : currentThreads) {
                    if (!thread.getName().equals(currentThread.getName())) continue;
                    found = currentThread;
                    break;
                }
                if (found != null) {
                    EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                    newEvaluator.setAllowMethodInvocation(true);
                    newEvaluator.setDebugContext(this.evaluator.getEvaluatorContext().getVM(), found, this.evaluator.getEvaluatorContext().getFrame());
                    return EvaluatorHandleVersion12.createEvaluatorHandleVersion12(newEvaluator, this.debuggingProcess, this.customDataProvider);
                }
            }
            return null;
        }

        public synchronized List<DebuggerThread> getAllThreads() {
            if (!this.expired && this.evaluator.getEvaluatorContext().getVM() != null) {
                DebugThreadInfo[] threads = this.evaluator.getEvaluatorContext().getVM().listThreads();
                ArrayList<DebuggerThread> threadList = new ArrayList<DebuggerThread>(threads.length);
                for (DebugThreadInfo thread : threads) {
                    String name = thread.getName();
                    if (name.length() <= 0) continue;
                    threadList.add((DebuggerThread)new ThreadHandle(name));
                }
                return threadList;
            }
            return null;
        }
    }

    public class EvaluatorHandleVersion13
    extends EvaluatorHandle
    implements DebuggerExtenderEvaluator {
        private EvaluatorHandleVersion13(EvaluatorProxy evaluator, DebuggingProcess debuggingProcess, CustomDataProvider customDataProvider) {
            this.evaluator = evaluator;
            this.debuggingProcess = debuggingProcess;
            this.customDataProvider = customDataProvider;
            debuggingProcess.registerEvaluatorHandle(this);
        }

        public synchronized DebuggerExtenderThread getThread() {
            if (!this.expired && this.evaluator.getEvaluatorContext().getThread() != null) {
                return (DebuggerExtenderThread)new ThreadHandle(this.evaluator.getEvaluatorContext().getThread().getName());
            }
            return null;
        }

        public synchronized DebuggerExtenderData evaluate(String expression, DebuggerExtenderData context) {
            ArrayList<String> expressions = new ArrayList<String>(1);
            expressions.add(expression);
            List<DebuggerExtenderData> result = this.evaluate(expressions, context);
            return result == null ? null : result.get(0);
        }

        public synchronized List<DebuggerExtenderData> evaluate(List<String> expressions, DebuggerExtenderData context) {
            CustomDataProvider customDataProvider = this.getCustomDataProvider();
            if (!this.expired) {
                Object info;
                if (JDebugger.logger.isEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Strings to evaluate:\n");
                    for (String expression : expressions) {
                        buf.append(expression);
                        buf.append('\n');
                    }
                    JDebugger.logger.trace(buf.toString());
                }
                long milliTime = System.currentTimeMillis();
                DebugThreadInfo thread = this.evaluator.getEvaluatorContext().getThread();
                DebugStackFrameInfo frame = this.evaluator.getEvaluatorContext().getFrame();
                DebuggeeDataInfo.DebuggeeDataInfoVersion13 parent = null;
                boolean restoreContext = false;
                if (context instanceof DebuggeeDataInfo.DebuggeeDataInfoVersion13 && (info = ((DebuggeeDataInfo)context).getDataInfo()) instanceof DebugDataObjectInfo) {
                    this.evaluator.setDebugContext((DebugDataObjectInfo)info);
                    restoreContext = true;
                    parent = (DebuggeeDataInfo.DebuggeeDataInfoVersion13)context;
                }
                ArrayList<DebuggerExtenderData> results = new ArrayList<DebuggerExtenderData>();
                for (String expression : expressions) {
                    Object value = this.evaluator.evaluate(expression);
                    if (value != null) {
                        String expressionOverride = parent == null ? expression : "." + expression;
                        DataItem dataItem = customDataProvider.makeDataItem(value, expressionOverride);
                        results.add(DebuggeeDataInfo.createDebuggeeDataInfoVersion13(parent, dataItem, this, customDataProvider));
                        continue;
                    }
                    results.add(null);
                }
                if (restoreContext) {
                    this.evaluator.setDebugContext(this.evaluator.getEvaluatorContext().getVM(), thread, frame);
                }
                if (JDebugger.logger.isEnabled()) {
                    long totalTime = System.currentTimeMillis() - milliTime;
                    StringBuilder buf = new StringBuilder();
                    buf.append("Debugger Extender Evaluation in ");
                    buf.append(totalTime);
                    buf.append(" msecs\n");
                    JDebugger.logger.trace(buf.toString());
                }
                return results;
            }
            return null;
        }

        public synchronized DebuggerExtenderEvaluator getEvaluator(int stackFrame) {
            List<DebugStackFrameInfo> stackFrames;
            if (!this.expired && stackFrame < (stackFrames = this.getDebugStackFrameInfos()).size()) {
                EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                newEvaluator.setAllowMethodInvocation(true);
                newEvaluator.setDebugContext(this.evaluator.getEvaluatorContext().getVM(), this.evaluator.getEvaluatorContext().getThread(), stackFrames.get(stackFrame));
                return EvaluatorHandleVersion13.createEvaluatorHandleVersion13(newEvaluator, this.debuggingProcess, this.customDataProvider);
            }
            return null;
        }

        public synchronized DebuggerExtenderEvaluator getEvaluator(DebuggerExtenderThread thread) {
            if (!this.expired) {
                DebugThreadInfo[] currentThreads = this.getDebugThreadInfos();
                DebugThreadInfo found = null;
                for (DebugThreadInfo currentThread : currentThreads) {
                    if (!thread.getName().equals(currentThread.getName())) continue;
                    found = currentThread;
                    break;
                }
                if (found != null) {
                    EvaluatorProxy newEvaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                    newEvaluator.setAllowMethodInvocation(true);
                    newEvaluator.setDebugContext(this.evaluator.getEvaluatorContext().getVM(), found, this.evaluator.getEvaluatorContext().getFrame());
                    return EvaluatorHandleVersion13.createEvaluatorHandleVersion13(newEvaluator, this.debuggingProcess, this.customDataProvider);
                }
            }
            return null;
        }

        public synchronized List<DebuggerExtenderThread> getAllThreads() {
            if (!this.expired && this.evaluator.getEvaluatorContext().getVM() != null) {
                DebugThreadInfo[] threads = this.evaluator.getEvaluatorContext().getVM().listThreads();
                ArrayList<DebuggerExtenderThread> threadList = new ArrayList<DebuggerExtenderThread>(threads.length);
                for (DebugThreadInfo thread : threads) {
                    String name = thread.getName();
                    if (name.length() <= 0) continue;
                    threadList.add((DebuggerExtenderThread)new ThreadHandle(name));
                }
                return threadList;
            }
            return null;
        }
    }
}

