/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.OpaqueClientData;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Message
extends XMLElement {
    protected Message(Element element) throws DOMException {
        super(element);
    }

    protected Message(Document owner, String tagName) throws DOMException {
        this(owner, tagName, null);
    }

    protected Message(Document owner, String tagName, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", tagName, systemId);
        this.addNSPrefixAttr(XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2002/03/xkms#"), "http://www.w3.org/2002/03/xkms#");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2002/03/xkms#");
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
        this.clearSignature();
    }

    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void setService(String service) throws DOMException {
        this.setAttribute("Service", service);
        this.clearSignature();
    }

    public String getService() {
        if (this.hasAttribute("Service")) {
            return this.getAttribute("Service");
        }
        return null;
    }

    public void setNonce(byte[] nonce) throws DOMException {
        this.setAttribute("Nonce", Base64.toBase64((byte[])nonce, (boolean)false));
        this.clearSignature();
    }

    public byte[] getNonce() {
        if (this.hasAttribute("Nonce")) {
            return Base64.fromBase64((String)this.getAttribute("Nonce"));
        }
        return null;
    }

    public XSSignature setSignature(String signatureMethod, String c14nMethod, String digestMethod) throws DOMException {
        this.clearSignature();
        XSSignature s = XSSignature.newInstance((Document)this.getOwnerDocument(), null);
        XSSignedInfo si = s.createSignedInfo(c14nMethod, signatureMethod, null);
        s.setSignedInfo(si);
        String refId = "";
        if (this.getId() != null && this.getId().length() > 0) {
            refId = "#" + this.getId();
        }
        XSReference r = s.createReference(null, refId, null, digestMethod);
        si.addReference(r);
        if (refId.equals("")) {
            String tag;
            String pref = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2002/03/xkms#");
            if (pref == null) {
                pref = "xkms";
            }
            if ((tag = this.getLocalName()) == null) {
                tag = this.getTagName();
            }
            String qname = pref + ":" + tag;
            String xpath = "count(ancestor-or-self::" + qname + " | here()/ancestor::" + qname + "[1]) = count(ancestor-or-self::" + qname + ")";
            XSAlgorithmIdentifier xpt = s.createXPathTransform(pref, "http://www.w3.org/2002/03/xkms#", xpath);
            r.addTransform(xpt);
        }
        r.addTransform(s.createTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature"));
        r.addTransform(s.createTransform(c14nMethod));
        Element root = this.getOwnerDocument().getDocumentElement();
        Node f = root.getFirstChild();
        if (f == null) {
            root.appendChild(s.getNode());
        } else {
            root.insertBefore(s.getNode(), f);
        }
        return s;
    }

    public XSSignature getSignature() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nList.getLength() != 0) {
            return new XSSignature((Element)nList.item(0));
        }
        return null;
    }

    public void addMessageExtension(Element msgExtension) throws DOMException {
        Element meElement = null;
        try {
            byte[] meBytes = new XMLC14NWithComments().canonicalize((Node)msgExtension);
            Document meDoc = XMLUtils.createDocBuilder().parse(new ByteArrayInputStream(meBytes));
            meElement = meDoc.getDocumentElement();
        }
        catch (CanonicalizationException ex) {
            throw new DOMException(11, "Error canonicalizing xkms:MessageExtension");
        }
        catch (IOException ex) {
            throw new DOMException(11, "Error reading xkms:MessageExtension");
        }
        catch (SAXException ex) {
            throw new DOMException(11, "Error reading xkms:Request");
        }
        Element msgExt = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "MessageExtension");
        Element ext = (Element)this.getOwnerDocument().importNode(meElement, true);
        msgExt.appendChild(ext);
        this.insertChild(msgExt, new String[]{"Signature", "MessageExtension"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public NodeList getMessageExtensions() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "MessageExtension");
        if (nList.getLength() != 0) {
            return nList;
        }
        return null;
    }

    public void setOpaqueClientData(OpaqueClientData opdata) throws DOMException {
        this.removeChildren("http://www.w3.org/2002/03/xkms#", "OpaqueClientData");
        Element ocd = (Element)this.getOwnerDocument().importNode(opdata.getNode(), true);
        this.insertChild(ocd, new String[]{"Signature", "MessageExtension"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public OpaqueClientData getOpaqueClientData() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "OpaqueClientData");
        if (nList.getLength() != 0) {
            return new OpaqueClientData((Element)nList.item(0));
        }
        return null;
    }

    public void clearSignature() {
        this.removeChildren("Signature", "http://www.w3.org/2000/09/xmldsig#");
    }

    protected void insertChild(XMLElement e, String[] tag, String[] ns) throws DOMException {
        this.insertChild((Element)e.getNode(), tag, ns);
    }

    protected void insertChild(Element e, String[] tag, String[] ns) throws DOMException {
        Node after = null;
        if (tag != null && ns != null) {
            if (tag.length != ns.length) {
                throw new IllegalArgumentException("Tag list and namespace list must correspond");
            }
            for (int i = tag.length - 1; i >= 0 && after == null; --i) {
                NodeList nList = this.getChildElementsByTagNameNS(ns[i], tag[i]);
                if (nList.getLength() <= 0) continue;
                after = nList.item(nList.getLength() - 1);
            }
        } else if (tag == null ^ ns == null) {
            throw new IllegalArgumentException("Tag list and namespace list must correspond");
        }
        Node before = null;
        before = after != null ? after.getNextSibling() : this.getFirstChild();
        if (before != null) {
            this.insertBefore(e, before);
        } else {
            this.appendChild(e);
        }
    }

    protected void removeChildren(String tag, String ns) {
        NodeList nList = this.getChildElementsByTagNameNS(ns, tag);
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
    }

    static {
        XKMSInitializer.initialize();
    }
}

