/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import oracle.security.xmlsec.xkms.util.XKMSUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSAKeyPair
extends XMLElement {
    public RSAKeyPair(Element element) throws DOMException {
        super(element);
    }

    public RSAKeyPair(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public RSAKeyPair(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "RSAKeyPair");
    }

    public RSAKeyPair(Document owner, KeyPair rsaKeyPair) throws DOMException {
        this(owner, (RSAPrivateCrtKey)rsaKeyPair.getPrivate(), (RSAPublicKey)rsaKeyPair.getPublic());
    }

    public RSAKeyPair(Document owner, RSAPrivateCrtKey privKey, RSAPublicKey pubKey) throws DOMException {
        this(owner);
        this.setModulus(pubKey.getModulus());
        this.setExponent(pubKey.getPublicExponent());
        this.setP(privKey.getPrimeP());
        this.setQ(privKey.getPrimeQ());
        this.setDP(privKey.getPrimeExponentP());
        this.setDQ(privKey.getPrimeExponentQ());
        this.setInverseQ(privKey.getCrtCoefficient());
        this.setD(privKey.getPrivateExponent());
    }

    public void setModulus(BigInteger modulus) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "Modulus");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        Element m = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "Modulus");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)m);
        m.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)modulus), (boolean)false)));
        nList = this.getChildNodes();
        if (nList.getLength() != 0) {
            this.insertBefore(m, nList.item(0));
        } else {
            this.appendChild(m);
        }
    }

    public BigInteger getModulus() {
        String mString;
        BigInteger modulus = null;
        NodeList mList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "Modulus");
        if (mList.getLength() != 0 && (mString = XMLUtils.collectText((Node)mList.item(0))).length() != 0) {
            modulus = new BigInteger(1, Base64.fromBase64((String)mString));
        }
        return modulus;
    }

    public void setExponent(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "Exponent", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "Exponent");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), e, new String[]{"Modulus"}, new String[]{"http://www.w3.org/2002/03/xkms#"});
    }

    public BigInteger getExponent() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "Exponent");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public void setP(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "P", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "P");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), e, new String[]{"Modulus", "Exponent"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public BigInteger getP() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "P");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public void setQ(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "Q", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "Q");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), e, new String[]{"Modulus", "Exponent", "P"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public BigInteger getQ() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "Q");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public void setDP(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "DP", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "DP");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), e, new String[]{"Modulus", "Exponent", "P", "Q"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public BigInteger getDP() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "DP");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public void setDQ(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "DQ", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "DQ");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), e, new String[]{"Modulus", "Exponent", "P", "Q", "DP"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public BigInteger getDQ() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "DQ");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public void setInverseQ(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "InverseQ", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "InverseQ");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        XKMSUtils.insertChild((Element)this.getNode(), e, new String[]{"Modulus", "Exponent", "P", "Q", "DP", "DQ"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public BigInteger getInverseQ() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "InverseQ");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public void setD(BigInteger exponent) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "D", "http://www.w3.org/2002/03/xkms#");
        Element e = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "D");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)e);
        e.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])Utils.toByteArray((BigInteger)exponent), (boolean)false)));
        this.appendChild(e);
    }

    public BigInteger getD() {
        String eString;
        BigInteger exponent = null;
        NodeList eList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "D");
        if (eList.getLength() != 0 && (eString = XMLUtils.collectText((Node)eList.item(0))).length() != 0) {
            exponent = new BigInteger(1, Base64.fromBase64((String)eString));
        }
        return exponent;
    }

    public PrivateKey getPrivateKey() throws InvalidKeySpecException, NoSuchAlgorithmException {
        RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(this.getModulus(), this.getExponent(), this.getD(), this.getP(), this.getQ(), this.getDP(), this.getDQ(), this.getInverseQ());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey key = kf.generatePrivate(spec);
        return key;
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(this.getModulus(), this.getExponent());
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey key = kf.generatePublic(spec);
        return key;
    }

    public String getType() {
        return "http://www.w3.org/2002/03/xkms##RSAKeyPair";
    }

    static {
        XKMSInitializer.initialize();
    }
}

