/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;

public class ClusterComponentTableModel
extends ODMrTableModel<ClusterComponentModelRow> {
    private static final String[] columns = new String[]{ComponentLrb.get("DETAIL_TABLE_COLUMN_NAME"), ComponentLrb.get("DETAIL_TABLE_COLUMN_DISTRIBUTION"), ComponentLrb.get("DETAIL_TABLE_COLUMN_MEAN"), ComponentLrb.get("DETAIL_TABLE_COLUMN_VARIANCE")};
    public static final int _COLUMN_NAME = 0;
    public static final int _COLUMN_DISTRIBUTION = 1;
    public static final int _COLUMN_MEAN = 2;
    public static final int _COLUMN_VARIANCE = 3;

    public ClusterComponentTableModel(List<ClusterComponentModelRow> list) {
        super(columns, list);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        ClusterComponentModelRow clusterComponentModelRow = (ClusterComponentModelRow)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = clusterComponentModelRow.getAttributeName();
                break;
            }
            case 2: {
                if (null == clusterComponentModelRow.getMeanValue()) break;
                object = clusterComponentModelRow.getMeanValue();
                break;
            }
            case 3: {
                if (null == clusterComponentModelRow.getCovarianceValue()) break;
                object = clusterComponentModelRow.getCovarianceValue();
                break;
            }
            case 1: {
                object = clusterComponentModelRow.getGraphDataModel();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing cluster details";
                break;
            }
        }
        return object != null ? object : "";
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return NumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    public static String[] getColNames() {
        return columns;
    }

    public static String getColName(int n) {
        return columns[n];
    }
}

