/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.fe.svd.SVDCoefficient;
import oracle.dmt.dataminer.core.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;

public class SVDCoefViewerTableModel
extends ODMrTableModel<SVDCoefficient> {
    private static final String[] COLUMN_NAMES = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN")};
    public static final int ATTRIBUTE = 0;
    public static final int COEFFICIENT = 1;
    private boolean absoluteSort;

    public SVDCoefViewerTableModel() {
        super(COLUMN_NAMES);
    }

    public SVDCoefViewerTableModel(List<SVDCoefficient> list) {
        super(COLUMN_NAMES, list);
    }

    public Comparator getColumnSortComparator(int n) {
        if (n == 1) {
            return this.absoluteSort ? AbsoluteNumberComparator.getComparator() : NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        SVDCoefficient sVDCoefficient = (SVDCoefficient)this.srcData.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = sVDCoefficient.getAttributeFullName();
                break;
            }
            case 1: {
                object = sVDCoefficient.getSingularValue();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "" : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this.absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this.absoluteSort;
    }
}

