/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.teditor.AbstractDataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.graph.AddGraphDialog;
import oracle.dmt.dataminer.teditor.graph.GraphEditorPanel;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.parallelquery.ParallelQueryPreferences;
import oracle.dmt.dataminer.workflow.parallelquery.ViewDataParallelPanel;
import oracle.dmt.dataminer.workflow.xmlschema.BinningSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.BinningType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupByType;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class GraphEditor
extends AbstractDataEditor
implements Dirtyable {
    private static Logger theLogger = Logger.getLogger(GraphEditor.class.getName());
    private static int inc = 1;
    private static final String defaultTitle = GraphLrb.get("GRAPH_DEF_NAME_ROOT");
    private DataSelectionItem[] viewChoices = new DataSelectionItem[]{new DataSelectionItem(DataLrb.get("DATA_VIEWER_DATASOURCE_ACTUAL"), false), new DataSelectionItem(GraphLrb.get("VIEW_SAMPLE_DATA"), true)};
    private boolean isDirty;
    private boolean handling;
    private boolean isReadOnly;
    private boolean alreadyActive;
    private boolean isViewingSample;
    private boolean needsRefresh;
    private GraphNode diagramGraphNode;
    private BigDecimal workflowId;
    private WorkflowNode workflowNode;
    private Toolbar toolBar;
    private JLabel lockedIcon;
    private JButton refreshButton;
    private JButton addButton;
    private JButton parallelViewDialog;
    private JComboBox<DataSelectionItem> dataCombo;

    public GraphEditor() {
        this._context = this.getContext();
        this.setEditorAttribute("scrollable", true);
        this.initUI();
    }

    private void initUI() {
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.parallelViewDialog = new JButton();
        this.lockedIcon = new JLabel(OracleIcons.getIcon((String)"listLockIcon.png"));
        this.lockedIcon.setVisible(false);
        this.lockedIcon.setToolTipText(GraphLrb.get("LOCKED_TOOLTIP"));
    }

    public void setNeedsRefresh() {
        this.needsRefresh = true;
    }

    @Override
    public void close() {
        super.close();
        ((GraphEditorPanel)this._gui).close();
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        runManager.removeListener(this, connectionFolder.getConnectionName());
    }

    @Override
    public Component getGUI() {
        if (this._gui == null) {
            this.initParentWorkflowEditorState();
            this._gui = new GraphEditorPanel(this, this.getContext());
            this._overLayPanel = new BlockingComponent((JComponent)this._gui);
            this._overLayPanel.setMessage(BlockingComponent.Message.LOADING);
            this._gui.setBlockingComponent(this._overLayPanel);
            this.registerForRunManagerEvents();
        }
        return this._overLayPanel.getBlockingComponent();
    }

    private void initParentWorkflowEditorState() {
        if (this.workflowId == null) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)this.getContext().getNode();
            Node node = GraphUtils.findWorkflowNode(this.getContext());
            if (node instanceof GraphNode) {
                this.diagramGraphNode = (GraphNode)node;
                this.workflowNode = GraphUtils.getWorkflowNavNode(baseTreeNode);
                this.isReadOnly = this.workflowNode.isReadOnly();
                Workflow workflow = (Workflow)this.workflowNode.getRepositoryData();
                this.workflowId = workflow.getId();
            }
        }
    }

    private void registerForRunManagerEvents() {
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        runManager.addListener(this, connectionFolder.getConnectionName(), this.workflowId);
    }

    @Override
    public void open() {
        super.open();
        this.updateParallelViewBtnTitle();
    }

    public void activate() {
        super.activate();
        if (this.diagramGraphNode != null) {
            GraphNodeType graphNodeType = (GraphNodeType)this.diagramGraphNode.getData();
            if (graphNodeType.isViewDirty().booleanValue()) {
                try {
                    this.diagramGraphNode.findOrCreateView(this.getContext());
                }
                catch (GraphNode.ViewCreationNotPossibleException viewCreationNotPossibleException) {
                    theLogger.log(Level.SEVERE, viewCreationNotPossibleException.getMessage(), viewCreationNotPossibleException);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, "Failed to drop and create view", exception);
                }
            }
            this.updateDataSelector();
            if (this.needsRefresh) {
                this.refresh();
            }
            if (this.alreadyActive) {
                return;
            }
            this.alreadyActive = true;
            List list = graphNodeType.getGraphSettings().getGraphSetting();
            for (GraphSettingsType graphSettingsType : list) {
                ((GraphEditorPanel)this._gui).addGraph(graphSettingsType);
            }
            this.updateGraphContainers(this.isReadOnly);
            if (list.isEmpty()) {
                this.handleAddGraph();
            }
        } else if (GraphUtils.getGraphSettings(this.getContext()).getGraphSetting().isEmpty()) {
            this.handleAddGraph();
        }
    }

    public Toolbar getToolbar() {
        return this.toolBar;
    }

    public Component getFixedTopMargin() {
        if (this.toolBar == null) {
            this.toolBar = new Toolbar();
            this.refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            this.refreshButton.getAccessibleContext().setAccessibleDescription(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this.refreshButton.setToolTipText(DataLrb.get("DATA_VIEWER_REFRESH_BUTTON_ADA"));
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GraphEditor.this.refresh();
                }
            });
            this.addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
            this.addButton.getAccessibleContext().setAccessibleDescription(GraphLrb.get("GRAPH_DIALOG_TITLE_NEW"));
            this.addButton.setToolTipText(GraphLrb.get("GRAPH_DIALOG_TITLE_NEW"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GraphEditor.this.handleAddGraph();
                }
            });
            JLabel jLabel = new JLabel(GraphLrb.get("VIEW_LABEL"));
            this.dataCombo = new JComboBox<DataSelectionItem>(this.viewChoices);
            jLabel.setLabelFor(this.dataCombo);
            FontMetrics fontMetrics = this.dataCombo.getFontMetrics(this.dataCombo.getFont());
            int n = Math.max(fontMetrics.stringWidth(DataLrb.get("DATA_VIEWER_DATASOURCE_ACTUAL")), fontMetrics.stringWidth(GraphLrb.get("VIEW_SAMPLE_DATA")));
            Dimension dimension = this.dataCombo.getMaximumSize();
            dimension.setSize((double)(n + 20), dimension.getHeight());
            this.dataCombo.setMaximumSize(dimension);
            this.updateDataSelector();
            this.setViewingSample(GraphUtils.isSampleAvailable(this.getContext()));
            if (this.isViewingSample()) {
                this.dataCombo.setSelectedIndex(1);
            } else {
                this.dataCombo.setSelectedIndex(0);
            }
            this.dataCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    DataSelectionItem dataSelectionItem = (DataSelectionItem)jComboBox.getSelectedItem();
                    GraphEditor.this.isViewingSample = dataSelectionItem.isSample();
                    GraphEditor.this.refresh();
                }
            });
            this.parallelViewDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final ViewDataParallelPanel viewDataParallelPanel = new ViewDataParallelPanel(DataLrb.get("DATA_VIEWER_PARALLEL_DIALOG_TITLE"));
                    DialogHelper dialogHelper = new DialogHelper(viewDataParallelPanel);
                    dialogHelper.setDialogOkExecutor(new DialogOkExecutor(){

                        @Override
                        public void onOK() throws DialogExecutionException {
                            viewDataParallelPanel.updatePreferences();
                            GraphEditor.this.updateParallelViewBtnTitle();
                        }
                    });
                    dialogHelper.showAsDialog();
                }
            });
            this.toolBar.add((Component)this.addButton);
            this.toolBar.add((Component)this.refreshButton);
            this.toolBar.add((Component)jLabel);
            this.toolBar.add(this.dataCombo);
            this.toolBar.addSeparator();
            this.toolBar.add((Component)this.parallelViewDialog);
            this.toolBar.add(Box.createHorizontalGlue());
            this.toolBar.add((Component)this.lockedIcon);
        }
        return this.toolBar;
    }

    public void setViewingSample(boolean bl) {
        this.isViewingSample = bl;
    }

    @Override
    public void updateParallelViewBtnTitle() {
        String string = AbstractDataEditor.parallelQueryPreferences.getViewDataProperty(ViewDataParallelPanel.VIEW_KEY, ParallelQueryPreferences.PROPERTY.IS_PARALLEL);
        if (string == null || !Boolean.parseBoolean(string)) {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_OFF"));
        } else {
            this.parallelViewDialog.setText(DataLrb.get("DATA_VIEWER_PARALLEL_ON"));
        }
    }

    public boolean isViewingSample() {
        return this.isViewingSample;
    }

    private void updateDataSelector() {
        Node node = GraphUtils.findWorkflowNode(this.getContext());
        boolean bl = false;
        if (node instanceof GraphNode) {
            boolean bl2;
            bl = ((GraphNodeType)node.getData()).isSampleDirty();
            boolean bl3 = bl2 = GraphUtils.isSampleAvailable(this.getContext()) && !bl;
            if (!bl2 && this.dataCombo.getSelectedItem() != this.viewChoices[0]) {
                this.dataCombo.setSelectedItem(this.viewChoices[0]);
            }
            this.dataCombo.setEnabled(bl2);
        } else {
            if (this.dataCombo.getSelectedItem() != this.viewChoices[1]) {
                this.dataCombo.setSelectedItem(this.viewChoices[1]);
            }
            this.dataCombo.setEnabled(false);
        }
    }

    @Override
    public void editorShown() {
        super.editorShown();
        this.updateParallelViewBtnTitle();
    }

    private boolean isParentWorkflowReadOnly(RunManagerEvent runManagerEvent) {
        WorkflowJob workflowJob = runManagerEvent.getJob();
        boolean bl = !workflowJob.isJobFinished() || this.workflowNode.isReadOnly();
        return bl;
    }

    @Override
    public void jobAdded(RunManagerEvent runManagerEvent) {
        this.updateGraphContainers(this.isParentWorkflowReadOnly(runManagerEvent));
    }

    @Override
    public void jobChanged(RunManagerEvent runManagerEvent) {
        this.updateGraphContainers(this.isParentWorkflowReadOnly(runManagerEvent));
    }

    @Override
    public void jobFinished(RunManagerEvent runManagerEvent) {
        this.updateGraphContainers(this.isParentWorkflowReadOnly(runManagerEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAddGraph() {
        if (this.handling) {
            return;
        }
        try {
            String string;
            Object object;
            this.handling = true;
            List list = null;
            Node node = GraphUtils.findWorkflowNode(this.getContext());
            boolean bl = false;
            if (this.diagramGraphNode instanceof GraphNode) {
                bl = true;
                object = node.findParentNode();
                if (!(object instanceof DataProvider)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)GraphLrb.get("MISSING_DATA_NODE"), (String)GraphLrb.get("NO_SAMPLE_TITLE"), null);
                    return;
                }
                list = ((DataProvider)object).getAttributes().getAttribute();
            } else if (this.diagramGraphNode instanceof DataProvider) {
                object = (DataProvider)((Object)this.diagramGraphNode);
                list = object.getAttributes().getAttribute();
            }
            boolean bl2 = true;
            do {
                string = defaultTitle + inc++;
                if (!GraphUtils.validateGraphName(this.getContext(), string, null)) continue;
                bl2 = false;
            } while (bl2);
            GraphSettingsType graphSettingsType = new GraphSettingsType();
            graphSettingsType.setYAttributes(new GraphSettingsType.YAttributes());
            BinningSettingsType binningSettingsType = new BinningSettingsType();
            binningSettingsType.setNumericBinCount(new BigInteger("10"));
            binningSettingsType.setBinningKind(BinningType.EQUAL_WIDTH);
            GroupByType groupByType = new GroupByType();
            BinningSettingsType binningSettingsType2 = new BinningSettingsType();
            binningSettingsType2.setNumericBinCount(new BigInteger("10"));
            binningSettingsType2.setBinningKind(BinningType.EQUAL_WIDTH);
            groupByType.setBinningSettings(binningSettingsType2);
            graphSettingsType.setXBinningSettings(binningSettingsType);
            graphSettingsType.setGroupByOption(groupByType);
            graphSettingsType.setType(GraphType.LINE);
            graphSettingsType.setName(string);
            graphSettingsType.setId(UUID.randomUUID().toString());
            graphSettingsType.setComment("");
            AddGraphDialog addGraphDialog = new AddGraphDialog((Frame)Ide.getMainWindow(), this._context, true, list, graphSettingsType);
            addGraphDialog.setVisible(true);
            if (!addGraphDialog.isDialogOK()) {
                if (this._overLayPanel != null) {
                    this._overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
                --inc;
                return;
            }
            graphSettingsType = addGraphDialog.getSettings();
            GraphUtils.updateGraphNodeSettings(this._context, graphSettingsType, GraphUtils.UpdateAction.ADD);
            ((GraphEditorPanel)this._gui).addGraph(graphSettingsType);
            this.updateGraphContainers(this.isReadOnly);
            BaseTreeNode baseTreeNode = (BaseTreeNode)this.getContext().getNode();
            if (node instanceof GraphNode) {
                WorkflowNode workflowNode = GraphUtils.getWorkflowNavNode(baseTreeNode);
                workflowNode.markDirty(true);
            }
        }
        finally {
            this.handling = false;
        }
    }

    public void updateGraphContainers(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphEditor.this.addButton.setEnabled(!bl);
                GraphEditor.this.refreshButton.setEnabled(!bl);
                GraphEditor.this.updateDataSelector();
                GraphEditor.this.parallelViewDialog.setEnabled(!bl);
                GraphEditor.this.lockedIcon.setVisible(bl);
                ((GraphEditorPanel)GraphEditor.this._gui).updateGraphContainers(bl);
            }
        });
    }

    @Override
    public void refresh() {
        if (this._overLayPanel != null) {
            this._overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        super.refresh();
        if (this._gui != null) {
            ((GraphEditorPanel)this._gui).refresh();
            this.updateDataSelector();
        }
        this.needsRefresh = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void markDirty(boolean bl) {
        this.isDirty = bl;
        this.getContext().getNode().markDirty(bl);
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
        if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
            this.closeEditor();
        } else if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.refresh();
        }
    }

    private static class DataSelectionItem {
        private Boolean isSample;
        private String uiText;

        public DataSelectionItem(String string, Boolean bl) {
            this.isSample = bl;
            this.uiText = string;
        }

        public String toString() {
            return this.uiText;
        }

        public Boolean isSample() {
            return this.isSample;
        }
    }
}

