/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.core.model.clas.common.CostMatrixInfo;
import oracle.dmt.dataminer.core.model.clas.common.RowColumnValue;
import oracle.dmt.dataminer.core.model.generated.server.ODMRPkg_Activity;
import oracle.dmt.dataminer.core.model.generated.server.OdmrCostMatrix;
import oracle.dmt.dataminer.core.model.generated.server.OdmrCostMatrixDetail;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.Model;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCData;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public class CostMatrixPanel
extends JPanel
implements DataminerGUIPanel,
DataMinerViewListener {
    private static final Logger theLogger = Logger.getLogger(CostMatrixPanel.class.getName());
    private boolean _loaded;
    private ROCTabPanelState _state;
    private NumberFormat percentageFormat;
    private static final String _confirmMsg = "ROC-ApplyCostMatrixToModel";
    private JButton jApplyCostMatrixBtn;
    private JLabel jAvgAccuracyLabel;
    private JTextField jAvgAccuracyText;
    private JComboBox<String> jComboAccuracyTypes;
    private JLabel jConfusionMatrixLabel;
    private JLabel jFalsePosRateLabel;
    private JTextField jFalsePosRateText;
    private JLabel jLabel1;
    private JLabel jOverallAccuracyLabel;
    private JTextField jOverallAccuracyText;
    private JScrollPane jScrollPane2;
    private JLabel jThresholdLabel;
    private JTextField jThresholdText;
    private JLabel jTruePosRateLabel;
    private JTextField jTruePosRateText;
    private GenericTable niceTable2;

    public CostMatrixPanel(Object object) {
        this._state = (ROCTabPanelState)object;
        this.percentageFormat = Formats.ModelViewer.getPercentage();
        this.initComponents();
        this.initRes();
        this.initUI();
        this.setupUIDetail();
    }

    private void initComponents() {
        this.jConfusionMatrixLabel = new JLabel();
        this.jComboAccuracyTypes = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.niceTable2 = new BaseCostMatrixTable();
        this.jTruePosRateLabel = new JLabel();
        this.jTruePosRateText = new NumberTextField();
        this.jFalsePosRateLabel = new JLabel();
        this.jFalsePosRateText = new NumberTextField();
        this.jAvgAccuracyLabel = new JLabel();
        this.jAvgAccuracyText = new NumberTextField();
        this.jOverallAccuracyLabel = new JLabel();
        this.jOverallAccuracyText = new NumberTextField();
        this.jThresholdLabel = new JLabel();
        this.jThresholdText = new NumberTextField();
        this.jApplyCostMatrixBtn = new JButton();
        this.jLabel1 = new JLabel();
        this.jConfusionMatrixLabel.setText("Performance Matrix ");
        this.niceTable2.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.niceTable2);
        this.jTruePosRateLabel.setText("True Positive Rate:");
        this.jFalsePosRateLabel.setText("False Positive Rate:");
        this.jAvgAccuracyLabel.setText("Average Accuracy:");
        this.jOverallAccuracyLabel.setText("Overall Accuracy:");
        this.jThresholdLabel.setText("Probability Threshold:");
        this.jApplyCostMatrixBtn.setText("Apply Derived Cost Matrix to Model");
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jConfusionMatrixLabel, -1, -1, Short.MAX_VALUE).addGap(91, 91, 91)).addComponent(this.jComboAccuracyTypes, 0, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFalsePosRateLabel).addComponent(this.jAvgAccuracyLabel).addComponent(this.jOverallAccuracyLabel).addComponent(this.jThresholdLabel).addComponent(this.jTruePosRateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jThresholdText, GroupLayout.Alignment.LEADING).addComponent(this.jOverallAccuracyText, GroupLayout.Alignment.LEADING).addComponent(this.jAvgAccuracyText, GroupLayout.Alignment.LEADING).addComponent(this.jFalsePosRateText, GroupLayout.Alignment.LEADING).addComponent(this.jTruePosRateText))).addComponent(this.jApplyCostMatrixBtn, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jConfusionMatrixLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboAccuracyTypes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(14, 14, 14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTruePosRateLabel).addComponent(this.jTruePosRateText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFalsePosRateLabel).addComponent(this.jFalsePosRateText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAvgAccuracyLabel).addComponent(this.jAvgAccuracyText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOverallAccuracyLabel).addComponent(this.jOverallAccuracyText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jThresholdLabel).addComponent(this.jThresholdText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jApplyCostMatrixBtn).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void enableAllControls(boolean bl) {
        this.jApplyCostMatrixBtn.setVisible(false);
        this.jApplyCostMatrixBtn.setEnabled(false);
        this.jComboAccuracyTypes.setEnabled(bl);
        this.jTruePosRateText.setEnabled(bl);
        this.jFalsePosRateText.setEnabled(bl);
        this.jAvgAccuracyText.setEnabled(bl);
        this.jOverallAccuracyText.setEnabled(bl);
        this.jThresholdText.setEnabled(bl);
    }

    @Override
    public void viewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
        if ("PROPERTY_SELECTION_EVENT".equals(dataMinerViewEvent.getAction())) {
            this.loadConfusionMatrix();
        }
    }

    private void loadConfusionMatrix() {
        String string = this._state.getSelectedTestResult();
        ROCData rOCData = null;
        String string2 = null;
        String string3 = null;
        if (string != null) {
            String string4 = (String)this.jComboAccuracyTypes.getSelectedItem();
            int n = 0;
            if (string4.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getMaxOverallAccuracyIdx();
            } else if (string4.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getMaxAvgAccuracyIdx();
            } else if (string4.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getCustomAccuracyIdx();
            } else if (string4.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
                n = this._state.getStatisticsData().get(string).getModelAccuracyIdx();
            }
            if (n >= 0) {
                rOCData = this._state.getROCData().get(string).get(n);
                this.setNumber(this.jTruePosRateText, rOCData.getTruePositivesFraction());
                this.setNumber(this.jFalsePosRateText, rOCData.getFalsePositivesFraction());
                this.setNumber(this.jAvgAccuracyText, rOCData.getAvgAccuracy());
                this.setNumber(this.jOverallAccuracyText, rOCData.getAccuracy());
                this.setNumber(this.jThresholdText, rOCData.getProb());
            } else {
                rOCData = null;
                this.setNumber(this.jTruePosRateText, null);
                this.setNumber(this.jFalsePosRateText, null);
                this.setNumber(this.jAvgAccuracyText, null);
                this.setNumber(this.jOverallAccuracyText, null);
                this.setNumber(this.jThresholdText, null);
            }
            string2 = this._state.getSelectedTargetValue();
            List<String> list = this._state.getTargetValues();
            string3 = list.get(0).equals(string2) ? list.get(list.size() - 1) : list.get(0);
        }
        ((BaseCostMatrixTable)this.niceTable2).setModel(new PerformanceMatrixModel(new PerformanceMatrixDataProvider(this._state.getSelectedTargetValue(), string3, rOCData)));
    }

    private void loadState() {
        this.jComboAccuracyTypes.setModel(new DefaultComboBoxModel<String>(new String[]{TestViewerLrb.get("OVERALL_ACCURACY"), TestViewerLrb.get("AVG_ACCURACY"), TestViewerLrb.get("CUSTOM_ACCURACY"), TestViewerLrb.get("CURRENT_ACCURACY")}));
        this.jComboAccuracyTypes.setSelectedIndex(0);
        this.loadConfusionMatrix();
    }

    private void setupUIDetail() {
        this.loadState();
        this.enableAllControls(true);
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void initUI() {
        this.setEditable(this.jTruePosRateText, false);
        this.setDataType(this.jTruePosRateText, Double.class);
        this.setDecimal(this.jTruePosRateText, this.percentageFormat.getMaximumFractionDigits());
        this.setLocale(this.jTruePosRateText, Locale.getDefault());
        this.setEditable(this.jFalsePosRateText, false);
        this.setDataType(this.jFalsePosRateText, Double.class);
        this.setDecimal(this.jFalsePosRateText, this.percentageFormat.getMaximumFractionDigits());
        this.setLocale(this.jFalsePosRateText, Locale.getDefault());
        this.setEditable(this.jAvgAccuracyText, false);
        this.setDataType(this.jAvgAccuracyText, Double.class);
        this.setDecimal(this.jAvgAccuracyText, this.percentageFormat.getMaximumFractionDigits());
        this.setLocale(this.jAvgAccuracyText, Locale.getDefault());
        this.setEditable(this.jOverallAccuracyText, false);
        this.setDataType(this.jOverallAccuracyText, Double.class);
        this.setDecimal(this.jOverallAccuracyText, this.percentageFormat.getMaximumFractionDigits());
        this.setLocale(this.jOverallAccuracyText, Locale.getDefault());
        this.setEditable(this.jThresholdText, false);
        this.setDataType(this.jThresholdText, Double.class);
        this.setDecimal(this.jThresholdText, this.percentageFormat.getMaximumFractionDigits());
        this.setLocale(this.jThresholdText, Locale.getDefault());
        this.enableAllControls(false);
        this.jComboAccuracyTypes.addActionListener(new AccuracyTypesComboActionListener());
        this.jApplyCostMatrixBtn.addActionListener(new ApplyCostMatrixButtonActionListener());
    }

    private void setNumber(JTextField jTextField, Number number) {
        ((NumberTextField)jTextField).setNumber(number);
    }

    private void setDecimal(JTextField jTextField, int n) {
        ((NumberTextField)jTextField).setDecimal(true, n);
    }

    private void setEditable(JTextField jTextField, boolean bl) {
        jTextField.setEditable(bl);
    }

    private void setDataType(JTextField jTextField, Class clazz) {
        ((NumberTextField)jTextField).setDataType(clazz);
    }

    private void setLocale(JTextField jTextField, Locale locale) {
        jTextField.setLocale(locale);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jConfusionMatrixLabel, this.jComboAccuracyTypes, (String)TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE"));
        this.jConfusionMatrixLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE"));
        this.jConfusionMatrixLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PERFORMANCE_MATRIX_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTruePosRateLabel, (Component)this.jTruePosRateText, (String)TestViewerLrb.get("TRUE_POSITIVE_RATE_VALUE"));
        this.jTruePosRateLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TRUE_POSITIVE_RATE_VALUE"));
        this.jTruePosRateLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TRUE_POSITIVE_RATE_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jFalsePosRateLabel, (Component)this.jFalsePosRateText, (String)TestViewerLrb.get("FALSE_POSITIVE_RATE_VALUE"));
        this.jFalsePosRateLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("FALSE_POSITIVE_RATE_VALUE"));
        this.jFalsePosRateLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("FALSE_POSITIVE_RATE_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jAvgAccuracyLabel, (Component)this.jAvgAccuracyText, (String)TestViewerLrb.get("AVG_ACCURACY_VALUE"));
        this.jAvgAccuracyLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("AVG_ACCURACY_VALUE"));
        this.jAvgAccuracyLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("AVG_ACCURACY_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jOverallAccuracyLabel, (Component)this.jOverallAccuracyText, (String)TestViewerLrb.get("OVERALL_ACCURACY_VALUE"));
        this.jOverallAccuracyLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("OVERALL_ACCURACY_VALUE"));
        this.jOverallAccuracyLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("OVERALL_ACCURACY_VALUE_ADA"));
        ResourceUtils.resLabel((JLabel)this.jThresholdLabel, (Component)this.jThresholdText, (String)TestViewerLrb.get("PROB_THRESHOLD_VALUE"));
        this.jThresholdLabel.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROB_THRESHOLD_VALUE"));
        this.jThresholdLabel.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROB_THRESHOLD_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jApplyCostMatrixBtn, (String)TestViewerLrb.get("APPLY_COST_MATRIX_BTN"));
        this.jApplyCostMatrixBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("APPLY_COST_MATRIX_BTN"));
        this.jApplyCostMatrixBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("APPLY_COST_MATRIX_BTN_ADA"));
    }

    @Override
    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
    }

    @Override
    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
    }

    private static class PerformanceMatrixModel
    extends BaseCostMatrixTableModel {
        public PerformanceMatrixModel(PerformanceMatrixDataProvider performanceMatrixDataProvider) {
            super(performanceMatrixDataProvider);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class ApplyCostMatrixButtonActionListener
    implements ActionListener {
        private ApplyCostMatrixButtonActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!MessageDialog.optionalConfirm((String)CostMatrixPanel._confirmMsg, (Component)Ide.getMainWindow(), (Object)TestViewerLrb.get("APPLY_COST_MATRIX_CONFIRMATION"), (String)TestViewerLrb.get("APPLY_COST_MATRIX_BTN"), (String)"")) {
                return;
            }
            String string = (String)CostMatrixPanel.this.jComboAccuracyTypes.getSelectedItem();
            String string2 = CostMatrixPanel.this._state.getSelectedTestResult();
            int n = 0;
            if (string.equals(TestViewerLrb.get("OVERALL_ACCURACY"))) {
                n = CostMatrixPanel.this._state.getStatisticsData().get(string2).getMaxOverallAccuracyIdx();
            } else if (string.equals(TestViewerLrb.get("AVG_ACCURACY"))) {
                n = CostMatrixPanel.this._state.getStatisticsData().get(string2).getMaxAvgAccuracyIdx();
            } else if (string.equals(TestViewerLrb.get("CUSTOM_ACCURACY"))) {
                n = CostMatrixPanel.this._state.getStatisticsData().get(string2).getCustomAccuracyIdx();
            } else if (string.equals(TestViewerLrb.get("CURRENT_ACCURACY"))) {
                n = CostMatrixPanel.this._state.getStatisticsData().get(string2).getModelAccuracyIdx();
            }
            ROCData rOCData = CostMatrixPanel.this._state.getROCData().get(string2).get(n);
            double d = rOCData.getProb();
            CostMatrixPanel.this._state.setCustomThresholdValue(d);
            double d2 = 1.0E-6f;
            double d3 = d - d2 < 0.0 ? d : d - d2;
            double d4 = (1.0 - d3) / d3;
            String string3 = null;
            String string4 = null;
            string3 = CostMatrixPanel.this._state.getSelectedTargetValue();
            List<String> list = CostMatrixPanel.this._state.getTargetValues();
            string4 = list.get(0).equals(string3) ? list.get(list.size() - 1) : list.get(0);
            ArrayList<RowColumnValue> arrayList = new ArrayList<RowColumnValue>();
            arrayList.add(new RowColumnValue((Object)string3, (Object)string3, new BigDecimal(0.0)));
            arrayList.add(new RowColumnValue((Object)string4, (Object)string3, new BigDecimal(1.0)));
            arrayList.add(new RowColumnValue((Object)string3, (Object)string4, new BigDecimal(d4)));
            arrayList.add(new RowColumnValue((Object)string4, (Object)string4, new BigDecimal(0.0)));
            CostMatrixInfo costMatrixInfo = Model.getROCCostBenefit(arrayList);
            ODMRPkg_Activity oDMRPkg_Activity = null;
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(CostMatrixPanel.this._state.getContext());
                oDMRPkg_Activity = new ODMRPkg_Activity(sQLHelper.conn);
                OdmrCostMatrixDetail[] odmrCostMatrixDetailArray = new OdmrCostMatrixDetail[costMatrixInfo.getRowCount() * costMatrixInfo.geColumnCount()];
                n = 0;
                for (int i = 0; i < costMatrixInfo.getRowCount(); ++i) {
                    for (int j = 0; j < costMatrixInfo.geColumnCount(); ++j) {
                        RowColumnValue rowColumnValue = costMatrixInfo.getRowColumnValue(i, j);
                        if (rowColumnValue._row instanceof String) {
                            odmrCostMatrixDetailArray[n++] = new OdmrCostMatrixDetail((String)rowColumnValue._row, null, (String)rowColumnValue._col, null, rowColumnValue._value);
                            continue;
                        }
                        if (!(rowColumnValue._row instanceof BigDecimal)) continue;
                        odmrCostMatrixDetailArray[n++] = new OdmrCostMatrixDetail(null, (BigDecimal)rowColumnValue._row, null, (BigDecimal)rowColumnValue._col, rowColumnValue._value);
                    }
                }
                OdmrCostMatrix odmrCostMatrix = new OdmrCostMatrix(odmrCostMatrixDetailArray);
                BigDecimal bigDecimal = CostMatrixPanel.this._state.getSelectedTestResultObj().getParentId();
                oDMRPkg_Activity.setModelCostBenefit2(bigDecimal, odmrCostMatrix);
            }
        }
    }

    private class AccuracyTypesComboActionListener
    implements ActionListener {
        private AccuracyTypesComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CostMatrixPanel.this.loadConfusionMatrix();
        }
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String positiveTarget;
        private String otherTarget;
        private ROCData data;

        private PerformanceMatrixDataProvider(String string, String string2, ROCData rOCData) {
            this.positiveTarget = string == null ? "" : string;
            this.otherTarget = string2 == null ? "" : string2;
            this.data = rOCData;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this.positiveTarget, this.otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return CostMatrixPanel.this.percentageFormat.format(this.data.getTruePositives());
            }
            if (n == 0 && n2 == 1) {
                return CostMatrixPanel.this.percentageFormat.format(this.data.getFalseNegatives());
            }
            if (n == 1 && n2 == 0) {
                return CostMatrixPanel.this.percentageFormat.format(this.data.getFalsePositives());
            }
            if (n == 1 && n2 == 1) {
                return CostMatrixPanel.this.percentageFormat.format(this.data.getTrueNegatives());
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

