/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class DataMinerConnections {
    private static final Logger LOGGER = Logger.getLogger(DataMinerConnections.class.getName());
    private static volatile ConnectionDisconnectListener disconnectListener;
    private static Map<String, String> privateConnectionsMap;

    private DataMinerConnections() {
    }

    private static String getPrivateConnectionName(String string) throws ConnectionException {
        String string2 = null;
        String string3 = DataMinerConnections.getQualifiedName(string);
        if (privateConnectionsMap.containsKey(string3)) {
            string2 = privateConnectionsMap.get(string3);
        } else {
            string2 = Connections.getInstance().createPrivateConnection(string3);
            privateConnectionsMap.put(string3, string2);
        }
        return string2;
    }

    public static String getUnqualifiedName(String string) {
        String string2 = null;
        try {
            String string3 = URLDecoder.decode(string, "utf-8");
            int n = string3.indexOf(35);
            string2 = n != -1 ? string3.substring(n + 1) : string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.SEVERE, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        return string2;
    }

    public static String getQualifiedName(String string) {
        String string2 = DatabaseConnections.getInstance().getStoreName();
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string2, (String)string);
        return connectionKey.getQualifiedName();
    }

    public static Connection createPrivateConnection(String string) throws ConnectionException {
        String string2 = DataMinerConnections.getPrivateConnectionName(string);
        Connections connections = Connections.getInstance();
        Connection connection = connections.getUniqueConnection(string2);
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new ConnectionException("Error setting auto commit for connection: " + string, (Throwable)sQLException);
        }
        DataMinerConnections.addDisconnectListener();
        return connection;
    }

    public static void closePrivateConnection(String string) throws ConnectionException {
        String string2 = DataMinerConnections.getPrivateConnectionName(string);
        Connections.getInstance().closeConnection(string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConnectionDisconnectListener addDisconnectListener() {
        if (disconnectListener != null) return disconnectListener;
        Class<DataMinerConnections> clazz = DataMinerConnections.class;
        synchronized (DataMinerConnections.class) {
            if (disconnectListener != null) return disconnectListener;
            disconnectListener = new ConnectionDisconnectListener(){

                public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                    try {
                        Properties properties = connectionDetails.getConnectionProperties();
                        String string = DatabaseConnections.getInstance().getStoreName();
                        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string, (String)((String)properties.get("UnsharedWorksheetOriginalConnectionName")));
                        if (connectionKey == null) {
                            return;
                        }
                        String string2 = connectionKey.getConnectionName();
                        if (privateConnectionsMap.containsKey(string2)) {
                            connectionDetails.getConnection().commit();
                        }
                    }
                    catch (SQLException sQLException) {
                        LOGGER.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    }
                }

                public void connectionDisconnected(ConnectionDetails connectionDetails) {
                }
            };
            Connections.getInstance().addConnectionDisconnectListener(disconnectListener);
            // ** MonitorExit[var0] (shouldn't be in output)
            return disconnectListener;
        }
    }

    static {
        privateConnectionsMap = new HashMap<String, String>();
    }
}

