/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.teditor.structure.StructureViewState;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableEditAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableNodeCreateTablePanel;
import oracle.dmt.dataminer.workflow.dialog.data.UpdateTableWizard;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.UpdateTableNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DBColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTargetSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.UpdateTableNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.util.SwingUtils;

public class UpdateTableNodeAttributesPanel
extends DialogDisplayer<UpdateTableNode> {
    private static final Logger theLogger = Logger.getLogger(UpdateTableNodeAttributesPanel.class.getName());
    private static final String[] _columnNames = new String[]{TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_UPDATE_WITH_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_NAME_COLUMN"), TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_ATTRIBUTE_TYPE_COLUMN"), TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_UPDATE_WITH_TYPE_COLUMN")};
    private static final int NAME = 1;
    private static final int UPDATE_WITH = 0;
    private static final int UPDATE_WITH_DATA_TYPE = 3;
    private static final int DATA_TYPE = 2;
    private static String _newUniqueName;
    private static Icon _editIcon;
    private DataMinerTable _jAttributesTable = new DataMinerTable();
    private TableType _targetTable;
    private List<MapTargetSourceType> _targetColumns = new ArrayList<MapTargetSourceType>();
    private List<MapTargetSourceType> _allColumns = new ArrayList<MapTargetSourceType>();
    private Map<String, TableType> createdTables = new HashMap<String, TableType>();
    private Map<String, String> requiredColumns = new HashMap<String, String>();
    private UpdateNodeColumnInfo _info;
    private JButton _editBtn;
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JButton jButtonBrowse;
    private JButton jButtonNew;
    private JCheckBox jCheckBoxDropExisting;
    private JCheckBox jChkBoxAuto;
    private JLabel jLabelName;
    private JLabel jLabelTableName;

    public UpdateTableNodeAttributesPanel(Context context, UpdateTableNode updateTableNode, UpdateNodeColumnInfo updateNodeColumnInfo) {
        super(context, updateTableNode);
        this._info = updateNodeColumnInfo;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jChkBoxAuto = new JCheckBox();
        this.jLabelName = new JLabel();
        this.jLabelTableName = new JLabel();
        this.jCheckBoxDropExisting = new JCheckBox();
        this.jButtonBrowse = new JButton();
        this.jButtonNew = new JButton();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jLabelName.setText("Name:");
        this.jLabelTableName.setText("Table name");
        this.jCheckBoxDropExisting.setSelected(true);
        this.jCheckBoxDropExisting.setText("Drop Existing");
        this.jButtonBrowse.setText("Browse");
        this.jButtonNew.setText("New");
        this.jAttributesComponent.setMinimumSize(new Dimension(500, 1000));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jLabelName, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTableName, -1, 316, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButtonBrowse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew)).addComponent((Component)this.jAttributesComponent, GroupLayout.Alignment.TRAILING, -1, 542, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jChkBoxAuto, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxDropExisting, GroupLayout.Alignment.LEADING, -2, 242, -2))).addContainerGap()));
        groupLayout.linkSize(0, this.jCheckBoxDropExisting, this.jChkBoxAuto);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName, -2, 22, -2).addComponent(this.jLabelTableName, -2, 22, -2).addComponent(this.jButtonNew).addComponent(this.jButtonBrowse)).addGap(7, 7, 7).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDropExisting).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -2, 225, Short.MAX_VALUE).addContainerGap()));
        groupLayout.linkSize(1, this.jLabelName, this.jLabelTableName);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelName, (Component)this.jLabelTableName, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_SPEC_NAME"));
        ResourceUtils.resButton((AbstractButton)this.jButtonBrowse, (String)TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_BUTTON_BROWSE"));
        ResourceUtils.resButton((AbstractButton)this.jButtonNew, (String)TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_BUTTON_NEW"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        ResourceUtils.resButton((AbstractButton)this.jCheckBoxDropExisting, (String)TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_SPEC_DROP_EXISTING"));
        this.jChkBoxAuto.setOpaque(false);
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
    }

    protected void cleanUp(boolean bl) {
        Object object;
        Object object2;
        if (this.createdTables.isEmpty()) {
            return;
        }
        Set<String> set = this.createdTables.keySet();
        Iterator<String> iterator = set.iterator();
        if (!bl) {
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = this._targetTable.getSchema() + "." + this._targetTable.getName();
                if (0 != ((String)object).compareToIgnoreCase((String)object2)) continue;
                this.createdTables.remove(object2);
                break;
            }
        }
        if (this.createdTables.isEmpty()) {
            return;
        }
        try {
            object2 = ConnectionFolder.getConnectionFolder(this._context);
            object = this.createdTables.values();
            Iterator<TableType> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                TableType tableType = iterator2.next();
                DatabaseMetadataUtils.dropTable((ConnectionManager)object2, tableType.getSchema(), tableType.getName());
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public void initUI() {
        String string;
        Object object;
        Object object2;
        MapTargetSourceType mapTargetSourceType2;
        List list;
        Object object3;
        UpdateTableNode updateTableNode = (UpdateTableNode)this.getData();
        UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)updateTableNode.getData();
        this._targetTable = updateTableNodeType.getUpdateTargetTable();
        Object object4 = "";
        if (updateTableNodeType.getUpdateTargetTable() != null && updateTableNodeType.getUpdateTargetTable().getName() != null && updateTableNodeType.getUpdateTargetTable().getSchema() != null) {
            object4 = updateTableNodeType.getUpdateTargetTable().getSchema() + "." + updateTableNodeType.getUpdateTargetTable().getName();
            this.requiredColumns = this._info.requiredColumns;
            this._allColumns = this._info.availAttrs;
        }
        boolean bl = false;
        if (object4 != null && !((String)object4).isEmpty()) {
            try {
                object3 = ConnectionFolder.getConnectionFolder(this._context);
                if (DatabaseMetadataUtils.dataSourceExists((ConnectionManager)object3, updateTableNodeType.getUpdateTargetTable().getSchema(), updateTableNodeType.getUpdateTargetTable().getName())) {
                    this.setTableName((String)object4);
                    this.jLabelName.setIcon(null);
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            }
        }
        if (!bl) {
            if (object4 == null || ((String)object4).isEmpty()) {
                this.setTableName(TablePIPropertyLrb.get("UPDATE_TABLE_NODE_NAME_EMPTY"));
            } else {
                this.setTableName((String)object4);
            }
            this.jLabelName.setIcon(OracleIcons.getIcon((String)"warning.png"));
        }
        if ((list = (object3 = updateTableNodeType.getUpdateTableAttributes()).getUpdateTableItemType()) != null && !list.isEmpty()) {
            UpdateTableNode.copyAttributes(this._targetColumns, list);
            if (this._info.availAttrs.isEmpty()) {
                for (MapTargetSourceType mapTargetSourceType2 : this._targetColumns) {
                    mapTargetSourceType2.getKey().setStatus(AttributeStatus.INVALID);
                }
            }
        }
        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(this._targetColumns);
        mapTargetSourceType2 = new ArrayList();
        mapTargetSourceType2.add(UpdateTableNode.getEmptyAttributeType());
        AbstractNode abstractNode = updateTableNode.findParentNode();
        if (abstractNode != null) {
            assert (abstractNode instanceof AbstractDataNode);
            object2 = (AbstractDataNode)abstractNode;
            mapTargetSourceType2.addAll(object2.getAttributes().getAttribute());
        }
        object2 = new HashMap();
        for (AttributeType attributeType : mapTargetSourceType2) {
            object2.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : list) {
            object = attributeType.getValue();
            string = object.getName();
            if (string == null || null != object2.get(string)) continue;
            mapTargetSourceType2.add(object);
        }
        this.setupItemsTable(generalAttributesTableModel, (List<AttributeType>)mapTargetSourceType2);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._jAttributesTable));
        boolean bl2 = 0 == updateTableNodeType.getAutoSpec().value().compareTo("Yes");
        this.jChkBoxAuto.setSelected(bl2);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeAttributesPanel.this.getData();
                AbstractNode abstractNode = updateTableNode.findParentNode();
                updateTableNode.validateAttributes(UpdateTableNodeAttributesPanel.this._targetColumns, abstractNode, UpdateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected());
                ((AbstractTableModel)UpdateTableNodeAttributesPanel.this._jAttributesTable.getModel()).fireTableDataChanged();
                UpdateTableNodeAttributesPanel.this._jAttributesTable.repaint();
            }
        });
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE")));
        this._jAttributesTable.setFillsViewportHeight(true);
        this.jCheckBoxDropExisting.setSelected(updateTableNodeType.isDropExisting());
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeAttributesPanel.this.getData();
                    Context context = UpdateTableNodeAttributesPanel.this.getContext();
                    UpdateTableWizard updateTableWizard = new UpdateTableWizard();
                    Dialog dialog = SwingUtils.getAncestorDialog((Component)UpdateTableNodeAttributesPanel.this);
                    if (updateTableWizard.runWizard(dialog, context, updateTableNode)) {
                        UpdateTableNodeAttributesPanel.this.setUpdateTable(updateTableWizard.getTablePropertyValue());
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        this.jButtonNew.setEnabled(abstractNode != null);
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeAttributesPanel.this.getData();
                    AbstractNode abstractNode = updateTableNode.findParentNode();
                    assert (abstractNode != null);
                    assert (abstractNode instanceof AbstractDataNode);
                    if (!abstractNode.getData().getStatus().equals((Object)NodeStatusType.COMPLETE)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("UPDATE_TABLE_RUN_PARENT_NODE"), (String)DataDialogsLrb.get("UPDATE_TABLE_VALIDATION_TITLE"), null);
                        return;
                    }
                    UpdateTableNodeCreateTablePanel updateTableNodeCreateTablePanel = new UpdateTableNodeCreateTablePanel(UpdateTableNodeAttributesPanel.this.getContext(), updateTableNode);
                    if (updateTableNodeCreateTablePanel.showAsDialog(UpdateTableNodeAttributesPanel.this)) {
                        UpdateTableNodeAttributesPanel.this.setUpdateTable(updateTableNodeCreateTablePanel.getTablePropertyValue());
                        TableType tableType = new TableType();
                        tableType.setName(updateTableNodeCreateTablePanel.getTablePropertyValue().getName());
                        tableType.setSchema(updateTableNodeCreateTablePanel.getTablePropertyValue().getSchema());
                        UpdateTableNodeAttributesPanel.this.createdTables.put(updateTableNodeCreateTablePanel.getTablePropertyValue().getSchema() + "." + updateTableNodeCreateTablePanel.getTablePropertyValue().getName(), tableType);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        this._editBtn = new JButton(_editIcon);
        this._editBtn.setEnabled(!list.isEmpty());
        object = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText((String)object);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeAttributesPanel.this.getData();
                    UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)updateTableNode.getData();
                    UpdateTableNodeType updateTableNodeType2 = AttributeTypeHelper.cloneUpdateTableNodeType(updateTableNodeType);
                    UpdateTableNode updateTableNode2 = new UpdateTableNode(updateTableNode.getTag(), (NodeType)updateTableNodeType2, UpdateTableNodeAttributesPanel.this.getContext());
                    UpdateTableEditAttributesDialog updateTableEditAttributesDialog = new UpdateTableEditAttributesDialog(UpdateTableNodeAttributesPanel.this._context, updateTableNode2);
                    DialogHelper dialogHelper = new DialogHelper(updateTableEditAttributesDialog);
                    updateTableEditAttributesDialog.setOriginalData(UpdateTableNodeAttributesPanel.this._allColumns);
                    updateTableNodeType2.setUpdateTargetTable(UpdateTableNodeAttributesPanel.this._targetTable);
                    UpdateTableAttributes updateTableAttributes = new UpdateTableAttributes();
                    List list = updateTableAttributes.getUpdateTableItemType();
                    UpdateTableNode.copyAttributes(list, UpdateTableNodeAttributesPanel.this._targetColumns);
                    updateTableNodeType2.setUpdateTableAttributes(updateTableAttributes);
                    boolean bl = dialogHelper.showAsDialog(UpdateTableNodeAttributesPanel.this);
                    if (bl) {
                        UpdateTableNodeAttributesPanel.this._targetColumns.clear();
                        List<MapTargetSourceType> list2 = updateTableEditAttributesDialog.getResultTargetSourceType();
                        for (MapTargetSourceType object2 : list2) {
                            if (null == UpdateTableNodeAttributesPanel.this.requiredColumns.get(object2.getKey().getName())) continue;
                            object2.getKey().setRequiredColumn(true);
                        }
                        UpdateTableNode.copyAttributes(UpdateTableNodeAttributesPanel.this._targetColumns, list2);
                        TableColumn tableColumn = UpdateTableNodeAttributesPanel.this._jAttributesTable.getColumnModel().getColumn(0);
                        CustomComboCellEditor customComboCellEditor = (CustomComboCellEditor)tableColumn.getCellEditor();
                        JComboBox jComboBox = (JComboBox)customComboCellEditor.getComponent();
                        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
                        Vector<String> vector = new Vector<String>(defaultComboBoxModel.getSize());
                        for (int generalAttributesTableModel = 0; generalAttributesTableModel < defaultComboBoxModel.getSize(); ++generalAttributesTableModel) {
                            vector.add((String)defaultComboBoxModel.getElementAt(generalAttributesTableModel));
                        }
                        GeneralAttributesTableModel generalAttributesTableModel = new GeneralAttributesTableModel(UpdateTableNodeAttributesPanel.this._targetColumns);
                        UpdateTableNodeAttributesPanel.this.setupItemsTable2(generalAttributesTableModel, vector);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        string = new ControlBar();
        string.add((Component)this._editBtn);
        this.jAttributesComponent.setControlBar((ControlBar)string);
    }

    private boolean isTargetTypeEmpty() {
        return null == this._targetTable || null == this._targetTable.getName() || null == this._targetTable.getSchema();
    }

    private void setUpdateTable(Table table) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        assert (table != null);
        Object object5 = "";
        if (table != null && table.getName() != null && table.getSchema() != null) {
            object5 = table.getSchema() + "." + table.getName();
        }
        this.setTableName((String)object5);
        if (this.isTargetTypeEmpty() || !this._targetTable.getName().equals(table.getName()) || !this._targetTable.getSchema().equals(table.getSchema())) {
            this._targetTable = new TableType();
            this._targetTable.setName(table.getName());
            this._targetTable.setSchema(table.getSchema());
            try {
                object4 = (WorkflowNode)this._context.getNode();
                object3 = WorkflowUtils.getWorkflowModel((WorkflowNode)object4);
                _newUniqueName = ((WorkflowModel)((Object)object3)).generateNextDistinctName(this._targetTable.getName());
            }
            catch (Exception exception) {
                _newUniqueName = null;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else {
            _newUniqueName = null;
        }
        object4 = (UpdateTableNode)this.getData();
        if (!this._targetColumns.isEmpty()) {
            this._targetColumns.clear();
            this._allColumns.clear();
        }
        object3 = table.getColumnList();
        assert (object3 != null);
        ArrayList<MapTargetSourceType> arrayList = new ArrayList<MapTargetSourceType>(object3.size());
        Object object6 = object3.iterator();
        while (object6.hasNext()) {
            object2 = (AttributeType)object6.next();
            object = new MapTargetSourceType();
            if (object2 instanceof UpdateTableColumnType) {
                object.setKey((UpdateTableColumnType)object2);
            } else if (object2 instanceof DBColumnType) {
                UpdateTableColumnType updateTableColumnType = new UpdateTableColumnType();
                AttributeTypeHelper.copyAttribute((AttributeType)updateTableColumnType, object2);
                boolean bl = "Yes".equals(((DBColumnType)object2).getIndex()) || "Yes".equals(((DBColumnType)object2).getKey());
                updateTableColumnType.setRequiredColumn(bl);
                object.setKey(updateTableColumnType);
            }
            if (!this.requiredColumns.isEmpty() && null != this.requiredColumns.get(object2.getName())) {
                object.getKey().setRequiredColumn(true);
            }
            object.setValue(UpdateTableNode.getEmptyAttributeType());
            arrayList.add((MapTargetSourceType)object);
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            UpdateTableNode.copyAttributes(this._targetColumns, arrayList);
        }
        object6 = new ArrayList(30);
        object6.add(UpdateTableNode.getEmptyAttributeType());
        object2 = ((AbstractNode)object4).findParentNode();
        if (object2 != null) {
            assert (object2 instanceof AbstractDataNode);
            object = (AbstractDataNode)object2;
            object6.addAll(object.getAttributes().getAttribute());
            ((UpdateTableNode)object4).validateAttributes(this._targetColumns, (AbstractNode)object2, this.jChkBoxAuto.isSelected());
        }
        UpdateTableNode.copyAttributes(this._allColumns, this._targetColumns);
        object = new GeneralAttributesTableModel(this._targetColumns);
        this.setupItemsTable((GeneralAttributesTableModel)((Object)object), (List<AttributeType>)object6);
        this._editBtn.setEnabled(!arrayList.isEmpty());
        if (object5 == null || ((String)object5).isEmpty()) {
            this.setTableName(TablePIPropertyLrb.get("UPDATE_TABLE_NODE_NAME_EMPTY"));
            this.jLabelName.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this.jLabelName.setIcon(null);
        }
    }

    private void setupItemsTable(GeneralAttributesTableModel generalAttributesTableModel, List<AttributeType> list) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setAutoResizeMode(4);
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        JComboBox jComboBox = new JComboBox();
        Vector<String> vector = new Vector<String>(list.size());
        for (AttributeType attributeType : list) {
            vector.add(attributeType.getName());
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(vector));
        jComboBox.setModel(defaultComboBoxModel);
        tableColumn.setCellEditor(new CustomComboCellEditor(jComboBox));
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    private void setupItemsTable2(GeneralAttributesTableModel generalAttributesTableModel, Vector<String> vector) {
        this._jAttributesTable.setModel((TableModel)((Object)generalAttributesTableModel));
        this._jAttributesTable.setSorted(true);
        this._jAttributesTable.setSortColumn(1, true);
        this._jAttributesTable.setAutoResizeMode(4);
        TableColumn tableColumn = this._jAttributesTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new CustomCellRenderer());
        tableColumn = this._jAttributesTable.getColumnModel().getColumn(0);
        JComboBox<String> jComboBox = new JComboBox<String>();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        jComboBox.setModel(defaultComboBoxModel);
        tableColumn.setCellEditor(new CustomComboCellEditor(jComboBox));
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        Object object;
        boolean bl = true;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.jChkBoxAuto.isSelected() ? "Yes" : "No";
        AutoSpecType autoSpecType = AutoSpecType.fromValue((String)string);
        hashMap.put("autoSpec", autoSpecType);
        boolean bl2 = this.jCheckBoxDropExisting.isSelected();
        hashMap.put("dropExisting", bl2);
        if (_newUniqueName != null) {
            if (StringUtils.checkDataLossWithMsg(this.getContext(), _newUniqueName, DataDialogsLrb.get("DIALOG_FAIL_TITLE"))) {
                return false;
            }
            object = new HashMap();
            object.put(this._targetTable, _newUniqueName);
            hashMap.put("targetTable", object);
        }
        object = new UpdateTableAttributes();
        UpdateTableNode.copyAttributes(object.getUpdateTableItemType(), this._targetColumns);
        hashMap.put("targetColumns", object);
        UpdateTableNode updateTableNode = (UpdateTableNode)this.getData();
        CommandProcessor.getInstance().beginTrans(DataDialogsLrb.get("TABLE_CHOOSER_TRANSACTION_NAME"));
        try {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(UpdateTableNode.UPDATE_TABLE_PROPERTIES, null, hashMap, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)updateTableNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(updateTableNode, this._context, arrayList);
            updateTableNode.validate2(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_TITLE"), (String)DataDialogsLrb.get("DATA_SOURCE_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        this.cleanUp(false);
        return bl;
    }

    public static UpdateNodeColumnInfo getAvailableUpdateNodeColumnInfo(final Context context, final UpdateTableNode updateTableNode) {
        UpdateNodeColumnInfo updateNodeColumnInfo = new UpdateNodeColumnInfo();
        class GetAttrs
        extends ProgressRunnable {
            List<MapTargetSourceType> availAttrs = new ArrayList<MapTargetSourceType>();
            Map<String, String> requiredColumns = new HashMap<String, String>();

            GetAttrs() {
            }

            protected Object doWork() throws Exception {
                UpdateTableNodeType updateTableNodeType = (UpdateTableNodeType)updateTableNode.getData();
                Boolean bl = Boolean.TRUE;
                this.requiredColumns = UpdateTableNode.getRequiredColumns(context, StringUtils.escapeSingleQuotesForSQL(updateTableNodeType.getUpdateTargetTable().getSchema()), StringUtils.escapeSingleQuotesForSQL(updateTableNodeType.getUpdateTargetTable().getName()));
                StructureViewState structureViewState = new StructureViewState(context, false);
                structureViewState.setTableName(updateTableNodeType.getUpdateTargetTable().getSchema(), updateTableNodeType.getUpdateTargetTable().getName());
                try {
                    List<ColumnDataRow> list = structureViewState.load();
                    for (ColumnDataRow columnDataRow : list) {
                        UpdateTableColumnType updateTableColumnType = new UpdateTableColumnType();
                        updateTableColumnType.setName(columnDataRow.getName());
                        updateTableColumnType.setDataType(columnDataRow.getDataType());
                        updateTableColumnType.setStatus(AttributeStatus.VALID);
                        updateTableColumnType.setAlias(columnDataRow.getName());
                        MapTargetSourceType mapTargetSourceType = new MapTargetSourceType();
                        mapTargetSourceType.setKey(updateTableColumnType);
                        if (!this.requiredColumns.isEmpty() && null != this.requiredColumns.get(updateTableColumnType.getName())) {
                            mapTargetSourceType.getKey().setRequiredColumn(true);
                        }
                        mapTargetSourceType.setValue(UpdateTableNode.getEmptyAttributeType());
                        this.availAttrs.add(mapTargetSourceType);
                    }
                    AbstractNode abstractNode = updateTableNode.findParentNode();
                    if (abstractNode != null) {
                        updateTableNode.validateAttributes(this.availAttrs, abstractNode, true);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    bl = Boolean.FALSE;
                }
                return bl;
            }

            public List<MapTargetSourceType> getAvailAttrs() {
                return this.availAttrs;
            }

            public Map<String, String> getRequiredColumns() {
                return this.requiredColumns;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            updateNodeColumnInfo.requiredColumns = getAttrs.getRequiredColumns();
            updateNodeColumnInfo.availAttrs = getAttrs.getAvailAttrs();
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return updateNodeColumnInfo;
    }

    private void setTableName(String string) {
        String string2 = StringUtils.getAbbreviatedText(string);
        this.jLabelTableName.setText(string2);
        this.jLabelTableName.setToolTipText(string);
    }

    @Override
    protected String getDialogTitle() {
        return DataDialogsLrb.get("UPDATE_TABLE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "updatetable_node_edit";
    }

    @Override
    protected void doCancel() {
        this.cleanUp(true);
    }

    public static class UpdateNodeColumnInfo {
        List<MapTargetSourceType> availAttrs = new ArrayList<MapTargetSourceType>();
        Map<String, String> requiredColumns = new HashMap<String, String>();
    }

    class IconListRenderer
    extends DefaultListCellRenderer {
        IconListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            int n2 = UpdateTableNodeAttributesPanel.this._jAttributesTable.getSelectedRow();
            if (-1 != n2) {
                GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                int n3 = UpdateTableNodeAttributesPanel.this._jAttributesTable.convertRowIndexToModel(n2);
                object2 = (MapTargetSourceType)generalAttributesTableModel.getSrcData().get(n3);
                UpdateTableColumnType updateTableColumnType = object2.getKey();
                bl5 = updateTableColumnType.isRequiredColumn();
            }
            for (MapTargetSourceType mapTargetSourceType : UpdateTableNodeAttributesPanel.this._targetColumns) {
                bl4 = true;
                if (object == null) {
                    bl3 = false;
                    break;
                }
                object2 = mapTargetSourceType.getValue().getName();
                if (object2 == null || ((String)object2).trim().isEmpty() || !object.toString().equals(mapTargetSourceType.getValue().getName()) || 0 == mapTargetSourceType.getValue().getStatus().compareTo((Enum)AttributeStatus.VALID)) continue;
                bl4 = false;
                bl3 = true;
                break;
            }
            if (!bl3) {
                if (bl5) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
                    jLabel.setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_REQUIRED"));
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_NONE"));
                }
            } else {
                jLabel.setIcon(bl4 ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png"));
            }
            return jLabel;
        }
    }

    private class CustomComboCellEditor
    extends DefaultCellEditor {
        public CustomComboCellEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object3;
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            assert (component instanceof JComboBox);
            List list = new ArrayList();
            UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeAttributesPanel.this.getData();
            AbstractNode abstractNode = updateTableNode.findParentNode();
            if (abstractNode != null) {
                assert (abstractNode instanceof AbstractDataNode);
                object3 = (AbstractDataNode)abstractNode;
                list = object3.getAttributes().getAttribute();
            }
            object3 = (GeneralAttributesTableModel)((Object)UpdateTableNodeAttributesPanel.this._jAttributesTable.getModel());
            int n3 = UpdateTableNodeAttributesPanel.this._jAttributesTable.convertRowIndexToModel(n);
            MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)((ODMrTableModel)((Object)object3)).getSrcData().get(n3);
            UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
            AttributeType attributeType = mapTargetSourceType.getValue();
            String string = updateTableColumnType.getDataType();
            ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
            arrayList.add(UpdateTableNode.getEmptyAttributeType());
            for (AttributeType attributeType2 : list) {
                if (attributeType2.getDataType().equals(string)) {
                    arrayList.add(attributeType2);
                    continue;
                }
                if (!DatabaseMetadataUtils.canDataBeImplicitlyConverted(attributeType2.getDataType(), string)) continue;
                arrayList.add(attributeType2);
            }
            Vector vector = new Vector(arrayList.size());
            boolean bl2 = true;
            for (AttributeType object22 : arrayList) {
                String string2 = object22.getName();
                vector.add(object22.getName());
                if ((attributeType.getName() == null || attributeType.getName().trim().isEmpty()) && (string2 == null || string2.trim().isEmpty())) {
                    bl2 = false;
                    continue;
                }
                if (attributeType.getName() == null || string2 == null || !string2.equals(attributeType.getName())) continue;
                bl2 = false;
            }
            if (bl2) {
                vector.add(attributeType.getName());
            }
            Collections.sort(vector);
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(vector));
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.setRenderer(new IconListRenderer());
            jComboBox.setModel(defaultComboBoxModel);
            jComboBox.setSelectedItem(attributeType.getName());
            return component;
        }
    }

    private class GeneralAttributesTableModel
    extends ODMrTableModel<MapTargetSourceType> {
        private GeneralAttributesTableModel(List<MapTargetSourceType> list) {
            super(_columnNames, list);
        }

        public void setValueAt(Object object, int n, int n2) {
            AbstractDataNode abstractDataNode;
            UpdateTableNode updateTableNode = (UpdateTableNode)UpdateTableNodeAttributesPanel.this.getData();
            if (updateTableNode == null || n2 != 0) {
                return;
            }
            if (UpdateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected()) {
                return;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ArrayList arrayList = new ArrayList();
            AbstractNode abstractNode = updateTableNode.findParentNode();
            if (abstractNode != null) {
                assert (abstractNode instanceof AbstractDataNode);
                abstractDataNode = (AbstractDataNode)abstractNode;
                arrayList.addAll(abstractDataNode.getAttributes().getAttribute());
            }
            abstractDataNode = (MapTargetSourceType)this.srcData.get(n);
            if (object == null || object.toString().trim().isEmpty()) {
                abstractDataNode.setValue(UpdateTableNode.getEmptyAttributeType());
                abstractDataNode.getKey().setStatus(AttributeStatus.VALID);
                UpdateTableNodeAttributesPanel.this._jAttributesTable.repaint();
            } else {
                for (AttributeType attributeType : arrayList) {
                    if (!attributeType.getName().equals(object.toString()) || !attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    abstractDataNode.setValue(attributeType);
                    UpdateTableNodeAttributesPanel.this._jAttributesTable.repaint();
                    break;
                }
            }
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            if (this.srcData.isEmpty()) {
                return "";
            }
            MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)this.srcData.get(n);
            String string = null;
            if (n2 == 1) {
                string = mapTargetSourceType.getKey().getAlias() != null ? mapTargetSourceType.getKey().getAlias() : mapTargetSourceType.getKey().getName();
            } else if (n2 == 2) {
                String string2 = mapTargetSourceType.getKey().getDataType();
                String string3 = mapTargetSourceType.getKey().getDataTypeQualifier();
                string = DatabaseMetadataUtils.isACharacterOracleDataType(string2) ? DatabaseMetadataUtils.getJSONDataType(string2, string3) : string2;
            } else if (n2 == 0) {
                AttributeType attributeType = mapTargetSourceType.getValue();
                string = attributeType != null && attributeType.getName() != null ? attributeType.getName() : null;
            } else if (n2 == 3) {
                AttributeType attributeType = mapTargetSourceType.getValue();
                if (attributeType != null) {
                    String string4 = attributeType.getDataType();
                    String string5 = attributeType.getDataTypeQualifier();
                    string = DatabaseMetadataUtils.isACharacterOracleDataType(string4) ? DatabaseMetadataUtils.getJSONDataType(string4, string5) : string4;
                }
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }

        @Override
        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return !UpdateTableNodeAttributesPanel.this.jChkBoxAuto.isSelected();
            }
            return false;
        }
    }

    private class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            try {
                Icon icon = null;
                for (MapTargetSourceType mapTargetSourceType : UpdateTableNodeAttributesPanel.this._targetColumns) {
                    if (n2 == 1) {
                        if (!mapTargetSourceType.getKey().getName().equals(object.toString())) continue;
                        icon = 0 == mapTargetSourceType.getKey().getStatus().compareTo((Enum)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
                        break;
                    }
                    if (n2 != 0 || mapTargetSourceType == null || mapTargetSourceType.getValue() == null || object == null) continue;
                    try {
                        if (null == mapTargetSourceType.getValue().getName() || mapTargetSourceType.getValue().getName().trim().isEmpty() || null == mapTargetSourceType.getValue().getStatus() || !mapTargetSourceType.getValue().getName().equals(object.toString())) continue;
                        icon = 0 == mapTargetSourceType.getValue().getStatus().compareTo((Enum)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png");
                        break;
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
                if (icon != null) {
                    this.setIcon(icon);
                } else {
                    GeneralAttributesTableModel generalAttributesTableModel = (GeneralAttributesTableModel)((Object)UpdateTableNodeAttributesPanel.this._jAttributesTable.getModel());
                    int n3 = UpdateTableNodeAttributesPanel.this._jAttributesTable.convertRowIndexToModel(n);
                    MapTargetSourceType mapTargetSourceType = (MapTargetSourceType)generalAttributesTableModel.getSrcData().get(n3);
                    UpdateTableColumnType updateTableColumnType = mapTargetSourceType.getKey();
                    if (updateTableColumnType.isRequiredColumn() && updateTableColumnType.getStatus().equals((Object)AttributeStatus.VALID)) {
                        this.setIcon(OracleIcons.getIcon((String)"incompletestatus.png"));
                        ((JLabel)component).setText(TablePIPropertyLrb.get("PI_UPDATE_TABLE_NODE_GROUP_COLUMNS_REQUIRED"));
                    } else if (object == null || object.toString().trim().isEmpty()) {
                        this.setIcon(null);
                    } else {
                        this.setIcon(updateTableColumnType.getStatus().equals((Object)AttributeStatus.VALID) ? OracleIcons.getIcon((String)"attribute.png") : OracleIcons.getIcon((String)"warning.png"));
                    }
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return component;
        }
    }
}

