/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.partition;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dataminer.expressionbuilder.PartitionExpressionBuilderContext;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.OuputColumnsPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.AddPartitionColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionCustomCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class PartitionPanel
extends JPanel {
    private OuputColumnsPanel outputColumnsPanel;
    private DataMinerTablePanel partitionsTablePanel;
    private DynamicNodeEditorState state;
    private DynamicEditorPanel predictionsPanel;
    private JButton addPartitionColumnBtn;
    private JButton addPartitionExprBtn;
    private JButton editPartitionExprBtn;
    private JButton removePartitionExprBtn;

    public PartitionPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.partitionsTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.partitionsTablePanel, -1, 435, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.partitionsTablePanel, -1, 348, Short.MAX_VALUE).addContainerGap()));
    }

    public void setState(DynamicNodeEditorState dynamicNodeEditorState) {
        this.state = dynamicNodeEditorState;
    }

    public AbstractTransformNode getData() {
        return this.state.getNode();
    }

    public Context getContext() {
        return this.state.getContext();
    }

    public void cleanUp() {
    }

    public boolean isWritable() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        return !workflowNode.isReadOnly();
    }

    public void initRes() {
    }

    public void initUI(DynamicEditorPanel dynamicEditorPanel) {
        this.predictionsPanel = dynamicEditorPanel;
        this.partitionsTablePanel.setTitle(PartitionLrb.get("PARTITION_EDITOR_PANEL_TITLE"));
        this.partitionsTablePanel.removeSearchField();
        this.addPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPartitionColumnBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_COLUMN"));
        this.addPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.hanldeAddPartitionColumns();
            }
        });
        this.addPartitionExprBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_VALUE_ADD_EXPRESSION));
        this.addPartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_EXPR"));
        this.addPartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.hanldeAddPartitionExpression();
            }
        });
        this.editPartitionExprBtn = new JButton(DynamicNodeEditorState.getEditIcon());
        this.editPartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_EDIT_PARTITION_EXPR"));
        this.editPartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.hanldeEditPartitionExpression();
            }
        });
        this.removePartitionExprBtn = new JButton(DynamicNodeEditorState.getRemoveIcon());
        this.removePartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_REMOVE_PARTITION"));
        this.removePartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.hanldeRemovePartition();
            }
        });
        this.partitionsTablePanel.addControlBarComponents(this.addPartitionColumnBtn, this.addPartitionExprBtn, this.editPartitionExprBtn, this.removePartitionExprBtn);
        this.addPartitionColumnBtn.setEnabled(true);
        this.addPartitionExprBtn.setEnabled(true);
        this.editPartitionExprBtn.setEnabled(false);
        this.removePartitionExprBtn.setEnabled(false);
        this.setupPartitionsTable();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = PartitionPanel.this.partitionsTablePanel.getTable().getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    PartitionPanel.this.hanldeEditPartitionExpression();
                }
            }
        };
        this.partitionsTablePanel.getTable().addMouseListener(mouseAdapter);
    }

    private void setupPartitionsTable() {
        this.partitionsTablePanel.getTable().setModel((TableModel)((Object)this.state.getTableModelPartitions()));
        this.partitionsTablePanel.getTable().setShowGrid(true);
        this.partitionsTablePanel.getTable().setSorted(true);
        this.partitionsTablePanel.getTable().setSortColumn(0, true);
        this.partitionsTablePanel.getTable().getSelectionModel().addListSelectionListener(new PartitionSelectionHandler());
        TableColumn tableColumn = this.partitionsTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    private void hanldeAddPartitionColumns() {
        AddPartitionColumnPanel addPartitionColumnPanel = new AddPartitionColumnPanel(this.getContext(), this.state.getNode(), this.state.getMiningAttributes(), this.state.getPartitionExpressions(), this.state.getTargetAttributeList(), this.state.getCaseAttributes());
        if (addPartitionColumnPanel.showAsDialog(this) && addPartitionColumnPanel.isDirty()) {
            List<MiningAttributeType> list = addPartitionColumnPanel.getSelectedAttrsCache();
            List<PartitionExpressionType> list2 = this.state.getListOfPartitionColumnsToRemove(list);
            this.state.removeExpressionsFromList(list2);
            List<PartitionExpressionType> list3 = this.state.getListOfPartitionColumnsToAdd(list);
            this.state.addPartitionExpressions(list3);
            this.setupPartitionsTable();
            this.state.updateAutoSupplementalList();
            this.predictionsPanel.updateCaseIDs();
            this.outputColumnsPanel.updateAutoSupplementalList();
        }
    }

    private void hanldeAddPartitionExpression() {
        Object object2;
        AbstractTransformNode abstractTransformNode = this.getData();
        AbstractNode abstractNode = abstractTransformNode.findParentNode();
        PartitionExpressionType partitionExpressionType = new PartitionExpressionType();
        String string = this.state.generatePartitionExpressionName(partitionExpressionType);
        PartitionExpressions partitionExpressions = this.state.getPartitionExpressions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : partitionExpressions.getPartitionExpression()) {
            arrayList.add(object2.getPartitionAttribute().getName());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        object2 = new PartitionExpressionBuilderContext(((DataProvider)((Object)abstractNode)).getInputSQL(), abstractNode, string, "", stringArray);
        ExpressionBuilderMainPanel expressionBuilderMainPanel = new ExpressionBuilderMainPanel(this.state.getContext(), (AbstractExpressionBuilderContext)object2);
        DialogHelper dialogHelper = new DialogHelper(expressionBuilderMainPanel);
        if (dialogHelper.showAsDialog(this)) {
            String string2 = expressionBuilderMainPanel.getExpression();
            string = expressionBuilderMainPanel.getAttributeName();
            partitionExpressionType.setSQLExpression(string2);
            String string3 = expressionBuilderMainPanel.getExpressionDataType();
            AttributeType attributeType = new AttributeType();
            attributeType.setName(string);
            attributeType.setDataType(string3);
            attributeType.setStatus(AttributeStatus.VALID);
            partitionExpressionType.setPartitionAttribute(attributeType);
            this.state.addPartitionExpression(partitionExpressionType);
            this.setupPartitionsTable();
            this.state.updateAutoSupplementalList();
            this.outputColumnsPanel.updateAutoSupplementalList();
        }
    }

    private void hanldeEditPartitionExpression() {
        Object object2;
        int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        List list = this.state.getTableModelPartitions().getSrcData();
        PartitionExpressionType partitionExpressionType = (PartitionExpressionType)list.get(nArray[0]);
        AbstractTransformNode abstractTransformNode = this.getData();
        AbstractNode abstractNode = abstractTransformNode.findParentNode();
        String string = partitionExpressionType.getPartitionAttribute().getName();
        String string2 = partitionExpressionType.getSQLExpression();
        PartitionExpressions partitionExpressions = this.state.getPartitionExpressions();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : partitionExpressions.getPartitionExpression()) {
            arrayList.add(object2.getPartitionAttribute().getName());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        object2 = new PartitionExpressionBuilderContext(((DataProvider)((Object)abstractNode)).getInputSQL(), abstractNode, string, string2, stringArray);
        ExpressionBuilderMainPanel expressionBuilderMainPanel = new ExpressionBuilderMainPanel(this.state.getContext(), (AbstractExpressionBuilderContext)object2);
        DialogHelper dialogHelper = new DialogHelper(expressionBuilderMainPanel);
        if (dialogHelper.showAsDialog(this)) {
            string2 = expressionBuilderMainPanel.getExpression();
            string = expressionBuilderMainPanel.getAttributeName();
            partitionExpressionType.setSQLExpression(string2);
            String string3 = expressionBuilderMainPanel.getExpressionDataType();
            partitionExpressionType.getPartitionAttribute().setDataType(string3);
            partitionExpressionType.getPartitionAttribute().setName(string);
            this.setupPartitionsTable();
            this.state.updateAutoSupplementalList();
            this.outputColumnsPanel.updateAutoSupplementalList();
        }
    }

    private void hanldeRemovePartition() {
        int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List list = this.state.getTableModelPartitions().getSrcData();
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((PartitionExpressionType)list.get(nArray[i]));
        }
        this.state.removeExpressionsFromList(arrayList);
        this.setupPartitionsTable();
        this.state.updateAutoSupplementalList();
        this.predictionsPanel.updateCaseIDs();
        this.outputColumnsPanel.updateAutoSupplementalList();
    }

    public boolean doWork() {
        return true;
    }

    public void setOutputColumnsPanel(OuputColumnsPanel ouputColumnsPanel) {
        this.outputColumnsPanel = ouputColumnsPanel;
    }

    private class CustomCellRenderer
    extends PartitionCustomCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Icon getValidIcon() {
            return OracleIcons.getIcon((String)"attribute.png");
        }

        @Override
        public Icon getInvalidIcon() {
            return OracleIcons.getIcon((String)"warning.png");
        }

        @Override
        public PartitionExpressionType getPartitionExpression(String string) {
            PartitionExpressionType partitionExpressionType = null;
            List list = PartitionPanel.this.state.getTableModelPartitions().getSrcData();
            for (PartitionExpressionType partitionExpressionType2 : list) {
                if (null != partitionExpressionType2.getSQLExpression() || !partitionExpressionType2.getPartitionAttribute().getName().equals(string)) continue;
                partitionExpressionType = partitionExpressionType2;
                break;
            }
            return partitionExpressionType;
        }
    }

    class PartitionSelectionHandler
    implements ListSelectionListener {
        PartitionSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = PartitionPanel.this.partitionsTablePanel.getTable().getSelectedRowsInModel();
            boolean bl = nArray != null && nArray.length > 0;
            PartitionPanel.this.removePartitionExprBtn.setEnabled(bl);
            boolean bl2 = nArray != null && nArray.length == 1;
            boolean bl3 = false;
            if (bl2) {
                List list = PartitionPanel.this.state.getTableModelPartitions().getSrcData();
                PartitionExpressionType partitionExpressionType = (PartitionExpressionType)list.get(nArray[0]);
                bl3 = null != partitionExpressionType.getSQLExpression();
            }
            PartitionPanel.this.editPartitionExprBtn.setEnabled(bl3);
        }
    }
}

