/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.SQLQuery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.renderers.AttributeTypeCellRenderer;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.sqlQuery.SQLQueryEditorPanel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.SQLQuery.SQLQueryNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.SQLQuery.SQLQueryPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.SQLQuery.WorkflowSQLQueryNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.SQLQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SQLQueryOutputColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.status.Issue;

public class SQLQueryOutputPanel
extends PIComponentPanel {
    private static final int MAX_LENGTH = 32;
    private static final int MAX_LENGTH_EX = 130;
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;
    private SQLQueryNode _targetNode;
    private SQLQueryOutputColumnsType _outputColumns;
    private AttrTableModel<AttributeType> _models;
    private boolean _hasWithClause;
    private JButton addBtn;
    private JCheckBox jGenViewCheckBox;
    private JLabel jViewNameLabel;
    private JTextField jViewNameTextField;
    private DataMinerTablePanel tablePanel;

    public SQLQueryOutputPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
        this.jGenViewCheckBox.setText(SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_GENERATE_VIEW"));
        this.jGenViewCheckBox.setOpaque(false);
        this.jViewNameLabel.setText(SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_VIEW_NAME"));
        this.jViewNameLabel.setOpaque(false);
    }

    private void initUI() {
        this._targetNode = (SQLQueryNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)nodeType;
        this._outputColumns = (SQLQueryOutputColumnsType)MetaDataHelper.copyMetadataObject(sQLQueryNodeType.getSQLQueryOutputColumns());
        this._hasWithClause = sQLQueryNodeType.isHasWithClause();
        this._models = new AttrTableModel(this._outputColumns.getAttribute());
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryOutputPanel.this.processEdit();
            }
        });
        this.addBtn.setToolTipText(DialogsLrb.get("SQLQUERY_QUERY_EDIT"));
        this.tablePanel.addControlBarComponents(this.addBtn);
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("SQLQUERY_DATA_COLUMN"), 0, true);
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new AttributeTypeCellRenderer());
        this.jGenViewCheckBox.setSelected(sQLQueryNodeType.isGenerateView());
        if (this._hasWithClause) {
            String string = sQLQueryNodeType.getViewName();
            boolean bl = SQLHelper.isExpandedObjNameEnabled(this.getContext((PropertyModel)this._model));
            this.jViewNameTextField.setDocument(new TextFieldLimit(bl ? 130 : 32));
            ViewNameInputVerifier viewNameInputVerifier = new ViewNameInputVerifier(this.jViewNameTextField, this.getContext((PropertyModel)this._model));
            this.jViewNameTextField.setInputVerifier(viewNameInputVerifier);
            if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
                string = StringUtils.addDoubleQuotes(string);
            }
            this.jViewNameTextField.setText(string);
            CustomViewNameValidator customViewNameValidator = new CustomViewNameValidator(viewNameInputVerifier);
            this.jViewNameTextField.addFocusListener(customViewNameValidator);
            this.jViewNameTextField.addKeyListener(customViewNameValidator);
            this.validateViewName(string);
        }
        this.tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SQLQueryOutputPanel.this.processEdit();
                }
            }
        });
        this.enableControls();
    }

    private void update() {
        this._targetNode = (SQLQueryNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)nodeType;
        this._outputColumns = (SQLQueryOutputColumnsType)MetaDataHelper.copyMetadataObject(sQLQueryNodeType.getSQLQueryOutputColumns());
        this._hasWithClause = sQLQueryNodeType.isHasWithClause();
        this._models.setSrcData(this._outputColumns.getAttribute());
        this.jGenViewCheckBox.setSelected(sQLQueryNodeType.isGenerateView());
        String string = sQLQueryNodeType.getViewName();
        if (string != null) {
            if (!StringUtils.isValidNonQuotedDBObjectName(string)) {
                string = StringUtils.addDoubleQuotes(string);
            }
            this.validateViewName(string);
        }
        this.jViewNameTextField.setText(string);
        this.enableControls();
    }

    public void updatePI(PropertyModel propertyModel) {
        this._model = (WorkflowSQLQueryNodePropertyProxyModel)propertyModel;
        this.update();
    }

    protected void processEdit() {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this._targetNode.getData();
        SQLContext sQLContext = new SQLContext(this.getContext((PropertyModel)this._model), this._targetNode.findSourceNodes(), this._targetNode, sQLQueryNodeType.getSQLQueryExpression(), false);
        sQLContext.setHasWithClause(sQLQueryNodeType.isHasWithClause());
        sQLContext.setGenerateView(sQLQueryNodeType.isGenerateView());
        sQLContext.setName(sQLQueryNodeType.getViewName());
        SQLQueryEditorPanel sQLQueryEditorPanel = new SQLQueryEditorPanel(sQLContext, null);
        sQLQueryEditorPanel.showAsDialog(this);
    }

    private void enableControls() {
        this.addBtn.setEnabled(this.isWritable());
        this.jGenViewCheckBox.setEnabled(this._hasWithClause && this.isWritable());
        this.jViewNameLabel.setEnabled(this._hasWithClause && this.jGenViewCheckBox.isSelected() && this.isWritable());
        this.jViewNameTextField.setEnabled(this._hasWithClause && this.jGenViewCheckBox.isSelected() && this.isWritable());
    }

    private void initComponents() {
        this.addBtn = new JButton();
        this.jGenViewCheckBox = new JCheckBox();
        this.jViewNameLabel = new JLabel();
        this.jViewNameTextField = new JTextField();
        this.tablePanel = new DataMinerTablePanel();
        this.addBtn.setIcon(InspectorArb.getIcon((int)24));
        this.setPreferredSize(new Dimension(762, 339));
        this.jGenViewCheckBox.setText("Generate View");
        this.jGenViewCheckBox.setOpaque(false);
        this.jGenViewCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SQLQueryOutputPanel.this.jGenViewCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jViewNameLabel.setLabelFor(this.jViewNameTextField);
        this.jViewNameLabel.setText("View Name");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, 738, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGenViewCheckBox).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jViewNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jViewNameTextField, -2, 162, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jGenViewCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jViewNameTextField, -2, -1, -2).addComponent(this.jViewNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 282, Short.MAX_VALUE).addContainerGap()));
    }

    private void jGenViewCheckBoxActionPerformed(ActionEvent actionEvent) {
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)this._targetNode.getData();
        boolean bl = this.jGenViewCheckBox.isSelected();
        ComplexProperty complexProperty = new ComplexProperty("GenerateView", bl);
        complexProperty.setOldData(sQLQueryNodeType.isGenerateView());
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(SQLQueryNodePropertyModel.SQLQUERY_GENERATE_VIEW.index), null, complexProperty, null, null));
        this._model.setValueAt(SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_GENERATE_VIEW_DESCRIPTION"), this._targetNode, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setViewName(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        SQLQueryNode sQLQueryNode = (SQLQueryNode)this.getTargetNode((PropertyModel)this._model, SQLQueryNodeType.class);
        SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)sQLQueryNode.getData();
        String string2 = sQLQueryNodeType.getViewName();
        if (string2 != null && string2.trim().length() > 0 && string2.equals(StringUtils.trimDoubleQuotes(string))) {
            return;
        }
        string = StringUtils.trimDoubleQuotes(string);
        Context context = this.getContext((PropertyModel)this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ComplexProperty complexProperty = new ComplexProperty("viewName", string);
        CommandProcessor.getInstance().beginTrans(SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_VIEW_NAME_DESCRIPTION"));
        try {
            this._model.setValueAt(SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_SPEC_TABLE_NAME"), sQLQueryNode, complexProperty, SQLQueryNodePropertyModel.SQLQUERY_VIEW_NAME.index);
            workflowNodeInspectorElement.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_SYSTEM_ERROR_TITLE"), (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_SYSTEM_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void validateViewName(String string) {
        String string2 = null;
        string = StringUtils.trimDoubleQuotes(string);
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this.getContext((PropertyModel)this._model));
        if (bl) {
            if (string.length() > 128) {
                string2 = SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_NAME_TOO_LONG_EX_ERROR");
            }
        } else if (string.length() > 30) {
            string2 = SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_NAME_TOO_LONG_ERROR");
        } else if (!StringUtils.isDoubleQuotedString(string) && !StringUtils.containsNoDot(string)) {
            string2 = SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_VIEW_NAME_ERROR");
        }
        if (string2 != null) {
            List<Issue> list = this.openIssue(string2);
            this.addWarningBorderAndTooltip(this.jViewNameTextField, list);
        } else {
            this.restoreBorder(this.jViewNameTextField);
        }
    }

    private boolean isDuplicateName(String string) {
        boolean bl = false;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            bl = workflowEditor.doesNodeNameAlreadyExist(string);
        }
        return bl;
    }

    class ViewNameInputVerifier
    extends InputVerifier {
        JTextField _textField;
        String _currentValue;
        Context _context;

        public ViewNameInputVerifier(JTextField jTextField, Context context) {
            this._textField = jTextField;
            this._context = context;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl = true;
            if (jComponent instanceof JTextField) {
                SQLQueryNode sQLQueryNode = (SQLQueryNode)SQLQueryOutputPanel.this.getTargetNode((PropertyModel)SQLQueryOutputPanel.this._model, SQLQueryNodeType.class);
                SQLQueryNodeType sQLQueryNodeType = (SQLQueryNodeType)sQLQueryNode.getData();
                this._currentValue = sQLQueryNodeType.getViewName();
                JTextField jTextField = (JTextField)jComponent;
                String string = jTextField.getText().trim();
                if (string.length() == 0) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_NAME_MISSING"), (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_SPEC_ERROR_TITLE"), null);
                    bl = false;
                }
                if (StringUtils.isDoubleQuotedString(string)) {
                    this._currentValue = StringUtils.addDoubleQuotes(this._currentValue);
                }
                if (bl && !StringUtils.isDoubleQuotedString(string)) {
                    string = string.toUpperCase();
                }
                try {
                    if (this._currentValue != null && this._currentValue.compareTo(string) != 0) {
                        if (bl && SQLQueryOutputPanel.this.isDuplicateName(StringUtils.trimDoubleQuotes(string))) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_NOT_UNIQUE_MSG"), (String)SQLQueryPIPropertyLrb.get("PI_SQLQUERY_GROUP_SPEC_ERROR_TITLE"), null);
                            bl = false;
                        }
                        if (bl && !TableNameValidator.validateTableName(string, null, this._context, true)) {
                            bl = false;
                        }
                        if (bl && !TableNameValidator.isTableNameUnique(this._context, string)) {
                            String string2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_IN_USE"), string);
                            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), null)) {
                                bl = false;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_TITLE"), (String)DataDialogsLrb.get("TABLE_VALIDATION_ERROR_SYSTEM_ERROR"), null);
                    bl = false;
                }
                if (!bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewNameInputVerifier.this._textField.setText(ViewNameInputVerifier.this._currentValue);
                        }
                    });
                } else {
                    SQLQueryOutputPanel.this.setViewName(string);
                }
            }
            return bl;
        }
    }

    class CustomViewNameValidator
    extends KeyAdapter
    implements FocusListener {
        boolean busy = false;
        ViewNameInputVerifier _verifier;

        public CustomViewNameValidator(ViewNameInputVerifier viewNameInputVerifier) {
            this._verifier = viewNameInputVerifier;
        }

        private void validateName() {
            if (this.busy) {
                return;
            }
            try {
                this.busy = true;
                this._verifier.verify(SQLQueryOutputPanel.this.jViewNameTextField);
            }
            finally {
                this.busy = false;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                this.validateName();
            }
        }
    }
}

