/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.regression;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.ide.Context;

public class RegressionPartitionedBuildNodePropertyModel
extends AbstractNodePropertyModel {
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    public static final NodeProperty PROP_TARGET;
    public static final NodeProperty PROP_MODEL_ADDED_REMOVED;
    public static final NodeProperty PROP_ALGORITHM_SETTINGS;
    public static final NodeProperty PROP_SPLIT_VALUE;
    public static final NodeProperty PROP_SPLIT_DATA_FORMAT;
    public static final NodeProperty PROP_GEN_ACCURACY_METRICS;
    public static final NodeProperty PROP_GEN_RESIDUALS;
    public static final NodeProperty PROP_CASE_IDS;
    public static final NodeProperty PROP_TEST_OPTIONS_CHANGED;
    public static final NodeProperty PROP_TEST_SETTINGS_CHANGED;
    public static final NodeProperty PROP_MODELS_RERUN;
    public static final NodeProperty PROP_TESTS_RERUN;
    public static final NodeProperty PROP_TESTS_ADDED_REMOVED;
    public static final NodeProperty PROP_MODEL_ANNOTATION;
    public static final NodeProperty PROP_MODEL_NAME;
    public static final NodeProperty PROP_MODEL_USEFOROUTPUT;
    public static final NodeProperty PROP_MINING_ATTRIBUTE_SETTINGS;
    public static final NodeProperty PROP_PARTITIONS_MAX_NUM;
    public static final NodeProperty PROP_PARTITIONS_EXPRESSION_EDIT;
    public static final NodeProperty PROP_ODMS_PARTITION_BUILD_TYPE;

    public RegressionPartitionedBuildNodePropertyModel(Context context) {
        super(context);
    }

    @Override
    public String getHelpTopic() {
        return "regression_node_pi";
    }

    @Override
    protected List<NodeProperty> getNodeProperties() {
        return properties;
    }

    private static void prepareStatusReady(List<Property> list, AbstractBuildNode abstractBuildNode) {
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType object2 : list2) {
            hashMap.put(object2.getId(), ModelStatusType.READY);
        }
        if (!hashMap.isEmpty()) {
            list.add(new Property(String.valueOf(RegressionPartitionedBuildNodePropertyModel.PROP_MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
        }
        List<RegressionResultType> list3 = MetaDataHelper.getRegressionResultsCollection(abstractBuildNode);
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            RegressionResultType regressionResultType = (RegressionResultType)iterator.next();
            if (null == hashMap.get(regressionResultType.getModelId())) continue;
            hashMap2.put(regressionResultType.getModelId(), ModelStatusType.READY);
        }
        if (!hashMap2.isEmpty()) {
            list.add(new Property(String.valueOf(RegressionPartitionedBuildNodePropertyModel.PROP_TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
        }
    }

    public static void updatePartitionBuildType(List<Property> list, AbstractBuildNode abstractBuildNode, String string, String string2) {
        ComplexProperty complexProperty = new ComplexProperty("ODMS_PARTITION_BUILD_TYPE", string);
        complexProperty.setOldData(string2);
        list.add(new Property(String.valueOf(RegressionPartitionedBuildNodePropertyModel.PROP_ODMS_PARTITION_BUILD_TYPE.index), null, complexProperty, null, null));
        RegressionPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updateMaxNumPartitions(List<Property> list, AbstractBuildNode abstractBuildNode, BigInteger bigInteger, BigInteger bigInteger2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_MAX_NUM", bigInteger);
        complexProperty.setOldData(bigInteger2);
        list.add(new Property(String.valueOf(RegressionPartitionedBuildNodePropertyModel.PROP_PARTITIONS_MAX_NUM.index), null, complexProperty, null, null));
        RegressionPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updatePartitionColumns(List<Property> list, AbstractBuildNode abstractBuildNode, PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSION_EDIT", partitionExpressions);
        complexProperty.setOldData(partitionExpressions2);
        list.add(new Property(String.valueOf(RegressionPartitionedBuildNodePropertyModel.PROP_PARTITIONS_EXPRESSION_EDIT.index), null, complexProperty, null, null));
        RegressionPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    static {
        properties.addAll(AbstractNodePropertyModel.properties);
        int n = properties.size();
        PROP_TARGET = new NodeProperty("targetAttribute", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_TARGET);
        PROP_MODEL_ADDED_REMOVED = new NodeProperty("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_ADDED_REMOVED);
        PROP_ALGORITHM_SETTINGS = new NodeProperty("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_ALGORITHM_SETTINGS);
        PROP_SPLIT_VALUE = new NodeProperty("splitValueChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_SPLIT_VALUE);
        PROP_SPLIT_DATA_FORMAT = new NodeProperty("splitDataFormat", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_SPLIT_DATA_FORMAT);
        PROP_GEN_ACCURACY_METRICS = new NodeProperty("genAccuracyMetrics", PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_PERFORMANCE_METRICS"), PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_PERFORMANCE_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_GEN_ACCURACY_METRICS);
        PROP_GEN_RESIDUALS = new NodeProperty("genResiduals", PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS"), PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_GEN_RESIDUALS);
        PROP_CASE_IDS = new NodeProperty("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_CASE_IDS);
        PROP_TEST_OPTIONS_CHANGED = new NodeProperty("testOptionsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_TEST_OPTIONS_CHANGED);
        PROP_TEST_SETTINGS_CHANGED = new NodeProperty("testSettingsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_TEST_SETTINGS_CHANGED);
        PROP_MODELS_RERUN = new NodeProperty("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODELS_RERUN);
        PROP_TESTS_RERUN = new NodeProperty("testsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_TESTS_RERUN);
        PROP_TESTS_ADDED_REMOVED = new NodeProperty("testsRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_TESTS_ADDED_REMOVED);
        PROP_MODEL_ANNOTATION = new NodeProperty("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_ANNOTATION);
        PROP_MODEL_NAME = new NodeProperty("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_NAME);
        PROP_MODEL_USEFOROUTPUT = new NodeProperty("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MODEL_USEFOROUTPUT);
        PROP_MINING_ATTRIBUTE_SETTINGS = new NodeProperty("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_MINING_ATTRIBUTE_SETTINGS);
        PROP_PARTITIONS_MAX_NUM = new NodeProperty("PARTITIONS_MAX_NUM", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_PARTITIONS_MAX_NUM);
        PROP_PARTITIONS_EXPRESSION_EDIT = new NodeProperty("PARTITIONS_EXPRESSION_EDIT", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_PARTITIONS_EXPRESSION_EDIT);
        PROP_ODMS_PARTITION_BUILD_TYPE = new NodeProperty("ODMS_PARTITION_BUILD_TYPE", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PROP_ODMS_PARTITION_BUILD_TYPE);
    }

    private static class Groups {
        private static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        private Groups() {
        }
    }
}

